/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class WrapperInventoryRange
implements IInventory {
    private IInventory src;
    int[] slots;
    protected boolean ignoreValidItems = false;

    public static String concateLines(int[] s, String separator) {
        if (s.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(s[i]);
            }
            return sb.toString();
        }
        return "";
    }

    public WrapperInventoryRange(IInventory a, int[] s, boolean ignoreValid) {
        this.src = a;
        this.slots = s;
        if (this.slots == null) {
            this.slots = new int[0];
        }
        if (AppEngConfiguration.logInventoryAdaptor) {
            AppEng.log("getSizeInventorySide - Configured to use slots " + WrapperInventoryRange.concateLines(this.slots, ",") + " for " + this.src.getClass().getName());
            if (ignoreValid) {
                AppEng.log("Skipping validation testing..");
            }
        }
        this.ignoreValidItems = ignoreValid;
    }

    public WrapperInventoryRange(IInventory a, int _min, int _size, boolean ignoreValid) {
        this.src = a;
        this.slots = new int[_size];
        for (int x = 0; x < _size; ++x) {
            this.slots[x] = _min + x;
        }
        this.ignoreValidItems = ignoreValid;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.src.func_70301_a(this.slots[var1]);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.src.func_70298_a(this.slots[var1], var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.src.func_70304_b(this.slots[var1]);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.src.func_70299_a(this.slots[var1], var2);
    }

    public String func_70303_b() {
        return this.src.func_70303_b();
    }

    public int func_70297_j_() {
        return this.src.func_70297_j_();
    }

    public void func_70296_d() {
        this.src.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.src.func_70300_a(var1);
    }

    public void func_70295_k_() {
        this.src.func_70295_k_();
    }

    public void func_70305_f() {
        this.src.func_70305_f();
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.ignoreValidItems) {
            return true;
        }
        if (AppEngConfiguration.logInventoryAdaptor) {
            boolean valid = this.src.func_94041_b(this.slots[i], itemstack);
            AppEng.log("isStackValidForSlot - Got " + (valid ? "TRUE" : "FALSE") + " for slot " + i + " using " + itemstack.func_77977_a() + " for " + this.src.getClass().getName());
        }
        return this.src.func_94041_b(this.slots[i], itemstack);
    }
}

