/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.networkevents.MENetworkEvent;
import appeng.api.networkevents.MENetworkEventSubscribe;
import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class NetworkEventBus {
    private static Hashtable<Class, Hashtable<Class, MENetworkEventInfo>> events = new Hashtable();
    private Hashtable<Class, List<MENetworkEventReg>> eventSubscribers = new Hashtable();

    private void readClass(Class c) {
        Hashtable classEvents = new Hashtable();
        for (Method m : c.getMethods()) {
            MENetworkEventSubscribe s = m.getAnnotation(MENetworkEventSubscribe.class);
            if (s == null) continue;
            Class<?>[] types = m.getParameterTypes();
            if (types.length == 1) {
                if (MENetworkEvent.class.isAssignableFrom(types[0])) {
                    classEvents.put(types[0], new MENetworkEventInfo(types[0], c, m));
                    continue;
                }
                throw new RuntimeException("Invalid ME Network Event Subscriber, " + m.getName() + "s Parameter must extend MENetworkEvent.");
            }
            throw new RuntimeException("Invalid ME Network Event Subscriber, " + m.getName() + " must have exactly 1 parameter.");
        }
        events.put(c, classEvents);
    }

    private Hashtable<Class, MENetworkEventInfo> getClassInfo(Object o) {
        Class<?> c = o.getClass();
        if (!events.containsKey(c)) {
            this.readClass(c);
        }
        return events.get(c);
    }

    public boolean isEventListener(Object o) {
        return this.getClassInfo(o).size() > 0;
    }

    public void clearRegistrations() {
        this.eventSubscribers.clear();
    }

    public MENetworkEvent postEvent(MENetworkEvent e) {
        Class<?> c = e.getClass();
        if (this.eventSubscribers.containsKey(c)) {
            List<MENetworkEventReg> reg = this.eventSubscribers.get(c);
            int x = 0;
            for (MENetworkEventReg o : reg) {
                try {
                    ++x;
                    o.eventInfo.objMethod.invoke(o.objInfo, e);
                }
                catch (Throwable e1) {
                    FMLLog.severe((String)"[AppEng] Network Event caused exception:", (Object[])new Object[0]);
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
                if (!e.isCanceled()) continue;
                break;
            }
            e.setVisitedObjects(x, reg.size());
        }
        return e;
    }

    public void addSubscriber(Object o) {
        for (MENetworkEventInfo k : this.getClassInfo(o).values()) {
            MENetworkEventReg ne = new MENetworkEventReg(k, o);
            if (this.eventSubscribers.containsKey(k.objEvent)) {
                this.eventSubscribers.get(k.objEvent).add(ne);
                continue;
            }
            ArrayList<MENetworkEventReg> al = new ArrayList<MENetworkEventReg>();
            al.add(ne);
            this.eventSubscribers.put(k.objEvent, al);
        }
    }

    class MENetworkEventReg {
        public final MENetworkEventInfo eventInfo;
        public final Object objInfo;

        public MENetworkEventReg(MENetworkEventInfo inf, Object obj) {
            this.eventInfo = inf;
            this.objInfo = obj;
        }
    }

    class MENetworkEventInfo {
        public final Class objClass;
        public final Method objMethod;
        public final Class objEvent;

        public MENetworkEventInfo(Class Event2, Class ObjClass, Method ObjMethod) {
            this.objClass = ObjClass;
            this.objMethod = ObjMethod;
            this.objEvent = Event2;
        }
    }
}

