/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.IConfigEnum;
import appeng.api.me.util.IConfigManager;
import appeng.interfaces.IConfigEnabledTile;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigManager
implements IConfigManager {
    List<IConfigEnum> Settings = new ArrayList<IConfigEnum>();
    IConfigEnabledTile target;

    public ConfigManager(IConfigEnabledTile tile) {
        this.target = tile;
    }

    public void RegisterSetting(IConfigEnum en) {
        if (en == null) {
            throw new RuntimeException("Invalid Setting");
        }
        this.Settings.add(en);
    }

    @Override
    public List<String> getConfigurations() {
        ArrayList<String> l = new ArrayList<String>();
        for (IConfigEnum e : this.Settings) {
            l.add(e.getName());
        }
        return l;
    }

    @Override
    public String nextConfiguration(String name) {
        for (IConfigEnum e : this.Settings) {
            if (!e.getName().equals(name)) continue;
            String newValue = Platform.nextEnum(e).toString();
            this.setConfiguration(name, newValue);
            return newValue;
        }
        throw new IllegalArgumentException("Invalid Config name.");
    }

    @Override
    public String prevConfiguration(String name) {
        for (IConfigEnum e : this.Settings) {
            if (!e.getName().equals(name)) continue;
            String newValue = Platform.prevEnum(e).toString();
            this.setConfiguration(name, newValue);
            return newValue;
        }
        throw new IllegalArgumentException("Invalid Config name.");
    }

    @Override
    public String setConfiguration(String name, String value) {
        Iterator<IConfigEnum> i = this.Settings.iterator();
        IConfigEnum oldValue = null;
        IConfigEnum newValue = null;
        while (i.hasNext()) {
            newValue = oldValue = i.next();
            if (!oldValue.getName().equals(name)) continue;
            i.remove();
            for (IConfigEnum option : oldValue.getValues()) {
                if (!option.toString().equals(value)) continue;
                newValue = option;
                break;
            }
            if (newValue != oldValue) {
                this.target.updateSetting(newValue);
            }
            this.Settings.add(newValue);
            return oldValue.toString();
        }
        throw new IllegalArgumentException("Invalid Config name.");
    }

    @Override
    public String getConfiguration(String name) {
        for (IConfigEnum e : this.Settings) {
            if (!e.getName().equals(name)) continue;
            return e.toString();
        }
        throw new IllegalArgumentException("Invalid Config name.");
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        IConfigEnum[] list = null;
        for (IConfigEnum e : this.Settings) {
            if (!e.getName().equals(name)) continue;
            list = e.getValues();
        }
        if (list != null) {
            ArrayList<String> out = new ArrayList<String>();
            for (IConfigEnum x : list) {
                out.add(x.toString());
            }
            return out;
        }
        throw new IllegalArgumentException("Invalid Config name.");
    }

    public <E> E loadSetting(IConfigEnum<E> def, NBTTagCompound tagCompound, String name) {
        try {
            String value = tagCompound.func_74779_i(name);
            for (IConfigEnum e : def.getValues()) {
                if (!e.toString().equals(value)) continue;
                this.setConfiguration(def.getName(), value);
                return (E)e;
            }
        }
        catch (Throwable err) {
            // empty catch block
        }
        this.setConfiguration(def.getName(), def.toString());
        return (E)def;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        ArrayList<IConfigEnum> list = new ArrayList<IConfigEnum>();
        list.addAll(this.Settings);
        for (IConfigEnum def : list) {
            this.setConfiguration(def.getName(), tagCompound.func_74779_i(def.getName()));
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        for (IConfigEnum e : this.Settings) {
            tagCompound.func_74778_a(e.getName(), e.toString());
        }
    }

    @Override
    public IConfigEnum getSetting(String sName) {
        for (IConfigEnum e : this.Settings) {
            if (!e.getName().equals(sName)) continue;
            return e;
        }
        return null;
    }

    public void setSetting(IConfigEnum s) {
        if (s == null) {
            return;
        }
        this.setConfiguration(s.getName(), s.toString());
    }
}

