/*
 * Decompiled with CFR 0.152.
 */
package appeng.render;

import appeng.api.exceptions.AppEngException;
import appeng.common.AppEng;
import appeng.common.AppEngRegistration;
import appeng.common.base.AppEngTile;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector3f;

public class BlockRenderer {
    private boolean active = false;
    private IBlockAccess w;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private Tessellator tess;
    private int col;
    private int row;
    private float ox;
    private float oy;
    private float oz;
    private Icon myIco;

    public void begin(IBlockAccess _w, int x, int y, int z) throws AppEngException {
        if (this.active) {
            throw new AppEngException("RENEDER WAS NOT CLOSED PROPERLY!");
        }
        this.tess = Tessellator.field_78398_a;
        this.w = _w;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.row = 0;
        this.col = 0;
        this.active = true;
    }

    public void end() throws AppEngException {
        if (!this.active) {
            throw new AppEngException("RENEDER WAS NOT STARTED PROPERLY!");
        }
        this.active = false;
    }

    void transformPoint(Quaternion q, Vector3f vn, Vector3f out) {
        float len = vn.length();
        if ((double)len > 0.001) {
            vn.normalise();
            Quaternion vecQuat = new Quaternion();
            Quaternion resQuat = new Quaternion();
            vecQuat.x = vn.x;
            vecQuat.y = vn.y;
            vecQuat.z = vn.z;
            vecQuat.w = 0.0f;
            Quaternion.mulInverse((Quaternion)vecQuat, (Quaternion)q, (Quaternion)resQuat);
            Quaternion.mul((Quaternion)q, (Quaternion)resQuat, (Quaternion)vecQuat);
            out.x = len * vecQuat.x;
            out.y = len * vecQuat.y;
            out.z = len * vecQuat.z;
        }
    }

    public Quaternion FromAxis(float x, float y, float z, float angle) {
        Quaternion out = new Quaternion();
        float sinAngle = (float)Math.sin(angle *= 0.5f);
        x *= sinAngle;
        out.y = y * sinAngle;
        out.z = z * sinAngle;
        out.w = (float)Math.cos(angle);
        return out;
    }

    void renderSide(Vector3f Center, Vector3f Left, Vector3f Up, float b, Quaternion ro) {
        Vector3f CenterR = new Vector3f();
        Vector3f LeftR = new Vector3f();
        Vector3f UpR = new Vector3f();
        float uvyA = this.myIco.func_94207_b(0.0);
        float uvyB = this.myIco.func_94207_b(15.0);
        float uvxA = this.myIco.func_94214_a(0.0);
        float uvxB = this.myIco.func_94214_a(15.0);
        this.transformPoint(ro, Center, CenterR);
        this.transformPoint(ro, Left, LeftR);
        this.transformPoint(ro, Up, UpR);
        CenterR.x += this.ox;
        CenterR.y += this.oy;
        CenterR.z += this.oz;
        this.tess.func_78380_c((int)b);
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.tess.func_78374_a((double)(CenterR.x - LeftR.x - UpR.x), (double)(CenterR.y - LeftR.y - UpR.y), (double)(CenterR.z - LeftR.z - UpR.z), (double)uvxA, (double)uvyA);
        this.tess.func_78380_c((int)b);
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.tess.func_78374_a((double)(CenterR.x + LeftR.x - UpR.x), (double)(CenterR.y + LeftR.y - UpR.y), (double)(CenterR.z + LeftR.z - UpR.z), (double)uvxB, (double)uvyA);
        this.tess.func_78380_c((int)b);
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.tess.func_78374_a((double)(CenterR.x + LeftR.x + UpR.x), (double)(CenterR.y + LeftR.y + UpR.y), (double)(CenterR.z + LeftR.z + UpR.z), (double)uvxB, (double)uvyB);
        this.tess.func_78380_c((int)b);
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.tess.func_78374_a((double)(CenterR.x - LeftR.x + UpR.x), (double)(CenterR.y - LeftR.y + UpR.y), (double)(CenterR.z - LeftR.z + UpR.z), (double)uvxA, (double)uvyB);
    }

    public void renderBlockAt(float xOrigin, float yOrigin, float zOrigin, float x, float y, float z, float sx, float sy, float sz, Quaternion rot, AppEngTile te) {
        AppEngRegistration ae = AppEng.getInstance().registration;
        float brightness = ae.blockWorld.func_71874_e(this.w, this.xCoord, this.yCoord + 1, this.zCoord);
        brightness += (float)ae.blockWorld.func_71874_e(this.w, this.xCoord, this.yCoord - 1, this.zCoord);
        brightness += (float)ae.blockWorld.func_71874_e(this.w, this.xCoord, this.yCoord, this.zCoord + 1);
        brightness += (float)ae.blockWorld.func_71874_e(this.w, this.xCoord, this.yCoord, this.zCoord - 1);
        brightness += (float)ae.blockWorld.func_71874_e(this.w, this.xCoord - 1, this.yCoord, this.zCoord);
        brightness += (float)ae.blockWorld.func_71874_e(this.w, this.xCoord + 1, this.yCoord, this.zCoord);
        brightness /= 6.0f;
        float top_mul = 1.0f;
        float bottom_mul = 0.5f;
        float side_mul = 0.8f;
        float side_mulB = 0.6f;
        this.ox = (float)this.xCoord + xOrigin;
        this.oy = (float)this.yCoord + yOrigin;
        this.oz = (float)this.zCoord + zOrigin;
        this.setTextureBox(te.getBlockTextureFromSide(ForgeDirection.UP.ordinal()));
        this.renderSide(new Vector3f(x, y + (sy /= 2.0f), z), new Vector3f(-(sx /= 2.0f), 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, sz /= 2.0f), brightness * top_mul, rot);
        this.setTextureBox(te.getBlockTextureFromSide(ForgeDirection.DOWN.ordinal()));
        this.renderSide(new Vector3f(x, y - sy, z), new Vector3f(sx, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, sz), brightness * bottom_mul, rot);
        this.setTextureBox(te.getBlockTextureFromSide(ForgeDirection.EAST.ordinal()));
        this.renderSide(new Vector3f(x + sx, y, z), new Vector3f(0.0f, sy, 0.0f), new Vector3f(0.0f, 0.0f, sz), brightness * side_mul, rot);
        this.setTextureBox(te.getBlockTextureFromSide(ForgeDirection.WEST.ordinal()));
        this.renderSide(new Vector3f(x - sx, y, z), new Vector3f(0.0f, sy, 0.0f), new Vector3f(0.0f, 0.0f, -sz), brightness * side_mulB, rot);
        this.setTextureBox(te.getBlockTextureFromSide(ForgeDirection.SOUTH.ordinal()));
        this.renderSide(new Vector3f(x, y, z + sz), new Vector3f(0.0f, sy, 0.0f), new Vector3f(-sx, 0.0f, 0.0f), brightness * side_mulB, rot);
        this.setTextureBox(te.getBlockTextureFromSide(ForgeDirection.NORTH.ordinal()));
        this.renderSide(new Vector3f(x, y, z - sz), new Vector3f(0.0f, sy, 0.0f), new Vector3f(sx, 0.0f, 0.0f), brightness * side_mul, rot);
    }

    private void setTextureBox(Icon blockTextureFromSide) {
        this.myIco = blockTextureFromSide;
    }
}

