/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.config.FuzzyMode;
import appeng.api.config.IConfigEnum;
import appeng.api.config.ListMode;
import appeng.api.config.MatchingMode;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.util.IConfigManager;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.IInventoryNotifyable;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.common.registries.AppEngCellRegistry;
import appeng.interfaces.IConfigEnabledTile;
import appeng.interfaces.InvOperation;
import appeng.me.tile.AEAppEngInternalInventory;
import appeng.me.tile.IInternalInventory;
import appeng.util.ConfigManager;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TilePartitioner
extends AppEngTile
implements IConfigEnabledTile,
IConfigureableTile,
IInventoryNotifyable {
    public AppEngInternalInventory cellinv;
    public AEAppEngInternalInventory types;
    public MatchingMode mMode;
    public FuzzyMode fMode;
    public ListMode lMode;
    ConfigManager config = new ConfigManager(this);

    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.GUI;
    }

    @Override
    public void InvChanged(IInternalInventory inv, int slot, InvOperation Operation) {
        IMEInventoryHandler mei;
        if (inv != this.cellinv) {
            return;
        }
        if (this.cellinv.func_70301_a(0) != null && (mei = AppEngCellRegistry.getCellHandler(this.cellinv.func_70301_a(0))) != null && mei.isPreformatted()) {
            List<ItemStack> List2 = mei.getPreformattedItems();
            this.config.setSetting(mei.isFuzzyPreformatted() ? MatchingMode.Fuzzy : MatchingMode.Precision);
            this.config.setSetting(mei.getFuzzyModePreformatted());
            this.config.setSetting(mei.getListMode());
            if (List2 != null) {
                AEAppEngInternalInventory ty = this.types;
                for (int x = 0; x < ty.func_70302_i_(); ++x) {
                    if (x < List2.size()) {
                        ty.func_70299_a(x, List2.get(x));
                        continue;
                    }
                    ty.func_70299_a(x, null);
                }
            }
        }
        this.markForUpdate();
        this.triggerContainerUpdate();
    }

    public TilePartitioner() {
        this.cellinv = new AppEngInternalInventory(this, 1);
        this.types = new AEAppEngInternalInventory(this, 64);
        this.mMode = MatchingMode.Precision;
        this.config.RegisterSetting(this.mMode);
        this.fMode = FuzzyMode.Percent_99;
        this.config.RegisterSetting(this.fMode);
        this.lMode = ListMode.WHITELIST;
        this.config.RegisterSetting(this.lMode);
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.cellinv.func_70301_a(0) != null) {
            drops.add(this.cellinv.func_70301_a(0));
        }
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (ForgeDirection.DOWN == side) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (ForgeDirection.UP == side) {
            return AppEngTextureRegistry.Blocks.BlockPreformatter.get();
        }
        return AppEngTextureRegistry.Blocks.BlockPreformatterSide.get();
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        ItemStack cell = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("cell"));
        this.cellinv.func_70299_a(0, cell);
        this.mMode = this.config.loadSetting(this.mMode, tagCompound, "mMode");
        this.fMode = this.config.loadSetting(this.fMode, tagCompound, "FuzzyMode");
        this.lMode = this.config.loadSetting(this.lMode, tagCompound, "ListMode");
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        NBTTagCompound tag = new NBTTagCompound();
        if (this.cellinv.func_70301_a(0) != null) {
            this.cellinv.func_70301_a(0).func_77955_b(tag);
        }
        tagCompound.func_74778_a("mMode", this.mMode.toString());
        tagCompound.func_74778_a("FuzzyMode", this.fMode.toString());
        tagCompound.func_74778_a("ListMode", this.lMode.toString());
        tagCompound.func_74766_a("cell", tag);
    }

    @Override
    public List<String> getConfigurations() {
        return this.config.getConfigurations();
    }

    @Override
    public String nextConfiguration(String name) {
        return this.config.nextConfiguration(name);
    }

    @Override
    public String prevConfiguration(String name) {
        return this.config.prevConfiguration(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        return this.config.setConfiguration(name, value);
    }

    @Override
    public String getConfiguration(String name) {
        return this.config.getConfiguration(name);
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.config.getConfiguationOptions(name);
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof MatchingMode) {
            this.mMode = (MatchingMode)newValue;
        }
        if (newValue instanceof FuzzyMode) {
            this.fMode = (FuzzyMode)newValue;
        }
        if (newValue instanceof ListMode) {
            this.lMode = (ListMode)newValue;
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }
}

