/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.TileRef;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IGridCache;
import appeng.api.me.util.IGridInterface;
import appeng.me.tile.TileP2PTunnel;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class P2PCache
implements IGridCache {
    public static int index;
    private HashMap<Long, TileP2PTunnel> inputs = new HashMap();
    private Multimap<Long, TileP2PTunnel> Tunnels = LinkedHashMultimap.create();

    @Override
    public void reset(IGridInterface grid) {
        this.Tunnels.clear();
        this.inputs.clear();
        for (TileRef<IGridMachine> m : grid.getMachines()) {
            try {
                IGridMachine gm = m.getTile();
                if (!(gm instanceof TileP2PTunnel)) continue;
                TileP2PTunnel p = (TileP2PTunnel)gm;
                if (p.freq <= 0L) continue;
                if (p.output) {
                    this.Tunnels.put((Object)p.freq, (Object)p);
                    continue;
                }
                if (this.inputs.containsKey(p.freq)) {
                    p.output = true;
                    continue;
                }
                this.inputs.put(p.freq, p);
            }
            catch (AppEngTileMissingException e) {
                e.printStackTrace();
            }
        }
        for (TileP2PTunnel p : this.inputs.values()) {
            p.onChange();
        }
        for (TileP2PTunnel p : this.Tunnels.values()) {
            p.onChange();
        }
    }

    @Override
    public void onUpdateTick(IGridInterface grid) {
    }

    @Override
    public String getCacheName() {
        return "P2PCache";
    }

    @Override
    public NBTTagCompound savetoNBTData() {
        return null;
    }

    @Override
    public void loadfromNBTData(NBTTagCompound data) {
    }

    public Collection<TileP2PTunnel> getOutputs(long freq) {
        return this.Tunnels.get((Object)freq);
    }

    public TileP2PTunnel getInput(long freq) {
        return this.inputs.get(freq);
    }
}

