/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IDismantleable;
import appeng.me.tile.TileController;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockController
extends AppEngSubBlock
implements IDismantleable {
    public BlockController(AppEngMultiBlock mb) {
        super(mb, true);
        this.unlocalizedName = "Controller";
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileController();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        if (side == 0) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (side == 1) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        if (side == 2) {
            return AppEngTextureRegistry.Blocks.MEControllerPower[5].get();
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        if (AppEngConfiguration.logCrafting && AppEngConfiguration.allowLogging) {
            AppEng.log(((TileController)tileEntity).getName() + ": " + p.field_71092_bJ + " opened gui");
            ((TileController)tileEntity).printCraftingStatus();
        }
        Platform.openGui(p, AppEngGuiHandler.GUI_CONTROLLER, w, x, y, z);
        return true;
    }
}

