/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.registries;

import appeng.api.exceptions.AppEngException;
import appeng.api.movable.IMovableHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.movable.IMovableTile;
import appeng.world.DefaultSpatialHandler;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;

public class MovableTileRegistry
implements IMovableRegistry {
    private HashMap<Class<? extends TileEntity>, IMovableHandler> Valid = new HashMap();
    private LinkedList<Class<? extends TileEntity>> test = new LinkedList();
    private LinkedList<IMovableHandler> handlers = new LinkedList();
    private DefaultSpatialHandler dsh = new DefaultSpatialHandler();
    private IMovableHandler nullHandler = new DefaultSpatialHandler();

    private IMovableHandler testClass(Class myClass, TileEntity te) {
        IMovableHandler handler = null;
        for (IMovableHandler iMovableHandler : this.handlers) {
            if (!iMovableHandler.canHandle(myClass, te)) continue;
            handler = iMovableHandler;
            break;
        }
        if (handler != null) {
            this.Valid.put(myClass, handler);
            return handler;
        }
        if (te instanceof IMovableTile) {
            this.Valid.put(myClass, this.dsh);
            return this.dsh;
        }
        for (Class clazz : this.test) {
            if (!clazz.isAssignableFrom(myClass)) continue;
            this.Valid.put(myClass, this.dsh);
            return this.dsh;
        }
        this.Valid.put(myClass, this.nullHandler);
        return this.nullHandler;
    }

    @Override
    public boolean askToMove(TileEntity te) {
        Class<?> myClass = te.getClass();
        IMovableHandler canMove = this.Valid.get(myClass);
        if (canMove == null) {
            canMove = this.testClass(myClass, te);
        }
        if (canMove != this.nullHandler) {
            if (te instanceof IMovableTile) {
                ((IMovableTile)te).prepareToMove();
            }
            te.func_70313_j();
            return true;
        }
        return false;
    }

    @Override
    public void doneMoveing(TileEntity te) {
        if (te instanceof IMovableTile) {
            IMovableTile mt = (IMovableTile)te;
            mt.doneMoving();
        }
    }

    @Override
    public void whiteListTileEntity(Class<? extends TileEntity> c) {
        if (c.getName().equals(TileEntity.class.getName())) {
            throw new RuntimeException(new AppEngException("Someone tried to make all tiles movable, this is a clear violation of the purpose of the white list."));
        }
        this.test.add(c);
    }

    @Override
    public void addHandler(IMovableHandler han) {
        this.handlers.add(han);
    }

    @Override
    public IMovableHandler getHandler(TileEntity te) {
        Class<?> myClass = te.getClass();
        IMovableHandler h = this.Valid.get(myClass);
        return h == null ? this.dsh : h;
    }

    @Override
    public IMovableHandler getDefaultHandler() {
        return this.dsh;
    }
}

