/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.registries;

import appeng.api.IAppEngGrinderRecipe;
import appeng.api.IGrinderRecipeManager;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.registries.entries.AppEngGrinderRecipe;
import appeng.interfaces.IOreListener;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AppEngGrinderRecipeManager
implements IGrinderRecipeManager,
IOreListener {
    public List<IAppEngGrinderRecipe> RecipeList;
    public Map<ItemStack, String> Ores = new HashMap<ItemStack, String>();
    public Map<ItemStack, String> Ingots = new HashMap<ItemStack, String>();
    public Map<String, ItemStack> Dusts = new HashMap<String, ItemStack>();

    public AppEngGrinderRecipeManager() {
        this.RecipeList = new ArrayList<IAppEngGrinderRecipe>();
    }

    @Override
    public List<IAppEngGrinderRecipe> getRecipes() {
        this.log("API - getRecipes");
        return this.RecipeList;
    }

    @Override
    public void addRecipe(ItemStack in, ItemStack out, int cost) {
        this.log("Allow Grinding of " + Platform.getItemDisplayName(in) + " to " + Platform.getItemDisplayName(out) + " for " + cost);
        this.RecipeList.add(new AppEngGrinderRecipe(in.func_77946_l(), out.func_77946_l(), cost));
    }

    @Override
    public IAppEngGrinderRecipe getRecipeForInput(ItemStack input) {
        this.log("Looking up recipe for " + Platform.getItemDisplayName(input));
        if (input != null) {
            for (IAppEngGrinderRecipe r : this.RecipeList) {
                if (!Platform.isSameItem(input, r.getInput())) continue;
                this.log("Recipe for " + input.func_77977_a() + " found " + Platform.getItemDisplayName(r.getOutput()));
                return r;
            }
            this.log("Count not find recipe for " + Platform.getItemDisplayName(input));
        }
        return null;
    }

    public void log(String o) {
        if (AppEngConfiguration.logGrinderOres) {
            AppEng.log("[Grinder Ores] " + o);
        }
    }

    private int getDustToOreRatio(String name) {
        if (name.equals("Obsidian")) {
            return 1;
        }
        if (name.equals("EnderPearl")) {
            return 1;
        }
        if (name.equals("Charcoal")) {
            return 1;
        }
        if (name.equals("Coal")) {
            return 1;
        }
        if (name.contains("Quartz")) {
            return 1;
        }
        return 2;
    }

    public void addOreDiciontaryEntires() {
        this.addOre("Gold", new ItemStack(Block.field_71941_G));
        this.addOre("Iron", new ItemStack(Block.field_71949_H));
        this.addIngot("Gold", new ItemStack(Item.field_77717_p));
        this.addIngot("Iron", new ItemStack(Item.field_77703_o));
        this.addOre("Obsidian", new ItemStack(Block.field_72089_ap));
        this.addOre("EnderPearl", new ItemStack(Item.field_77730_bn));
        this.addOre("Coal", new ItemStack(Item.field_77705_m));
        this.addOre("Charcoal", new ItemStack(Item.field_77705_m, 1, 1));
        AppEng.getInstance().oreDictionary.observe(this);
    }

    private void addOre(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        this.log("Adding Ore - " + name + " : " + Platform.getItemDisplayName(item));
        this.Ores.put(item, name);
        if (this.Dusts.containsKey(name)) {
            ItemStack is = this.Dusts.get(name).func_77946_l();
            is.field_77994_a = this.getDustToOreRatio(name);
            this.addRecipe(item, is, 8);
        }
    }

    private void addIngot(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        this.log("Adding Ingot - " + name + " : " + Platform.getItemDisplayName(item));
        this.Ingots.put(item, name);
        if (this.Dusts.containsKey(name)) {
            this.addRecipe(item, this.Dusts.get(name), 4);
        }
    }

    private void addDust(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        if (this.Dusts.containsKey(name)) {
            this.log("Rejecting Dust - " + name + " : " + Platform.getItemDisplayName(item));
            return;
        }
        this.log("Adding Dust - " + name + " : " + Platform.getItemDisplayName(item));
        this.Dusts.put(name, item);
        for (Map.Entry<ItemStack, String> d : this.Ores.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            ItemStack is = item.func_77946_l();
            is.field_77994_a = this.getDustToOreRatio(name);
            this.addRecipe(d.getKey(), is, 8);
        }
        for (Map.Entry<ItemStack, String> d : this.Ingots.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            this.addRecipe(d.getKey(), item, 4);
        }
    }

    @Override
    public void oreRegistered(String Name, ItemStack item) {
        if (Name.startsWith("ore") || Name.startsWith("ingot") || Name.startsWith("dust")) {
            for (String ore : AppEngConfiguration.grinderOres) {
                if (ore.equals("CertusQuartz") || ore.equals("NetherQuartz")) continue;
                if (Name.equals("ore" + ore)) {
                    this.addOre(ore, item);
                    continue;
                }
                if (Name.equals("ingot" + ore)) {
                    this.addIngot(ore, item);
                    continue;
                }
                if (!Name.equals("dust" + ore)) continue;
                this.addDust(ore, item);
            }
        }
    }
}

