/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.registries;

import appeng.api.ICellHandler;
import appeng.api.ICellRegistry;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AppEngCellRegistry
implements ICellRegistry {
    List<ICellHandler> handlers = new ArrayList<ICellHandler>();

    @Override
    public void addCellHandler(ICellHandler h) {
        if (h != null) {
            this.handlers.add(h);
        }
    }

    @Override
    public boolean isCellHandled(ItemStack is) {
        if (is == null) {
            return false;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IMEInventoryHandler getHandlerForCell(ItemStack is) {
        if (is == null) {
            return null;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return ch.getCellHandler(is);
        }
        return null;
    }

    public static boolean isCell(ItemStack s) {
        if (s == null) {
            return false;
        }
        return AppEng.getApiInstance().getCellRegistry().isCellHandled(s);
    }

    public static IMEInventoryHandler getCellHandler(ItemStack s) {
        if (s == null) {
            return null;
        }
        return AppEng.getApiInstance().getCellRegistry().getHandlerForCell(s);
    }
}

