/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.opengl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.ImageDataFactory;
import org.newdawn.slick.opengl.LoadableImageData;
import org.newdawn.slick.opengl.TGAImageData;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class CursorLoader {
    private static CursorLoader single = new CursorLoader();
    private float transparencyThreshold = 0.8f;

    public static CursorLoader get() {
        return single;
    }

    private CursorLoader() {
    }

    public float getTransparencyThreshold() {
        return this.transparencyThreshold;
    }

    public void setTransparencyThreshold(float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("Value is outside of valid range.");
        }
        this.transparencyThreshold = value;
    }

    private byte applyThreshold(byte alpha) {
        int value = alpha;
        if (value < 0) {
            value = 256 + value;
        }
        if ((float)value > 256.0f * this.transparencyThreshold) {
            return -1;
        }
        return 0;
    }

    public Cursor getCursor(String ref, int x, int y) throws IOException, LWJGLException {
        LoadableImageData imageData = null;
        imageData = ImageDataFactory.getImageDataFor(ref);
        imageData.configureEdging(false);
        ByteBuffer buff = imageData.loadImage(ResourceLoader.getResourceAsStream(ref), true, true, null);
        return this.getCursor(buff, x, y, imageData.getWidth(), imageData.getHeight());
    }

    public Cursor getCursor(ByteBuffer buf, int x, int y, int width, int height) throws IOException, LWJGLException {
        return this.getCursor(buf, x, y, width, height, width, height);
    }

    public Cursor getCursor(ByteBuffer buf, int x, int y, int width, int height, int imageWidth, int imageHeight) throws IOException, LWJGLException {
        int tempY;
        int tempX;
        ByteBuffer tempBuffer;
        byte[] pixelBuffer;
        int targetWidth;
        int targetHeight;
        boolean fullTransparencySupport;
        if (height < imageHeight) {
            throw new IllegalArgumentException("The image height can't be larger then the actual texture size.");
        }
        if (width < imageWidth) {
            throw new IllegalArgumentException("The image width can't be larger then the actual texture size.");
        }
        if (width <= 0 || height <= 0 || imageWidth <= 0 || imageHeight <= 0) {
            throw new IllegalArgumentException("Zero is a illegal value for height and width values");
        }
        int capabilities = Cursor.getCapabilities();
        boolean transparencySupport = (capabilities & 1) != 0;
        boolean bl = fullTransparencySupport = (capabilities & 2) != 0;
        if (!transparencySupport) {
            Log.info("Your system does not support cursors with transparency. The mouse cursor may look messy.");
        }
        for (int i = 0; i < buf.limit(); i += 4) {
            byte red = buf.get(i);
            byte green = buf.get(i + 1);
            byte blue = buf.get(i + 2);
            byte alpha = buf.get(i + 3);
            buf.put(i + 2, red);
            buf.put(i + 1, green);
            buf.put(i, blue);
            if (fullTransparencySupport) {
                buf.put(i + 3, alpha);
                continue;
            }
            if (transparencySupport) {
                buf.put(i + 3, this.applyThreshold(alpha));
                continue;
            }
            buf.put(i + 3, (byte)-1);
        }
        int maxSize = Cursor.getMaxCursorSize();
        int minSize = Cursor.getMinCursorSize();
        int cursorTextureHeight = height;
        int cursorTextureWidth = width;
        int ySpot = imageHeight - y - 1;
        int xSpot = x;
        if (ySpot < 0) {
            ySpot = 0;
        }
        if (cursorTextureHeight > maxSize || cursorTextureWidth > maxSize) {
            targetHeight = Math.min(maxSize, cursorTextureHeight);
            targetWidth = Math.min(maxSize, cursorTextureWidth);
            ySpot -= imageHeight - targetHeight;
            xSpot -= imageWidth - targetWidth;
            pixelBuffer = new byte[4];
            tempBuffer = BufferUtils.createByteBuffer((int)(targetHeight * targetWidth * 4));
            BufferUtils.zeroBuffer((ByteBuffer)tempBuffer);
            for (tempX = 0; tempX < targetHeight; ++tempX) {
                for (tempY = 0; tempY < targetWidth; ++tempY) {
                    buf.position((tempX + tempY * cursorTextureWidth) * 4);
                    buf.get(pixelBuffer);
                    tempBuffer.position((tempX + tempY * targetWidth) * 4);
                    tempBuffer.put(pixelBuffer);
                }
            }
            cursorTextureHeight = targetHeight;
            cursorTextureWidth = targetWidth;
            buf = tempBuffer;
        }
        if (cursorTextureHeight < minSize || cursorTextureWidth < minSize) {
            targetHeight = Math.max(minSize, cursorTextureHeight);
            targetWidth = Math.max(minSize, cursorTextureWidth);
            pixelBuffer = new byte[4];
            tempBuffer = BufferUtils.createByteBuffer((int)(targetHeight * targetWidth * 4));
            BufferUtils.zeroBuffer((ByteBuffer)tempBuffer);
            for (tempX = 0; tempX < imageWidth; ++tempX) {
                for (tempY = 0; tempY < imageHeight; ++tempY) {
                    buf.position((tempX + tempY * cursorTextureWidth) * 4);
                    buf.get(pixelBuffer);
                    tempBuffer.position((tempX + tempY * targetWidth) * 4);
                    tempBuffer.put(pixelBuffer);
                }
            }
            cursorTextureHeight = targetHeight;
            cursorTextureWidth = targetWidth;
            buf = tempBuffer;
        }
        try {
            buf.position(0);
            return new Cursor(cursorTextureWidth, cursorTextureHeight, xSpot, ySpot, 1, buf.asIntBuffer(), null);
        }
        catch (Throwable e) {
            Log.info("Chances are you cursor is too small for this platform");
            throw new LWJGLException(e);
        }
    }

    public Cursor getCursor(ImageData imageData, int x, int y) throws IOException, LWJGLException {
        return this.getCursor(imageData.getImageBufferData(), x, y, imageData.getTexWidth(), imageData.getTexHeight(), imageData.getWidth(), imageData.getHeight());
    }

    public Cursor getAnimatedCursor(String ref, int x, int y, int width, int height, int[] cursorDelays) throws IOException, LWJGLException {
        IntBuffer cursorDelaysBuffer = ByteBuffer.allocateDirect(cursorDelays.length * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        for (int i = 0; i < cursorDelays.length; ++i) {
            cursorDelaysBuffer.put(cursorDelays[i]);
        }
        cursorDelaysBuffer.flip();
        TGAImageData imageData = new TGAImageData();
        ByteBuffer buf = imageData.loadImage(ResourceLoader.getResourceAsStream(ref), false, null);
        return new Cursor(width, height, x, y, cursorDelays.length, buf.asIntBuffer(), cursorDelaysBuffer);
    }
}

