/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Vector3;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.net.PacketWrapper;
import powercrystals.minefactoryreloaded.block.BlockRedNetCable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.net.GridTickHandler;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneEnergyNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;

public class TileEntityRedNetEnergy
extends TileEntityRedNetCable
implements IPowerEmitter,
IEnergySink,
IEnergyHandler {
    private byte[] sideMode = new byte[]{1, 1, 1, 1, 1, 1, 0};
    private IEnergyHandler[] handlerCache = null;
    private IPowerReceptor[] receiverCache = null;
    private IEnergySource[] sourceCache = null;
    private IEnergySink[] sinkCache = null;
    private boolean deadCache = false;
    int energyForGrid = 0;
    boolean isNode = false;
    RedstoneEnergyNetwork grid;

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        this.deadCache = true;
        this.handlerCache = null;
        this.receiverCache = null;
        this.sourceCache = null;
        this.sinkCache = null;
        GridTickHandler.addConduit(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.grid != null) {
            this.grid.removeConduit(this);
            this.grid.storage.modifyEnergyStored(-this.energyForGrid);
            int n = 0;
            int n2 = 6;
            while (n2-- > 0) {
                if (this.sideMode[n2] >> 1 != 4) continue;
                ++n;
            }
            if (n > 1) {
                this.grid.regenerate();
            }
        }
    }

    private void reCache() {
        if (this.deadCache) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                this.onNeighborTileChange(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ);
            }
            this.deadCache = false;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        this.updateInternalTypes();
    }

    public void firstTick() {
        if (this.field_70331_k == null) {
            return;
        }
        this.reCache();
        if (this.grid == null) {
            this.incorporateTiles();
            this.func_70296_d();
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if (this.grid == null & !this.field_70331_k.field_72995_K) {
            this.setGrid(new RedstoneEnergyNetwork(this));
        }
    }

    @Override
    public void onNeighboorChanged() {
        super.onNeighboorChanged();
        this.deadCache = true;
        this.reCache();
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        TileEntity tileEntity = this.field_70331_k.func_72796_p(n, n2, n3);
        if (n < this.field_70329_l) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_70329_l) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_70327_n) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_70327_n) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_70330_m) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_70330_m) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity, int n) {
        PowerHandler.PowerReceiver powerReceiver;
        if (this.handlerCache != null) {
            this.handlerCache[n] = null;
        }
        if (this.receiverCache != null) {
            this.receiverCache[n] = null;
        }
        if (this.sourceCache != null) {
            this.sourceCache[n] = null;
        }
        if (this.sinkCache != null) {
            this.sinkCache[n] = null;
        }
        byte by = this.sideMode[n];
        int n2 = n;
        this.sideMode[n2] = (byte)(this.sideMode[n2] & 1);
        if (tileEntity instanceof TileEntityRedNetEnergy) {
            if (((TileEntityRedNetEnergy)tileEntity).canInterface(this)) {
                this.sideMode[n] = 9;
                if (((TileEntityRedNetEnergy)tileEntity).grid == null) {
                    ((TileEntityRedNetEnergy)tileEntity).setGrid(this.grid);
                }
            }
        } else if (tileEntity instanceof IEnergyHandler) {
            if (((IEnergyHandler)tileEntity).canInterface(ForgeDirection.VALID_DIRECTIONS[n])) {
                if (this.handlerCache == null) {
                    this.handlerCache = new IEnergyHandler[6];
                }
                this.handlerCache[n] = (IEnergyHandler)tileEntity;
                int n3 = n;
                this.sideMode[n3] = (byte)(this.sideMode[n3] | 2);
            }
        } else if (tileEntity instanceof IEnergyTile) {
            ForgeDirection forgeDirection = ForgeDirection.VALID_DIRECTIONS[n];
            if (tileEntity instanceof IEnergySource && ((IEnergySource)tileEntity).emitsEnergyTo(this, forgeDirection)) {
                if (this.sourceCache == null) {
                    this.sourceCache = new IEnergySource[6];
                }
                this.sourceCache[n] = (IEnergySource)tileEntity;
                int n4 = n;
                this.sideMode[n4] = (byte)(this.sideMode[n4] | 6);
            }
            if (tileEntity instanceof IEnergySink && ((IEnergySink)tileEntity).acceptsEnergyFrom(this, forgeDirection)) {
                if (this.sinkCache == null) {
                    this.sinkCache = new IEnergySink[6];
                }
                this.sinkCache[n] = (IEnergySink)tileEntity;
                int n5 = n;
                this.sideMode[n5] = (byte)(this.sideMode[n5] | 6);
            }
        } else if (tileEntity instanceof IPowerReceptor && (powerReceiver = ((IPowerReceptor)tileEntity).getPowerReceiver(ForgeDirection.VALID_DIRECTIONS[n])) != null) {
            if (this.receiverCache == null) {
                this.receiverCache = new IPowerReceptor[6];
            }
            this.receiverCache[n] = (IPowerReceptor)tileEntity;
            int n6 = n;
            this.sideMode[n6] = (byte)(this.sideMode[n6] | 4);
        }
        if (!this.deadCache) {
            this.updateInternalTypes();
            if (by != this.sideMode[n]) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    private void incorporateTiles() {
        if (this.grid != null) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity;
                if (!this.field_70331_k.func_72899_e(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ) || !((tileEntity = this.field_70331_k.func_72796_p(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ)) instanceof TileEntityRedNetEnergy)) continue;
                this.grid.addConduit((TileEntityRedNetEnergy)tileEntity);
            }
        } else {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity;
                if (!this.field_70331_k.func_72899_e(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ) || !((tileEntity = this.field_70331_k.func_72796_p(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ)) instanceof TileEntityRedNetEnergy) || ((TileEntityRedNetEnergy)tileEntity).grid == null) continue;
                ((TileEntityRedNetEnergy)tileEntity).grid.addConduit(this);
                break;
            }
        }
    }

    @Override
    public Packet func_70319_e() {
        if (this.deadCache) {
            return null;
        }
        return PacketWrapper.createPacket((String)"MFReloaded", (int)21, (Object[])new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, this._sideColors[0], this._sideColors[1], this._sideColors[2], this._sideColors[3], this._sideColors[4], this._sideColors[5], this.cableMode[0] | this.cableMode[1] << 8 | this.cableMode[2] << 16 | this.cableMode[3] << 24, this.cableMode[4] | this.cableMode[5] << 8 | this.cableMode[6] << 16, this.sideMode[0], this.sideMode[1], this.sideMode[2], this.sideMode[3], this.sideMode[4], this.sideMode[5]});
    }

    @SideOnly(value=Side.CLIENT)
    public void setModes(byte[] byArray) {
        this.sideMode = byArray;
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if ((this.sideMode[forgeDirection.ordinal()] & 1) != 0 & this.grid != null) {
            return this.grid.storage.receiveEnergy(n, bl);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection forgeDirection) {
        return (this.sideMode[forgeDirection.ordinal()] & 1) != 0 & this.grid != null;
    }

    @Override
    public int getEnergyStored(ForgeDirection forgeDirection) {
        if ((this.sideMode[forgeDirection.ordinal()] & 1) != 0 & this.grid != null) {
            return this.grid.storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        if ((this.sideMode[forgeDirection.ordinal()] & 1) != 0 & this.grid != null) {
            return this.grid.storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection forgeDirection) {
        return this.canInterface(forgeDirection);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return this.canInterface(forgeDirection);
    }

    @Override
    public double demandedEnergyUnits() {
        return 250.0;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection forgeDirection, double d) {
        if ((this.sideMode[forgeDirection.ordinal()] & 1) != 0) {
            int n = (int)(d * 4.0);
            return d - (double)((float)this.grid.storage.receiveEnergy(n, false) / 4.0f);
        }
        return d;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public boolean isInterfacing(ForgeDirection forgeDirection) {
        int n = forgeDirection.getOpposite().ordinal();
        int n2 = this.sideMode[n] >> 1;
        return (this.sideMode[n] & 1) != 0 & n2 != 0;
    }

    public int interfaceMode(ForgeDirection forgeDirection) {
        int n = forgeDirection.getOpposite().ordinal();
        int n2 = this.sideMode[n] >> 1;
        return (this.sideMode[n] & 1) != 0 ? n2 : 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this.sideMode = nBTTagCompound.func_74770_j("SideMode");
        if (this.sideMode.length != 7) {
            this.sideMode = new byte[]{1, 1, 1, 1, 1, 1, 0};
        }
        this.energyForGrid = nBTTagCompound.func_74762_e("Energy");
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74773_a("SideMode", this.sideMode);
        if (this.grid != null) {
            if (this.isNode) {
                this.energyForGrid = this.grid.getNodeShare(this);
                nBTTagCompound.func_74768_a("Energy", this.energyForGrid);
            }
        } else if (this.energyForGrid > 0) {
            nBTTagCompound.func_74768_a("Energy", this.energyForGrid);
        } else {
            this.energyForGrid = 0;
        }
    }

    void extract(ForgeDirection forgeDirection) {
        if (this.deadCache) {
            return;
        }
        int n = forgeDirection.ordinal();
        if ((this.sideMode[n] & 1) != 0) {
            switch (this.sideMode[n] >> 1) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    int n2;
                    IEnergySource iEnergySource;
                    if (this.sourceCache == null || (iEnergySource = this.sourceCache[n]) == null || (n2 = Math.min((int)(iEnergySource.getOfferedEnergy() * 4.0), 1000)) <= 0 || (n2 = this.grid.storage.receiveEnergy(n2, false)) <= 0) break;
                    iEnergySource.drawEnergy((float)n2 / 4.0f);
                    break;
                }
            }
        }
    }

    int transfer(ForgeDirection forgeDirection, int n) {
        if (this.deadCache) {
            return 0;
        }
        int n2 = forgeDirection.ordinal();
        if ((this.sideMode[n2] & 1) != 0) {
            switch (this.sideMode[n2] >> 1) {
                case 1: {
                    IEnergyHandler iEnergyHandler = this.handlerCache[n2];
                    if (iEnergyHandler == null) break;
                    return iEnergyHandler.receiveEnergy(forgeDirection, n, false);
                }
                case 2: {
                    float f;
                    float f2;
                    IPowerReceptor iPowerReceptor = this.receiverCache[n2];
                    PowerHandler.PowerReceiver powerReceiver = null;
                    if (iPowerReceptor != null) {
                        powerReceiver = iPowerReceptor.getPowerReceiver(forgeDirection);
                    }
                    if (powerReceiver == null || !((f2 = Math.min(f = powerReceiver.getMaxEnergyReceived(), powerReceiver.getMaxEnergyStored() - powerReceiver.getEnergyStored())) > 0.0f)) break;
                    f2 = Math.min((float)n / 10.0f, f2);
                    return (int)Math.ceil(powerReceiver.receiveEnergy(PowerHandler.Type.PIPE, f2, forgeDirection) * 10.0f);
                }
                case 3: {
                    IEnergySink iEnergySink;
                    if (this.sinkCache == null || (iEnergySink = this.sinkCache[n2]) == null) break;
                    int n3 = (int)Math.min((long)iEnergySink.getMaxSafeInput() * 4L, (long)n);
                    n3 = Math.min((int)(iEnergySink.demandedEnergyUnits() * 4.0), n3);
                    if (n3 <= 0) break;
                    n3 -= (int)Math.ceil(iEnergySink.injectEnergyUnits(forgeDirection, (float)n3 / 4.0f) * 4.0);
                    return n3;
                }
            }
        }
        return 0;
    }

    void setGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        this.grid = redstoneEnergyNetwork;
        if (this.grid != null && !this.grid.isRegenerating()) {
            this.incorporateTiles();
        }
    }

    public void updateInternalTypes() {
        if (this.deadCache) {
            return;
        }
        this.isNode = false;
        for (int i = 0; i < 6; ++i) {
            int n;
            if (!((this.sideMode[i] & 1) != 0 & (n = this.sideMode[i] >> 1) != 0 & n != 4)) continue;
            this.isNode = true;
        }
        if (this.grid != null) {
            this.grid.addConduit(this);
        }
    }

    @Override
    public boolean onPartHit(EntityPlayer entityPlayer, int n, int n2) {
        if (n2 >= 26 && n2 < 32 && MFRUtil.isHoldingUsableTool(entityPlayer, this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            int n3 = ForgeDirection.OPPOSITES[n];
            this.sideMode[n3] = (byte)(this.sideMode[n3] ^ 1);
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.updateInternalTypes();
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> var1_1, boolean var2_2) {
        var3_3 = new Vector3((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n);
        var4_4 = new IndexedCuboid6((Object)1, BlockRedNetCable.subSelection[1]);
        var1_1.add(var4_4);
        var5_5 = ForgeDirection.VALID_DIRECTIONS;
        var6_6 = ForgeDirection.OPPOSITES;
        var7_7 = var5_5.length;
        while (var7_7-- > 0) {
            block9: {
                block7: {
                    block8: {
                        var8_8 = this.getConnectionState(var5_5[var7_7], true);
                        var9_9 = this.getConnectionState(var5_5[var7_7], false);
                        var10_10 = this.sideMode[var6_6[var7_7]] >> 1;
                        var11_11 = var10_10 > 0 & var10_10 != 4;
                        if (!var8_8.isConnected) break block7;
                        var12_12 = 2 + var7_7;
                        if (!var8_8.isPlate) break block8;
                        var12_12 += 6;
                        ** GOTO lbl-1000
                    }
                    if (var8_8.isCable && var8_8.isAllSubnets) {
                        if (var2_2) {
                            var4_4.setSide(var7_7, (double)(var7_7 & 1));
                            continue;
                        }
                        if (!(var11_11 | var10_10 == 4)) {
                            var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)(20 + var7_7), BlockRedNetCable.subSelection[20 + var7_7]).add(var3_3));
                            continue;
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)var12_12, BlockRedNetCable.subSelection[var12_12]).add(var3_3));
                        var12_12 = 14 + var7_7;
                        if (var8_8.isSingleSubnet) {
                            var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)var12_12, BlockRedNetCable.subSelection[var12_12]).add(var3_3));
                        }
                    }
                    break block9;
                }
                if (var2_2 & var9_9.isConnected && this.cableMode[6] != 1) {
                    var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)(2 + var7_7), BlockRedNetCable.subSelection[2 + var7_7]).add(var3_3));
                }
            }
            if (!(var11_11 | var2_2 == false & var10_10 == 4)) continue;
            var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)(26 + var7_7), BlockRedNetCable.subSelection[26 + var7_7]).add(var3_3));
        }
        var4_4.add(var3_3);
    }

    @Override
    public void getTileInfo(List<String> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        super.getTileInfo(list, forgeDirection, entityPlayer, bl && entityPlayer.func_70093_af());
        if (this.grid != null) {
            list.add("Saturation: " + Math.ceil((float)this.grid.storage.getEnergyStored() / (float)this.grid.storage.getMaxEnergyStored() * 1000.0f) / 10.0);
        } else if (!bl) {
            list.add("Null Grid");
        }
        if (bl) {
            if (this.grid != null) {
                list.add("Grid:" + this.grid);
                list.add("Conduits: " + this.grid.getConduitCount() + ", Nodes: " + this.grid.getNodeCount());
                list.add("Grid Max: " + this.grid.storage.getMaxEnergyStored());
                list.add("Grid Cur: " + this.grid.storage.getEnergyStored());
            } else {
                list.add("Null Grid");
            }
            list.add("SideType: " + Arrays.toString(this.sideMode));
            list.add("Node: " + this.isNode);
            return;
        }
    }

    public String toString() {
        return "(x=" + this.field_70329_l + ",y=" + this.field_70330_m + ",z=" + this.field_70327_n + ")@" + this.hashCode();
    }
}

