/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Vector3;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.net.PacketWrapper;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.INeighboorUpdateTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetDecorative;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNoConnection;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.block.BlockRedNetCable;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;

public class TileEntityRedNetCable
extends TileEntity
implements INeighboorUpdateTile {
    protected int[] _sideColors = new int[6];
    protected byte[] cableMode = new byte[]{0, 0, 0, 0, 0, 0, 0};
    private RedstoneNetwork _network;
    private boolean _needsNetworkUpdate;
    private static final int _maxVanillaBlockId = 158;
    private static List<Integer> _connectionWhitelist = Arrays.asList(23, 25, 27, 28, 29, 33, 46, 55, 64, 69, 70, 71, 72, 75, 76, 77, 93, 94, 96, 107, 123, 124, 131, 143, 147, 148, 149, 150, 151, 152, 154, 157, 158);
    private static List<Integer> _connectionBlackList;

    public TileEntityRedNetCable() {
        if (_connectionBlackList == null) {
            _connectionBlackList = new LinkedList<Integer>();
            for (String string : MFRConfig.redNetConnectionBlacklist.getString().replace("\"", "").split(",")) {
                try {
                    int n = Integer.parseInt(string.trim());
                    _connectionBlackList.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Empty or invalid rednet blacklist entry found. Not adding to rednet blacklist.");
                }
            }
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.onChunkUnload();
    }

    public void setSideColor(ForgeDirection forgeDirection, int n) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return;
        }
        this._sideColors[forgeDirection.ordinal()] = n;
        this.updateNetwork();
    }

    public int getSideColor(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return this._sideColors[forgeDirection.ordinal()];
    }

    public int getSideColorValue(ForgeDirection forgeDirection) {
        return ItemDye.field_77859_b[~this.getSideColor(forgeDirection) & 0xF] << 8 | 0xFF;
    }

    public byte getMode(int n) {
        return this.cableMode[n];
    }

    public void setMode(int n, byte by) {
        boolean bl = by != this.cableMode[n];
        this.cableMode[n] = by;
        if (bl) {
            this._needsNetworkUpdate = true;
        }
    }

    public RedNetConnectionType getConnectionState(ForgeDirection forgeDirection) {
        return this.getConnectionState(forgeDirection, true);
    }

    protected RedNetConnectionType getConnectionState(ForgeDirection forgeDirection, boolean bl) {
        int n = this.cableMode[forgeDirection.ordinal()];
        if (!bl) {
            n = 1;
        }
        if (this.cableMode[6] == 1) {
            n = 3;
        }
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        blockPosition.orientation = forgeDirection;
        blockPosition.moveForwards(1);
        int n2 = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        Block block = Block.field_71973_m[n2];
        if (block == null) {
            return RedNetConnectionType.None;
        }
        if (n2 == MineFactoryReloadedCore.rednetCableBlock.field_71990_ca) {
            return RedNetConnectionType.CableAll;
        }
        if (n == 3) {
            return RedNetConnectionType.None;
        }
        if (block instanceof IConnectableRedNet) {
            RedNetConnectionType redNetConnectionType = ((IConnectableRedNet)block).getConnectionType(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirection.getOpposite());
            return redNetConnectionType.isConnectionForced & !(n == 1 | n == 2) ? RedNetConnectionType.None : redNetConnectionType;
        }
        if (block instanceof IRedNetNoConnection || block.isAirBlock(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z)) {
            return RedNetConnectionType.None;
        }
        if (n == 2 && block.isBlockSolidOnSide(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirection.getOpposite())) {
            return RedNetConnectionType.ForcedCableSingle;
        }
        if (n == 1) {
            return RedNetConnectionType.ForcedPlateSingle;
        }
        if (n2 <= 158 && !_connectionWhitelist.contains(n2) || _connectionBlackList.contains(n2) || block instanceof IRedNetDecorative) {
            return RedNetConnectionType.None;
        }
        if (block.isBlockSolidOnSide(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirection.getOpposite())) {
            return RedNetConnectionType.CableSingle;
        }
        return RedNetConnectionType.PlateSingle;
    }

    public Packet func_70319_e() {
        return PacketWrapper.createPacket((String)"MFReloaded", (int)11, (Object[])new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, this._sideColors[0], this._sideColors[1], this._sideColors[2], this._sideColors[3], this._sideColors[4], this._sideColors[5], this.cableMode[0] | this.cableMode[1] << 8 | this.cableMode[2] << 16 | this.cableMode[3] << 24, this.cableMode[4] | this.cableMode[5] << 8 | this.cableMode[6] << 16});
    }

    public void func_70312_q() {
        super.func_70312_q();
        this._needsNetworkUpdate = true;
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this._network != null && this._network.isInvalid()) {
            this._network = null;
            this._needsNetworkUpdate = true;
        }
        if (this._needsNetworkUpdate) {
            this._needsNetworkUpdate = false;
            this.updateNetwork();
        }
        this._network.tick();
    }

    public boolean onPartHit(EntityPlayer entityPlayer, int n, int n2) {
        return false;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> list, boolean bl) {
        Vector3 vector3 = new Vector3((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n);
        IndexedCuboid6 indexedCuboid6 = new IndexedCuboid6((Object)0, BlockRedNetCable.subSelection[0]);
        list.add(indexedCuboid6);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = forgeDirectionArray.length;
        while (n-- > 0) {
            RedNetConnectionType redNetConnectionType = this.getConnectionState(forgeDirectionArray[n], true);
            RedNetConnectionType redNetConnectionType2 = this.getConnectionState(forgeDirectionArray[n], false);
            if (redNetConnectionType.isConnected) {
                int n2 = 2 + n;
                if (redNetConnectionType.isPlate) {
                    n2 += 6;
                } else if (redNetConnectionType.isCable && redNetConnectionType.isAllSubnets) {
                    if (bl) {
                        indexedCuboid6.setSide(n, (double)(n & 1));
                        continue;
                    }
                    list.add((IndexedCuboid6)new IndexedCuboid6((Object)(20 + n), BlockRedNetCable.subSelection[20 + n]).add(vector3));
                    continue;
                }
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)n2, BlockRedNetCable.subSelection[n2]).add(vector3));
                n2 = 14 + n;
                if (!redNetConnectionType.isSingleSubnet) continue;
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)n2, BlockRedNetCable.subSelection[n2]).add(vector3));
                continue;
            }
            if (!(bl & redNetConnectionType2.isConnected) || this.cableMode[6] == 1) continue;
            list.add((IndexedCuboid6)new IndexedCuboid6((Object)(2 + n), BlockRedNetCable.subSelection[2 + n]).add(vector3));
        }
        indexedCuboid6.add(vector3);
    }

    public boolean canInterface(TileEntityRedNetCable tileEntityRedNetCable) {
        return true;
    }

    public void getTileInfo(List<String> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            if (this._network != null) {
                list.add("Grid:" + this._network);
            } else {
                list.add("Null Grid");
            }
            list.add("SideMode: " + Arrays.toString(this.cableMode));
            return;
        }
    }

    public void onNeighboorChanged() {
        this._needsNetworkUpdate = true;
    }

    public RedstoneNetwork getNetwork() {
        return this._network;
    }

    public void setNetwork(RedstoneNetwork redstoneNetwork) {
        this._network = redstoneNetwork;
        this._network.addCable(new BlockPosition((TileEntity)this));
    }

    private void updateNetwork() {
        TileEntityRedNetCable tileEntityRedNetCable;
        TileEntity tileEntity;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        RedstoneNetwork.log("Cable at %s updating network", blockPosition.toString());
        if (this._network == null) {
            for (BlockPosition blockPosition2 : blockPosition.getAdjacent(true)) {
                tileEntity = blockPosition2.getTileEntity(this.field_70331_k);
                if (!(tileEntity instanceof TileEntityRedNetCable) || (tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity).getNetwork() == null || tileEntityRedNetCable.getNetwork().isInvalid()) continue;
                this._network = tileEntityRedNetCable.getNetwork();
                break;
            }
        }
        if (this._network == null) {
            RedstoneNetwork.log("Initializing new network at %s", blockPosition.toString());
            this.setNetwork(new RedstoneNetwork(this.field_70331_k));
        }
        for (BlockPosition blockPosition2 : blockPosition.getAdjacent(true)) {
            tileEntity = blockPosition2.getTileEntity(this.field_70331_k);
            if (tileEntity instanceof TileEntityRedNetCable) {
                tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
                if (tileEntityRedNetCable.getNetwork() == null) {
                    tileEntityRedNetCable.setNetwork(this._network);
                    continue;
                }
                if (tileEntityRedNetCable.getNetwork() == this._network || tileEntityRedNetCable.getNetwork() == null || tileEntityRedNetCable.getNetwork().isInvalid()) continue;
                this._network.mergeNetwork(tileEntityRedNetCable.getNetwork());
                continue;
            }
            this.updateNearbyNode(blockPosition2);
        }
    }

    public void updateNodes() {
        for (BlockPosition blockPosition : new BlockPosition((TileEntity)this).getAdjacent(true)) {
            this.updateNearbyNode(blockPosition);
        }
    }

    private void updateNearbyNode(BlockPosition blockPosition) {
        int n = this.getSideColor(blockPosition.orientation);
        RedNetConnectionType redNetConnectionType = this.getConnectionState(blockPosition.orientation);
        if (!this.field_70331_k.func_72799_c(blockPosition.x, blockPosition.y, blockPosition.z)) {
            if (redNetConnectionType.isAllSubnets) {
                this._network.addOrUpdateNode(blockPosition);
            } else if (redNetConnectionType.isCable) {
                this._network.addOrUpdateNode(blockPosition, n, false);
            } else if (redNetConnectionType.isPlate) {
                this._network.addOrUpdateNode(blockPosition, n, true);
            } else {
                this._network.removeNode(blockPosition);
            }
        } else {
            this._network.removeNode(blockPosition);
        }
    }

    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74783_a("sideSubnets", this._sideColors);
        nBTTagCompound.func_74774_a("mode", this.cableMode[0]);
        nBTTagCompound.func_74774_a("v", (byte)3);
        nBTTagCompound.func_74773_a("cableMode", this.cableMode);
    }

    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._sideColors = nBTTagCompound.func_74759_k("sideSubnets");
        if (this._sideColors.length == 0) {
            this._sideColors = new int[6];
        }
        byte by = nBTTagCompound.func_74771_c("mode");
        this.cableMode = nBTTagCompound.func_74770_j("cableMode");
        if (this.cableMode.length < 6) {
            this.cableMode = new byte[]{0, 0, 0, 0, 0, 0, 0};
        }
        switch (nBTTagCompound.func_74771_c("v")) {
            case 2: {
                this.cableMode[6] = (byte)(this.cableMode[6] == 3 ? 1 : 0);
                break;
            }
            case 0: {
                if (by == 2) {
                    by = 3;
                }
            }
            case 1: {
                this.cableMode = new byte[]{by, by, by, by, by, by, (byte)(by == 3 ? 1 : 0)};
                break;
            }
        }
    }

    public boolean isSolidOnSide(int n) {
        return this.cableMode[n] != 3 & this.cableMode[6] != 1;
    }

    public boolean shouldRenderInPass(int n) {
        return false;
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
    }
}

