/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cofh.api.energy.EnergyStorage;
import java.util.LinkedHashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.net.GridTickHandler;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class RedstoneEnergyNetwork {
    public static final int TRANSFER_RATE = 1000;
    public static final int STORAGE = 6000;
    private LinkedHashSet<TileEntityRedNetEnergy> nodeSet = new LinkedHashSet();
    private LinkedHashSet<TileEntityRedNetEnergy> conduitSet;
    private TileEntityRedNetEnergy master;
    private boolean regenerating = false;
    EnergyStorage storage = new EnergyStorage(480, 80);
    public int distribution;
    public int distributionSide;

    protected RedstoneEnergyNetwork() {
        this.storage.setCapacity(6000);
        this.storage.setMaxTransfer(1000);
    }

    public RedstoneEnergyNetwork(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        this();
        this.conduitSet = new LinkedHashSet();
        this.addConduit(tileEntityRedNetEnergy);
    }

    public int getNodeShare(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        int n = this.nodeSet.size();
        if (n == 1) {
            return this.storage.getEnergyStored();
        }
        int n2 = 0;
        if (this.master == tileEntityRedNetEnergy) {
            n2 = this.storage.getEnergyStored() % n;
        }
        return n2 + this.storage.getEnergyStored() / n;
    }

    public void addConduit(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        if (this.conduitSet.add(tileEntityRedNetEnergy) && !this.conduitAdded(tileEntityRedNetEnergy)) {
            return;
        }
        if (tileEntityRedNetEnergy.isNode) {
            if (this.nodeSet.add(tileEntityRedNetEnergy)) {
                this.nodeAdded(tileEntityRedNetEnergy);
            }
        } else if (!this.nodeSet.isEmpty()) {
            int n = this.getNodeShare(tileEntityRedNetEnergy);
            if (this.nodeSet.remove(tileEntityRedNetEnergy)) {
                tileEntityRedNetEnergy.energyForGrid = this.storage.extractEnergy(n, false);
                this.nodeRemoved(tileEntityRedNetEnergy);
            }
        }
    }

    public void removeConduit(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        this.conduitSet.remove(tileEntityRedNetEnergy);
        if (!this.nodeSet.isEmpty()) {
            int n = this.getNodeShare(tileEntityRedNetEnergy);
            if (this.nodeSet.remove(tileEntityRedNetEnergy)) {
                tileEntityRedNetEnergy.energyForGrid = this.storage.extractEnergy(n, false);
                this.nodeRemoved(tileEntityRedNetEnergy);
            }
        }
    }

    public void regenerate() {
        this.regenerating = true;
        GridTickHandler.regenerateGrid(this);
    }

    public boolean isRegenerating() {
        return this.regenerating;
    }

    public void markSweep() {
        RedstoneEnergyNetwork redstoneEnergyNetwork;
        this.destroyGrid();
        if (this.conduitSet.isEmpty()) {
            return;
        }
        TileEntityRedNetEnergy tileEntityRedNetEnergy = (TileEntityRedNetEnergy)this.conduitSet.iterator().next();
        LinkedHashSet<TileEntityRedNetEnergy> linkedHashSet = this.conduitSet;
        this.nodeSet.clear();
        this.conduitSet = new LinkedHashSet(Math.min(linkedHashSet.size() / 6, 5));
        this.rebalanceGrid();
        LinkedHashSet<TileEntityRedNetEnergy> linkedHashSet2 = new LinkedHashSet<TileEntityRedNetEnergy>();
        BlockPosition blockPosition = new BlockPosition(0, 0, 0);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        linkedHashSet2.add(tileEntityRedNetEnergy);
        while (!linkedHashSet2.isEmpty()) {
            tileEntityRedNetEnergy = (TileEntityRedNetEnergy)linkedHashSet2.iterator().next();
            this.addConduit(tileEntityRedNetEnergy);
            redstoneEnergyNetwork = tileEntityRedNetEnergy.field_70331_k;
            int n = 6;
            while (n-- > 0) {
                TileEntity tileEntity;
                blockPosition.x = tileEntityRedNetEnergy.field_70329_l;
                blockPosition.y = tileEntityRedNetEnergy.field_70330_m;
                blockPosition.z = tileEntityRedNetEnergy.field_70327_n;
                blockPosition.orientation = forgeDirectionArray[n];
                blockPosition.moveForwards(1);
                if (!redstoneEnergyNetwork.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z) || !((tileEntity = blockPosition.getTileEntity((World)redstoneEnergyNetwork)) instanceof TileEntityRedNetEnergy) || !tileEntityRedNetEnergy.canInterface((TileEntityRedNetEnergy)tileEntity) || this.conduitSet.contains(tileEntity)) continue;
                linkedHashSet2.add((TileEntityRedNetEnergy)tileEntity);
            }
            linkedHashSet2.remove(tileEntityRedNetEnergy);
            linkedHashSet.remove(tileEntityRedNetEnergy);
        }
        if (!linkedHashSet.isEmpty()) {
            redstoneEnergyNetwork = new RedstoneEnergyNetwork();
            redstoneEnergyNetwork.conduitSet = linkedHashSet;
            redstoneEnergyNetwork.regenerating = true;
            redstoneEnergyNetwork.markSweep();
        }
        if (this.nodeSet.isEmpty()) {
            GridTickHandler.removeGrid(this);
        } else {
            GridTickHandler.addGrid(this);
        }
        this.regenerating = false;
    }

    public void destroyGrid() {
        this.master = null;
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : this.nodeSet) {
            this.destroyNode(tileEntityRedNetEnergy);
        }
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : this.conduitSet) {
            this.destroyConduit(tileEntityRedNetEnergy);
        }
        GridTickHandler.removeGrid(this);
    }

    public void destroyNode(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        tileEntityRedNetEnergy.energyForGrid = this.getNodeShare(tileEntityRedNetEnergy);
        tileEntityRedNetEnergy.setGrid(null);
    }

    public void destroyConduit(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        tileEntityRedNetEnergy.setGrid(null);
    }

    public void doGridPreUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            GridTickHandler.removeGrid(this);
            return;
        }
        if (this.storage.getEnergyStored() >= this.storage.getMaxEnergyStored()) {
            return;
        }
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : this.nodeSet) {
            int n = 6;
            while (n-- > 0) {
                tileEntityRedNetEnergy.extract(forgeDirectionArray[n]);
            }
        }
    }

    public void doGridUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            GridTickHandler.removeGrid(this);
            return;
        }
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = this.nodeSet.size();
        int n2 = this.storage.getEnergyStored() / n;
        int n3 = n2 / 6;
        this.distribution = n2;
        this.distributionSide = n3;
        if (n3 > 0) {
            for (TileEntityRedNetEnergy tileEntityRedNetEnergy : this.nodeSet) {
                if (tileEntityRedNetEnergy == this.master) continue;
                int n4 = 0;
                int n5 = 6;
                while (n5-- > 0) {
                    n4 += tileEntityRedNetEnergy.transfer(forgeDirectionArray[n5], n3);
                }
                if (n4 <= 0) continue;
                this.storage.modifyEnergyStored(-n4);
            }
        }
        if ((n3 = (n2 += this.storage.getEnergyStored() % n) / 6) > 0) {
            int n6 = 0;
            int n7 = 6;
            while (n7-- > 0) {
                n6 += this.master.transfer(forgeDirectionArray[n7], n3);
            }
            if (n6 > 0) {
                this.storage.modifyEnergyStored(-n6);
            }
        }
    }

    public boolean canGridMerge(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        LinkedHashSet<TileEntityRedNetEnergy> linkedHashSet = redstoneEnergyNetwork.conduitSet;
        return !linkedHashSet.isEmpty() && !this.conduitSet.isEmpty() && ((TileEntityRedNetEnergy)linkedHashSet.iterator().next()).canInterface((TileEntityRedNetCable)((Object)this.conduitSet.iterator().next()));
    }

    public void mergeGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        redstoneEnergyNetwork.destroyGrid();
        this.regenerating = true;
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : redstoneEnergyNetwork.conduitSet) {
            this.addConduit(tileEntityRedNetEnergy);
        }
        this.regenerating = false;
        redstoneEnergyNetwork.conduitSet.clear();
        redstoneEnergyNetwork.nodeSet.clear();
    }

    public void nodeAdded(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        if (this.master == null) {
            this.master = tileEntityRedNetEnergy;
            GridTickHandler.addGrid(this);
        }
        this.rebalanceGrid();
        this.storage.modifyEnergyStored(tileEntityRedNetEnergy.energyForGrid);
    }

    public void nodeRemoved(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        this.rebalanceGrid();
        if (tileEntityRedNetEnergy == this.master) {
            if (this.nodeSet.isEmpty()) {
                this.master = null;
                GridTickHandler.removeGrid(this);
            } else {
                this.master = (TileEntityRedNetEnergy)this.nodeSet.iterator().next();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean conduitAdded(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        if (tileEntityRedNetEnergy.grid == null) {
            tileEntityRedNetEnergy.setGrid(this);
            return true;
        }
        if (tileEntityRedNetEnergy.grid == this) return false;
        if (this.canGridMerge(tileEntityRedNetEnergy.grid)) {
            this.mergeGrid(tileEntityRedNetEnergy.grid);
            return true;
        }
        this.conduitSet.remove(tileEntityRedNetEnergy);
        return false;
    }

    public void rebalanceGrid() {
        this.storage.setCapacity(this.nodeSet.size() * 6000);
    }

    public int getConduitCount() {
        return this.conduitSet.size();
    }

    public int getNodeCount() {
        return this.nodeSet.size();
    }

    public String toString() {
        return "RedstoneEnergyNetwork@" + Integer.toString(this.hashCode()) + "; master:" + this.master + "; regenerating:" + this.regenerating + "; isTicking:" + GridTickHandler.isGridTicking(this);
    }
}

