/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityWeather
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    public TileEntityWeather() {
        super(Machine.WeatherCollector);
        this.setManageSolids(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public int getWorkMax() {
        return 50;
    }

    @Override
    public int getIdleTicksMax() {
        return 600;
    }

    @Override
    public boolean activateMachine() {
        if (this.field_70331_k.func_72912_H().func_76059_o() && this.canSeeSky()) {
            BiomeGenBase biomeGenBase = this.field_70331_k.func_72807_a(this.field_70329_l, this.field_70327_n);
            if (!biomeGenBase.func_76738_d() && !biomeGenBase.func_76746_c()) {
                this.setIdleTicks(this.getIdleTicksMax());
                return false;
            }
            this.setWorkDone(this.getWorkDone() + 1);
            if (this.getWorkDone() >= this.getWorkMax()) {
                if (biomeGenBase.func_76743_j() >= 0.15f) {
                    if (this._tanks[0].fill(FluidRegistry.getFluidStack((String)"water", (int)1000), true) > 0) {
                        this.setWorkDone(0);
                        return true;
                    }
                    this.setWorkDone(this.getWorkMax());
                    return false;
                }
                this.doDrop(new ItemStack(Item.field_77768_aD));
                this.setWorkDone(0);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.DOWN;
    }

    private boolean canSeeSky() {
        for (int i = this.field_70330_m + 1; i <= 256; ++i) {
            int n = this.field_70331_k.func_72798_a(this.field_70329_l, i, this.field_70327_n);
            if (Block.field_71973_m[n] == null || Block.field_71973_m[n].isAirBlock(this.field_70331_k, this.field_70329_l, i, this.field_70327_n)) continue;
            return false;
        }
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(4000)};
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

