/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.core.inventory.InventoryManager;
import powercrystals.core.util.Util;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.client.GuiEjector;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerEjector;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityEjector
extends TileEntityFactoryInventory {
    protected boolean _lastRedstoneState;
    protected boolean _whitelist = false;
    protected boolean _matchNBT = true;
    protected boolean _ignoreDamage = true;
    protected boolean _hasItems = false;
    protected ForgeDirection[] _pullDirections;

    public TileEntityEjector() {
        super(Machine.Ejector);
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    @Override
    public void rotateDirectlyTo(int n) {
        super.rotateDirectlyTo(n);
        this.onRotate();
    }

    @Override
    public void rotate() {
        super.rotate();
        this.onRotate();
    }

    protected void onRotate() {
        LinkedList<ForgeDirection> linkedList = new LinkedList<ForgeDirection>();
        linkedList.addAll(MFRUtil.VALID_DIRECTIONS);
        linkedList.remove(this.getDirectionFacing());
        this._pullDirections = linkedList.toArray(new ForgeDirection[5]);
    }

    @Override
    public void func_70316_g() {
        boolean bl;
        block7: {
            super.func_70316_g();
            if (this.field_70331_k.field_72995_K) {
                return;
            }
            bl = Util.isRedstonePowered((TileEntity)this);
            if (bl & !this._lastRedstoneState & (!this._whitelist | this._whitelist == this._hasItems)) {
                ISidedInventory iSidedInventory;
                ItemStack itemStack;
                ForgeDirection forgeDirection = this.getDirectionFacing();
                Map map = UtilInventory.findChests((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (ForgeDirection[])this._pullDirections);
                for (Map.Entry iFluidHandler : map.entrySet()) {
                    if (iFluidHandler.getKey() == forgeDirection) continue;
                    ForgeDirection[] forgeDirectionArray = InventoryManager.create((IInventory)((IInventory)iFluidHandler.getValue()), (ForgeDirection)((ForgeDirection)iFluidHandler.getKey()).getOpposite());
                    Map map2 = forgeDirectionArray.getContents();
                    for (Map.Entry entry : map2.entrySet()) {
                        if (entry == null || entry.getValue() == null) continue;
                        itemStack = (ItemStack)entry.getValue();
                        if (iFluidHandler.getValue() instanceof ISidedInventory && !(iSidedInventory = (ISidedInventory)iFluidHandler.getValue()).func_102008_b(((Integer)entry.getKey()).intValue(), itemStack, ((ForgeDirection)iFluidHandler.getKey()).getOpposite().ordinal())) continue;
                        boolean bl2 = false;
                        int n = this.getSizeItemList();
                        while (n-- > 0) {
                            if (!this.itemMatches(this._inventory[n], itemStack)) continue;
                            bl2 = true;
                        }
                        if (this._whitelist != bl2) continue;
                        ItemStack itemStack2 = itemStack.func_77946_l();
                        itemStack2.field_77994_a = 1;
                        ItemStack itemStack3 = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack2, (ForgeDirection)forgeDirection, (ForgeDirection)forgeDirection);
                        if (itemStack3 != null) continue;
                        forgeDirectionArray.removeItem(1, itemStack2);
                        break block7;
                    }
                }
                TileEntity tileEntity = this.field_70331_k.func_72796_p(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ);
                if (tileEntity instanceof IFluidHandler) {
                    IFluidHandler iFluidHandler = (IFluidHandler)tileEntity;
                    for (ForgeDirection forgeDirection2 : this._pullDirections) {
                        tileEntity = this.field_70331_k.func_72796_p(this.field_70329_l + forgeDirection2.offsetX, this.field_70330_m + forgeDirection2.offsetY, this.field_70327_n + forgeDirection2.offsetZ);
                        if (!(tileEntity instanceof IFluidHandler) || (iSidedInventory = (itemStack = (IFluidHandler)tileEntity).drain(forgeDirection2.getOpposite(), 1000, false)) == null || iSidedInventory.amount <= 0 || iFluidHandler.fill(forgeDirection.getOpposite(), (FluidStack)iSidedInventory, false) <= 0) continue;
                        itemStack.drain(forgeDirection2.getOpposite(), iFluidHandler.fill(forgeDirection.getOpposite(), (FluidStack)iSidedInventory, true), true);
                        break;
                    }
                }
            }
        }
        this._lastRedstoneState = bl;
    }

    protected boolean itemMatches(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        if (itemStack.field_77993_c != itemStack2.field_77993_c) {
            return false;
        }
        if (!this._ignoreDamage && !itemStack.func_77969_a(itemStack2)) {
            return false;
        }
        if (this._matchNBT) {
            if (itemStack.func_77978_p() == null && itemStack2.func_77978_p() == null) {
                return true;
            }
            if (itemStack.func_77978_p() == null || itemStack2.func_77978_p() == null) {
                return false;
            }
            return itemStack.func_77978_p().equals((Object)itemStack2.func_77978_p());
        }
        return true;
    }

    @Override
    public void onFactoryInventoryChanged() {
        int n = this.getSizeItemList();
        while (n-- > 0) {
            if (this._inventory[n] == null) continue;
            this._hasItems = true;
            return;
        }
    }

    public int getSizeItemList() {
        return 9;
    }

    public int func_70302_i_() {
        return this.getSizeItemList();
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiEjector(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerEjector(this, inventoryPlayer);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._lastRedstoneState = nBTTagCompound.func_74767_n("redstone");
        this._whitelist = nBTTagCompound.func_74767_n("whitelist");
        this._matchNBT = !nBTTagCompound.func_74764_b("matchNBT") || nBTTagCompound.func_74767_n("matchNBT");
        this._ignoreDamage = nBTTagCompound.func_74767_n("ignoreDamage");
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("redstone", this._lastRedstoneState);
        nBTTagCompound.func_74757_a("whitelist", this._whitelist);
        nBTTagCompound.func_74757_a("matchNBT", this._matchNBT);
        nBTTagCompound.func_74757_a("ignoreDamage", this._ignoreDamage);
    }

    public boolean getIsWhitelist() {
        return this._whitelist;
    }

    public boolean getIsNBTMatch() {
        return this._matchNBT;
    }

    public boolean getIsIDMatch() {
        return this._ignoreDamage;
    }

    public void setIsWhitelist(boolean bl) {
        this._whitelist = bl;
    }

    public void setIsNBTMatch(boolean bl) {
        this._matchNBT = bl;
    }

    public void setIsIDMatch(boolean bl) {
        this._ignoreDamage = bl;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.STRUCTURE) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        if (forgeDirection == this.getDirectionFacing()) {
            return super.overridePipeConnection(pipeType, forgeDirection);
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

