/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.gates.IAction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.core.asm.relauncher.Implementable;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.core.BlockNBTManager;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;

@Implementable(value="buildcraft.core.IMachine")
public abstract class TileEntityFactoryInventory
extends TileEntityFactory
implements ISidedInventory {
    private static IFluidTank[] emptyIFluidTank = new IFluidTank[0];
    private static FluidTankInfo[] emptyFluidTankInfo = new FluidTankInfo[0];
    protected String _invName;
    protected boolean _hasInvName = false;
    protected List<ItemStack> failedDrops = null;
    private List<ItemStack> missedDrops = new ArrayList<ItemStack>(5);
    protected int _failedDropTicksMax = 20;
    private int _failedDropTicks = 0;
    protected boolean internalChange = false;
    protected FluidTank[] _tanks;
    protected ItemStack[] _inventory = new ItemStack[this.func_70302_i_()];

    protected TileEntityFactoryInventory(Machine machine) {
        super(machine);
        this._tanks = this.createTanks();
        this.setManageFluids(this._tanks != null);
    }

    public String func_70303_b() {
        return this._hasInvName ? this._invName : StatCollector.func_74838_a((String)(this._machine.getInternalName() + ".name"));
    }

    public boolean func_94042_c() {
        return this._hasInvName;
    }

    public void setInvName(String string) {
        this._invName = string;
        this._hasInvName = string != null && string.length() > 0;
    }

    public void onDisassembled() {
        this.onChunkUnload();
        if (this.failedDrops != null) {
            while (this.failedDrops.size() > 0) {
                ItemStack itemStack = this.failedDrops.remove(0);
                if (itemStack == null) continue;
                float f = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f3 = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemStack.field_77994_a > 0) {
                    int n = this.field_70331_k.field_73012_v.nextInt(21) + 10;
                    if (n > itemStack.field_77994_a) {
                        n = itemStack.field_77994_a;
                    }
                    itemStack.field_77994_a -= n;
                    EntityItem entityItem = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + f), (double)((float)this.field_70330_m + f2), (double)((float)this.field_70327_n + f3), new ItemStack(itemStack.field_77993_c, n, itemStack.func_77960_j()));
                    if (itemStack.func_77978_p() != null) {
                        entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p());
                    }
                    float f4 = 0.05f;
                    entityItem.field_70159_w = (float)this.field_70331_k.field_73012_v.nextGaussian() * f4;
                    entityItem.field_70181_x = (float)this.field_70331_k.field_73012_v.nextGaussian() * f4 + 0.2f;
                    entityItem.field_70179_y = (float)this.field_70331_k.field_73012_v.nextGaussian() * f4;
                    this.field_70331_k.func_72838_d((Entity)entityItem);
                }
            }
        }
    }

    public void onBlockBroken() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.writeItemNBT(nBTTagCompound);
        if (!nBTTagCompound.func_82582_d()) {
            BlockNBTManager.setForBlock(new BlockPosition(this.field_70329_l, this.field_70330_m, this.field_70327_n), nBTTagCompound);
        }
        this.onDisassembled();
    }

    protected void writeItemNBT(NBTTagCompound nBTTagCompound) {
        if (this.func_94042_c()) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74778_a("Name", this.func_70303_b());
            nBTTagCompound.func_74782_a("display", (NBTBase)nBTTagCompound2);
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        IFluidTank[] iFluidTankArray = this.getTanks();
        if (iFluidTankArray.length == 0) {
            return emptyFluidTankInfo;
        }
        FluidTankInfo[] fluidTankInfoArray = new FluidTankInfo[iFluidTankArray.length];
        int n = iFluidTankArray.length;
        while (n-- > 0) {
            fluidTankInfoArray[n] = iFluidTankArray[n].getInfo();
        }
        return fluidTankInfoArray;
    }

    protected FluidTank[] createTanks() {
        return null;
    }

    public IFluidTank[] getTanks() {
        if (this._tanks != null) {
            return this._tanks;
        }
        return emptyIFluidTank;
    }

    public int drain(FluidTank fluidTank, int n, boolean bl) {
        FluidStack fluidStack;
        if (fluidTank.getFluidAmount() > 0 && (fluidStack = fluidTank.drain(n, bl)) != null) {
            if (bl) {
                this.internalChange = true;
                this.func_70296_d();
                this.internalChange = false;
            }
            return fluidStack.amount;
        }
        return 0;
    }

    public int fill(FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (fluidTank.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    protected boolean shouldPumpLiquid() {
        return false;
    }

    public boolean allowBucketFill() {
        return false;
    }

    public boolean allowBucketDrain() {
        return false;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.shouldPumpLiquid()) {
            for (IFluidTank iFluidTank : this.getTanks()) {
                MFRLiquidMover.pumpLiquid(iFluidTank, this);
            }
        }
        if (this.failedDrops != null) {
            if (this._failedDropTicks < this._failedDropTicksMax) {
                ++this._failedDropTicks;
                return;
            }
            this._failedDropTicks = 0;
            if (!this.doDrop(this.failedDrops)) {
                return;
            }
            this.failedDrops = null;
            this.func_70296_d();
        }
    }

    public boolean doDrop(ItemStack itemStack) {
        if ((itemStack = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection[])this.getDropDirections(), (ForgeDirection)this.getDropDirection())) != null && itemStack.field_77994_a > 0) {
            if (this.failedDrops == null) {
                this.failedDrops = new ArrayList<ItemStack>();
            }
            this.failedDrops.add(itemStack);
            this.func_70296_d();
        }
        return true;
    }

    public boolean doDrop(List<ItemStack> list) {
        if (list == null || list.size() <= 0) {
            return true;
        }
        List<ItemStack> list2 = this.missedDrops;
        list2.clear();
        int n = list.size();
        while (n-- > 0) {
            ItemStack itemStack = list.get(n);
            if ((itemStack = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection[])this.getDropDirections(), (ForgeDirection)this.getDropDirection())) == null || itemStack.field_77994_a <= 0) continue;
            list2.add(itemStack);
        }
        if (list2.size() != 0) {
            if (list != this.failedDrops) {
                if (this.failedDrops == null) {
                    this.failedDrops = new ArrayList<ItemStack>(list2.size());
                }
                this.failedDrops.addAll(list2);
            } else {
                this.failedDrops.clear();
                this.failedDrops.addAll(list2);
            }
            this.func_70296_d();
            return false;
        }
        return true;
    }

    public boolean hasDrops() {
        return this.failedDrops != null;
    }

    public ItemStack func_70301_a(int n) {
        return this._inventory[n];
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int n, int n2) {
        if (this._inventory[n] != null) {
            if (this._inventory[n].field_77994_a <= n2) {
                ItemStack itemStack = this._inventory[n];
                this._inventory[n] = null;
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this._inventory[n].func_77979_a(n2);
            if (this._inventory[n].field_77994_a <= 0) {
                this._inventory[n] = null;
            }
            this.func_70296_d();
            return itemStack;
        }
        this.func_70296_d();
        return null;
    }

    public void func_70299_a(int n, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this._inventory[n] = itemStack;
        this.func_70296_d();
    }

    @Override
    public void func_70296_d() {
        if (!this.internalChange) {
            this.onFactoryInventoryChanged();
        }
        super.func_70296_d();
    }

    protected void onFactoryInventoryChanged() {
    }

    public int func_70297_j_() {
        return 127;
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        int n2 = this.getStartInventorySide(ForgeDirection.UNKNOWN);
        if (n < n2 || n > n2 + this.getSizeInventorySide(ForgeDirection.UNKNOWN)) {
            return false;
        }
        ItemStack itemStack2 = this.func_70301_a(n);
        return itemStack2 == null || UtilInventory.stacksEqual((ItemStack)itemStack, (ItemStack)itemStack2);
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        if (this.func_70320_p() || this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2;
        FluidTank fluidTank;
        NBTTagList nBTTagList;
        super.func_70307_a(nBTTagCompound);
        this._inventory = new ItemStack[this.func_70302_i_()];
        if (nBTTagCompound.func_74764_b("Items")) {
            nBTTagList = nBTTagCompound.func_74761_m("Items");
            int n = nBTTagList.func_74745_c();
            while (n-- > 0) {
                NBTTagCompound nBTTagCompound3 = (NBTTagCompound)nBTTagList.func_74743_b(n);
                int n2 = nBTTagCompound3.func_74771_c("Slot") & 0xFF;
                if (n2 < 0 || n2 >= this._inventory.length) continue;
                this._inventory[n2] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound3);
                if (this._inventory[n2].field_77994_a >= 0) continue;
                this._inventory[n2] = null;
            }
        }
        this.func_70296_d();
        if (nBTTagCompound.func_74764_b("mTanks")) {
            IFluidTank[] iFluidTankArray = this.getTanks();
            nBTTagList = nBTTagCompound.func_74761_m("mTanks");
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                FluidStack fluidStack;
                NBTTagCompound nBTTagCompound4 = (NBTTagCompound)nBTTagList.func_74743_b(i);
                int n = nBTTagCompound4.func_74771_c("Tank") & 0xFF;
                if (n < 0 || n >= iFluidTankArray.length || (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound4)) == null) continue;
                ((FluidTank)iFluidTankArray[n]).setFluid(fluidStack);
            }
        } else if (this._tanks != null && (fluidTank = this._tanks[0]) != null && nBTTagCompound.func_74764_b("tankFluidName")) {
            int n = nBTTagCompound.func_74762_e("tankAmount");
            FluidStack fluidStack = FluidRegistry.getFluidStack((String)nBTTagCompound.func_74779_i("tankFluidName"), (int)n);
            if (fluidStack != null) {
                if (fluidStack.amount > fluidTank.getCapacity()) {
                    fluidStack.amount = fluidTank.getCapacity();
                }
                fluidTank.setFluid(fluidStack);
            }
            nBTTagCompound.func_82580_o("tankFluidName");
            nBTTagCompound.func_82580_o("tankAmount");
        }
        if (nBTTagCompound.func_74764_b("display") && (nBTTagCompound2 = nBTTagCompound.func_74775_l("display")).func_74764_b("Name")) {
            this.setInvName(nBTTagCompound2.func_74779_i("Name"));
        }
        if (nBTTagCompound.func_74764_b("DropItems")) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            nBTTagList = nBTTagCompound.func_74761_m("DropItems");
            int n = nBTTagList.func_74745_c();
            while (n-- > 0) {
                NBTTagCompound nBTTagCompound5 = (NBTTagCompound)nBTTagList.func_74743_b(n);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound5);
                if (itemStack == null || itemStack.field_77994_a <= 0) continue;
                arrayList.add(itemStack);
            }
            if (arrayList.size() != 0) {
                this.failedDrops = arrayList;
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        IFluidTank[] iFluidTankArray;
        Object object;
        NBTTagList nBTTagList;
        super.func_70310_b(nBTTagCompound);
        if (this._inventory.length > 0) {
            nBTTagList = new NBTTagList();
            for (int i = 0; i < this._inventory.length; ++i) {
                if (this._inventory[i] == null || this._inventory[i].field_77994_a <= 0) continue;
                object = new NBTTagCompound();
                object.func_74774_a("Slot", (byte)i);
                this._inventory[i].func_77955_b((NBTTagCompound)object);
                nBTTagList.func_74742_a((NBTBase)object);
            }
            nBTTagCompound.func_74782_a("Items", (NBTBase)nBTTagList);
        }
        if ((iFluidTankArray = this.getTanks()).length > 0) {
            object = new NBTTagList();
            int n = iFluidTankArray.length;
            for (int i = 0; i < n; ++i) {
                if (iFluidTankArray[i].getFluid() == null) continue;
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.func_74774_a("Tank", (byte)i);
                FluidStack fluidStack = iFluidTankArray[i].getFluid();
                fluidStack.writeToNBT(nBTTagCompound2);
                object.func_74742_a((NBTBase)nBTTagCompound2);
            }
            nBTTagCompound.func_74782_a("mTanks", (NBTBase)object);
        }
        if (this.func_94042_c()) {
            object = new NBTTagCompound();
            object.func_74778_a("Name", this.func_70303_b());
            nBTTagCompound.func_74766_a("display", (NBTTagCompound)object);
        }
        if (this.failedDrops != null) {
            nBTTagList = new NBTTagList();
            for (ItemStack itemStack : this.failedDrops) {
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                itemStack.func_77955_b(nBTTagCompound3);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound3);
            }
            nBTTagCompound.func_74782_a("DropItems", (NBTBase)nBTTagList);
        }
    }

    public ItemStack func_70304_b(int n) {
        return null;
    }

    public boolean shouldDropSlotWhenBroken(int n) {
        return true;
    }

    public int[] func_94128_d(int n) {
        int n2 = this.getStartInventorySide(ForgeDirection.getOrientation((int)n));
        int n3 = this.getSizeInventorySide(ForgeDirection.getOrientation((int)n));
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = i + n2;
        }
        return nArray;
    }

    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return this.func_70302_i_();
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)n2);
        int n3 = this.getStartInventorySide(forgeDirection);
        return n >= n3 && n < n3 + this.getSizeInventorySide(forgeDirection) && itemStack == null || this.func_94041_b(n, itemStack) && itemStack.field_77994_a <= Math.min(itemStack.func_77976_d(), this.func_70297_j_());
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return true;
    }

    public int getComparatorOutput(int n) {
        int[] nArray;
        IFluidTank[] iFluidTankArray = this.getTanks();
        IFluidTank iFluidTank = null;
        if (iFluidTankArray.length > 0) {
            iFluidTank = iFluidTankArray[0];
        }
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        if (iFluidTank != null) {
            bl = true;
            if (iFluidTank.getFluid() != null) {
                f = (float)iFluidTank.getFluid().amount / (float)iFluidTank.getCapacity();
            }
        }
        if ((nArray = this.func_94128_d(n)).length > 0) {
            bl2 = true;
            int[] nArray2 = nArray;
            int n2 = 0;
            float f3 = 0.0f;
            int n3 = nArray2.length;
            while (n3-- > 0) {
                if (!this.func_102007_a(nArray2[n3], null, n)) continue;
                ItemStack itemStack = this.func_70301_a(nArray2[n3]);
                if (itemStack != null) {
                    float f4 = Math.min(itemStack.func_77976_d(), this.func_70297_j_());
                    f3 += Math.max(Math.min((float)itemStack.field_77994_a / f4, 1.0f), 0.0f);
                }
                ++n2;
            }
            f2 = f3 / (float)n2;
        }
        float f5 = bl & bl2 ? (f + f2) / 2.0f : (bl ? f : (bl2 ? f2 : 0.0f));
        return (int)Math.ceil(15.0f * f5);
    }

    public boolean allowAction(IAction iAction) {
        return false;
    }
}

