/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup.recipe;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.block.ItemBlockRedNetLogic;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.setup.recipe.handler.ShapelessMachineTinker;

public class Vanilla {
    private static boolean _registeredMachines;
    private static boolean _registeredMachineUpgrades;
    private static boolean _registeredMachineTinkers;
    private static boolean _registeredConveyors;
    private static boolean _registeredDecorative;
    private static boolean _registeredSyringes;
    private static boolean _registeredPlastics;
    private static boolean _registeredMiscItems;
    private static boolean _registeredSafariNets;
    private static boolean _registeredVanillaImprovements;
    private static boolean _registeredRails;
    private static boolean _registeredGuns;
    private static boolean _registeredRedNet;
    private static boolean _registeredRedNetManual;

    public final void registerRecipes() {
        this.gatherItems();
        this.registerMachines();
        this.registerMachineUpgrades();
        this.registerMachineTinkers();
        this.registerConveyors();
        this.registerDecorative();
        if (MFRConfig.enableSyringes.getBoolean(true)) {
            this.registerSyringes();
        }
        this.registerPlastics();
        this.registerMiscItems();
        this.registerSafariNets();
        this.registerVanillaImprovements();
        this.registerRails();
        if (MFRConfig.enableGuns.getBoolean(true)) {
            this.registerGuns();
        }
        this.registerRedNet();
        this.registerRedNetManual();
    }

    protected void gatherItems() {
    }

    protected void registerMachines() {
        if (_registeredMachines) {
            return;
        }
        _registeredMachines = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.machineBaseItem, 3), new Object[]{"PPP", "SSS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stone"}));
        this.registerMachine(Machine.Planter, "GGG", "CPC", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('C'), Item.field_82796_bJ, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Fisher, "GGG", "RRR", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('R'), Item.field_77749_aR, Character.valueOf('B'), Item.field_77788_aw, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Harvester, "GGG", "SXS", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('X'), Item.field_77682_J, Character.valueOf('S'), Item.field_77745_be, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Rancher, "GGG", "SBS", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77788_aw, Character.valueOf('S'), Item.field_77745_be, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Fertilizer, "GGG", "LBL", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('L'), Item.field_77770_aF, Character.valueOf('B'), Item.field_77729_bt, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Vet, "GGG", "SSS", "EME", Character.valueOf('G'), "sheetPlastic", Character.valueOf('E'), Item.field_77728_bu, Character.valueOf('S'), MineFactoryReloadedCore.syringeEmptyItem, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.ItemCollector, 8, new Object[]{"GGG", " C ", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Block.field_72077_au, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem});
        this.registerMachine(Machine.BlockBreaker, "GGG", "PHS", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Item.field_77681_I, Character.valueOf('H'), MineFactoryReloadedCore.factoryHammerItem, Character.valueOf('S'), Item.field_77680_H, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.WeatherCollector, "GGG", "BBB", "UMU", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Block.field_72002_bp, Character.valueOf('U'), Item.field_77788_aw, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.SludgeBoiler, "GGG", "FFF", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Block.field_72051_aB, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Sewer, 4, new Object[]{"GGG", "BUB", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77772_aH, Character.valueOf('U'), Item.field_77788_aw, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem});
        this.registerMachine(Machine.Composter, "GGG", "PFP", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('F'), Block.field_72051_aB, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Breeder, "GGG", "CAC", "PMP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), "dyePurple", Character.valueOf('C'), Item.field_82798_bP, Character.valueOf('A'), Item.field_77778_at, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Grinder, "GGG", "BSP", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('S'), Item.field_77672_G, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.AutoEnchanter, "GGG", "BBB", "DMD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Chronotyper, "GGG", "EEE", "PMP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('E'), Item.field_77817_bH, Character.valueOf('P'), "dyePurple", Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Ejector, 8, new Object[]{"GGG", " D ", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), Block.field_96469_cy, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem});
        this.registerMachine(Machine.ItemRouter, 8, new Object[]{"GGG", "RCR", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Block.field_72077_au, Character.valueOf('R'), Item.field_77742_bb, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem});
        this.registerMachine(Machine.LiquidRouter, 8, new Object[]{"GGG", "RBR", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77788_aw, Character.valueOf('R'), Item.field_77742_bb, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem});
        int n = MFRConfig.craftSingleDSU.getBoolean(false) ? 1 : 4;
        this.registerMachine(Machine.DeepStorageUnit, n, new Object[]{"GGG", "PPP", "EME", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Item.field_77730_bn, Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem});
        if (MFRConfig.enableCheapDSU.getBoolean(false)) {
            this.registerMachine(Machine.DeepStorageUnit, "GGG", "CCC", "CMC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Block.field_72077_au, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        }
        this.registerMachine(Machine.LiquiCrafter, "GGG", "BWB", "FMF", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77788_aw, Character.valueOf('W'), Block.field_72060_ay, Character.valueOf('F'), Item.field_82802_bI, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.LavaFabricator, "GGG", "OBO", "CMC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('B'), Item.field_77731_bo, Character.valueOf('C'), Item.field_77725_bx, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.OilFabricator, "GGG", "OTO", "OMO", Character.valueOf('G'), "sheetPlastic", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('T'), Block.field_72091_am, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.AutoJukebox, "GGG", " J ", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('J'), Block.field_72032_aY, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Unifier, "GGG", "CBC", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('C'), Item.field_94585_bY, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.AutoSpawner, "GGG", "ECE", "NMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('E'), Item.field_77817_bH, Character.valueOf('C'), Item.field_77725_bx, Character.valueOf('N'), Item.field_77727_br, Character.valueOf('S'), Item.field_77747_aY, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.BioReactor, "GGG", "UEU", "SMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('U'), Item.field_77747_aY, Character.valueOf('E'), Item.field_77723_bv, Character.valueOf('S'), Item.field_77761_aM, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.BioFuelGenerator, "GGG", "PFP", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Block.field_72051_aB, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('R'), Item.field_77731_bo, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.AutoDisenchanter, "GGG", "RDR", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('R'), Block.field_72033_bA, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Slaughterhouse, "GGG", "SSS", "XMX", Character.valueOf('G'), "sheetPlastic", Character.valueOf('S'), Item.field_77672_G, Character.valueOf('X'), Item.field_77682_J, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.MeatPacker, "GGG", "BFB", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Block.field_72081_al, Character.valueOf('F'), Item.field_77709_i, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.EnchantmentRouter, "GGG", "RBR", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('R'), Item.field_77742_bb, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.LaserDrill, "GGG", "LLL", "DMD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('L'), Block.field_72014_bd, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.LaserDrillPrecharger, "GGG", "LSL", "DMD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('L'), Block.field_72014_bd, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('S'), MineFactoryReloadedCore.pinkSlimeballItem, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.AutoAnvil, "GGG", "AAA", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('A'), Block.field_82510_ck, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.BlockSmasher, "GGG", "HHH", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('H'), MineFactoryReloadedCore.factoryHammerItem, Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.RedNote, "GGG", "CNC", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), MineFactoryReloadedCore.rednetCableBlock, Character.valueOf('N'), Block.field_71960_R, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.AutoBrewer, "GGG", "CBC", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Block.field_72077_au, Character.valueOf('B'), Item.field_77724_by, Character.valueOf('R'), Item.field_77742_bb, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.FruitPicker, "GGG", "SXS", "SMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('X'), Item.field_77682_J, Character.valueOf('S'), Item.field_77745_be, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.BlockPlacer, "GGG", "DDD", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), Block.field_71958_P, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.MobCounter, "GGG", "RCR", "SMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('R'), Item.field_77742_bb, Character.valueOf('C'), Item.field_94585_bY, Character.valueOf('S'), MineFactoryReloadedCore.spyglassItem, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.SteamTurbine, "GGG", "PFP", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Block.field_72051_aB, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('R'), Item.field_94584_bZ, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.ChunkLoader, "GGG", "PFP", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Item.field_82792_bS, Character.valueOf('P'), Machine.DeepStorageUnit.getItemStack(), Character.valueOf('R'), Block.field_94341_cq, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.Fountain, "GBG", "GBG", "UMU", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Block.field_72002_bp, Character.valueOf('U'), Item.field_77788_aw, Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
        this.registerMachine(Machine.MobRouter, "GGG", "CBR", "PMP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Machine.Chronotyper.getItemStack(), Character.valueOf('B'), Block.field_72002_bp, Character.valueOf('R'), Machine.ItemRouter.getItemStack(), Character.valueOf('P'), "dyeOrange", Character.valueOf('M'), MineFactoryReloadedCore.machineBaseItem);
    }

    protected void registerMachine(Machine machine, Object ... objectArray) {
        this.registerMachine(machine, 1, objectArray);
    }

    protected void registerMachine(Machine machine, int n, Object ... objectArray) {
        if (machine.getIsRecipeEnabled()) {
            ItemStack itemStack = machine.getItemStack();
            itemStack.field_77994_a = n;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, objectArray));
        }
    }

    protected void registerMachineUpgrades() {
        if (_registeredMachineUpgrades) {
            return;
        }
        _registeredMachineUpgrades = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 0), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 1), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 2), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 3), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 4), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), "ingotBronze", Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 5), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), "ingotSilver", Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 6), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), "ingotGold", Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 7), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), Item.field_94583_ca, Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 8), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), Item.field_77702_n, Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 9), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), "ingotPlatinum", Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 10), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), Item.field_77817_bH, Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.upgradeItem, 1, 11), new Object[]{"III", "PPP", "RGR", Character.valueOf('I'), "cobblestone", Character.valueOf('P'), "dustPlastic", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "nuggetGold"}));
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.laserFocusItem, 1, i), new Object[]{"ENE", "NGN", "ENE", Character.valueOf('E'), Item.field_77817_bH, Character.valueOf('N'), "nuggetGold", Character.valueOf('G'), new ItemStack(MineFactoryReloadedCore.factoryGlassPaneBlock, 1, i)}));
        }
    }

    protected void registerMachineTinkers() {
        if (_registeredMachineTinkers) {
            return;
        }
        _registeredMachineTinkers = true;
        GameRegistry.addRecipe((IRecipe)new ShapelessMachineTinker(Machine.ItemCollector, "Emits comparator signal", new ItemStack[]{new ItemStack(Item.field_77733_bq)}){

            @Override
            protected boolean isMachineTinkerable(ItemStack itemStack) {
                return !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("hasTinkerStuff");
            }

            @Override
            protected ItemStack getTinkeredMachine(ItemStack itemStack) {
                NBTTagCompound nBTTagCompound = (itemStack = itemStack.func_77946_l()).func_77978_p();
                if (nBTTagCompound == null) {
                    nBTTagCompound = new NBTTagCompound();
                    itemStack.func_77982_d(nBTTagCompound);
                }
                nBTTagCompound.func_74757_a("hasTinkerStuff", true);
                return itemStack;
            }
        });
    }

    protected void registerConveyors() {
        if (_registeredConveyors) {
            return;
        }
        _registeredConveyors = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.conveyorBlock, 16, 16), new Object[]{"UUU", "RIR", Character.valueOf('U'), "itemRubber", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('I'), Item.field_77703_o}));
        String[] stringArray = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MineFactoryReloadedCore.conveyorBlock, 1, i), new Object[]{new ItemStack(MineFactoryReloadedCore.conveyorBlock, 1, 16), "dyeCeramic" + stringArray[15 - i]}));
        }
    }

    protected void registerDecorative() {
        int n;
        if (_registeredDecorative) {
            return;
        }
        _registeredDecorative = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.factoryRoadBlock, 16), new Object[]{"BBB", "BPB", "BBB", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), new ItemStack(Block.field_72007_bm, 1, 0)}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryRoadBlock, 4, 1), (Object[])new Object[]{"R R", " G ", "R R", Character.valueOf('R'), new ItemStack(MineFactoryReloadedCore.factoryRoadBlock, 1, 0), Character.valueOf('G'), Block.field_72078_bL});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryRoadBlock, 1, 4), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.factoryRoadBlock, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryRoadBlock, 1, 1), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.factoryRoadBlock, 1, 4)});
        String[] stringArray = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        ItemStack itemStack = new ItemStack(Block.field_72003_bq);
        for (n = 0; n < 16; ++n) {
            ItemStack itemStack2 = new ItemStack(MineFactoryReloadedCore.ceramicDyeItem, 4, n);
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemStack2, new Object[]{new ItemStack(Item.field_77757_aI), "dye" + stringArray[15 - n]}));
            itemStack2.field_77994_a = 1;
            ItemStack itemStack3 = new ItemStack(MineFactoryReloadedCore.factoryGlassBlock, 1, n);
            ItemStack itemStack4 = new ItemStack(MineFactoryReloadedCore.factoryGlassPaneBlock, 1, n);
            OreDictionary.registerOre((String)("glass" + stringArray[15 - n]), (ItemStack)itemStack3.func_77946_l());
            OreDictionary.registerOre((String)("glassPane" + stringArray[15 - n]), (ItemStack)itemStack4.func_77946_l());
            OreDictionary.registerOre((String)("dyeCeramic" + stringArray[15 - n]), (ItemStack)itemStack2.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemStack3, new Object[]{itemStack2, "glass"}));
            itemStack3.field_77994_a = 3;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemStack3, new Object[]{itemStack2, "glass", "glass", "glass"}));
            GameRegistry.addShapelessRecipe((ItemStack)itemStack4.func_77946_l(), (Object[])new Object[]{itemStack2, itemStack});
            itemStack4.field_77994_a = 3;
            GameRegistry.addShapelessRecipe((ItemStack)itemStack4.func_77946_l(), (Object[])new Object[]{itemStack2, itemStack, itemStack, itemStack});
            itemStack4.field_77994_a = 8;
            GameRegistry.addShapelessRecipe((ItemStack)itemStack4.func_77946_l(), (Object[])new Object[]{itemStack2, itemStack, itemStack, itemStack, itemStack, itemStack, itemStack, itemStack, itemStack});
            GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryGlassPaneBlock, 16, n), (Object[])new Object[]{"GGG", "GGG", Character.valueOf('G'), new ItemStack(MineFactoryReloadedCore.factoryGlassBlock, 1, n)});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 0), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72081_al, Character.valueOf('M'), Block.field_72036_aT});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 1), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72081_al, Character.valueOf('M'), Block.field_72014_bd});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 2), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72081_al, Character.valueOf('M'), Block.field_71948_O});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 3), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72081_al, Character.valueOf('M'), Block.field_72089_ap});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 4), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72081_al, Character.valueOf('M'), new ItemStack((Block)Block.field_72079_ak, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 5), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72081_al, Character.valueOf('M'), Block.field_72039_aU});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 6), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('M'), Block.field_72014_bd});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 7), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('M'), Block.field_72036_aT});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 8), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('M'), Block.field_71948_O});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 9), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('M'), Block.field_72089_ap});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 10), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('M'), Block.field_72039_aU});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 14), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('M'), new ItemStack((Block)Block.field_72079_ak, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 8, 15), (Object[])new Object[]{"M M", " B ", "M M", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('M'), new ItemStack(Block.field_72081_al, 1, 0)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 0), new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 1), new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('D'), Item.field_77747_aY}));
        OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 0));
        OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 1));
        n = MineFactoryReloadedCore.factoryDecorativeStoneBlock.field_71990_ca;
        FurnaceRecipes.func_77602_a().addSmelting(n, 2, new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 0), 1.0E-4f);
        FurnaceRecipes.func_77602_a().addSmelting(n, 3, new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 1), 1.0E-4f);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 2), new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), "cobblestone", Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 3), new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), "cobblestone", Character.valueOf('D'), Item.field_77747_aY}));
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 2));
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 3));
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 4), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), Block.field_72007_bm, Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 5), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), Block.field_72007_bm, Character.valueOf('D'), Item.field_77747_aY});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 4, 4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 4, 5), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 6), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), Block.field_72081_al, Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 7), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), Block.field_72081_al, Character.valueOf('D'), Item.field_77747_aY});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 4, 6), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 4, 7), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 8), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), Block.field_71940_F, Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, 9), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), Block.field_71940_F, Character.valueOf('D'), Item.field_77747_aY});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 4, 10), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), new ItemStack((Block)Block.field_72079_ak, 1, 0), Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 4, 11), (Object[])new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), new ItemStack((Block)Block.field_72079_ak, 1, 0), Character.valueOf('D'), Item.field_77747_aY});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 10), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 11), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 0), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 10)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 1), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, 11)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, 12), (Object[])new Object[]{"MMM", "MMM", "MMM", Character.valueOf('M'), MineFactoryReloadedCore.meatIngotRawItem});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, 13), (Object[])new Object[]{"MMM", "MMM", "MMM", Character.valueOf('M'), MineFactoryReloadedCore.meatIngotCookedItem});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.meatIngotRawItem, 9), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, 12)});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MineFactoryReloadedCore.meatIngotCookedItem, 9), new Object[]{new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, 13)}));
        int n2 = MineFactoryReloadedCore.factoryDecorativeBrickBlock.field_71990_ca;
        FurnaceRecipes.func_77602_a().addSmelting(n2, 13, new ItemStack(Item.field_77705_m, 3, 1), 0.001f);
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.meatIngotRawItem), (Object[])new Object[]{"MMM", "MMM", "MMM", Character.valueOf('M'), MineFactoryReloadedCore.meatNuggetRawItem});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.meatIngotCookedItem), (Object[])new Object[]{"MMM", "MMM", "MMM", Character.valueOf('M'), MineFactoryReloadedCore.meatNuggetCookedItem});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.meatNuggetRawItem, 9), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.meatIngotRawItem)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.meatNuggetCookedItem, 9), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.meatIngotCookedItem)});
    }

    protected void registerSyringes() {
        if (_registeredSyringes) {
            return;
        }
        _registeredSyringes = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.xpExtractorItem), new Object[]{"PLP", "PLP", "RPR", Character.valueOf('R'), "itemRubber", Character.valueOf('L'), "glass", Character.valueOf('P'), "sheetPlastic"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.syringeEmptyItem, 1), new Object[]{"PRP", "P P", " I ", Character.valueOf('P'), "sheetPlastic", Character.valueOf('R'), "itemRubber", Character.valueOf('I'), Item.field_77703_o}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.syringeHealthItem), (Object[])new Object[]{MineFactoryReloadedCore.syringeEmptyItem, Item.field_77706_j});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.syringeGrowthItem), (Object[])new Object[]{MineFactoryReloadedCore.syringeEmptyItem, Item.field_82798_bP});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.syringeZombieItem, 1), (Object[])new Object[]{"FFF", "FSF", "FFF", Character.valueOf('F'), Item.field_77737_bm, Character.valueOf('S'), MineFactoryReloadedCore.syringeEmptyItem});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.syringeSlimeItem, 1), new Object[]{"   ", " S ", "BLB", Character.valueOf('B'), "slimeball", Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('S'), MineFactoryReloadedCore.syringeEmptyItem}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.syringeCureItem), (Object[])new Object[]{MineFactoryReloadedCore.syringeEmptyItem, Item.field_77778_at});
    }

    protected void registerPlastics() {
        if (_registeredPlastics) {
            return;
        }
        _registeredPlastics = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.plasticSheetItem, 4), new Object[]{"##", "##", Character.valueOf('#'), "dustPlastic"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.factoryHammerItem, 1), new Object[]{"PPP", " S ", " S ", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.strawItem), new Object[]{"PP", "P ", "P ", Character.valueOf('P'), "sheetPlastic"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.rulerItem), new Object[]{"P", "A", "P", Character.valueOf('P'), "sheetPlastic", Character.valueOf('A'), Item.field_77759_aK}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)MineFactoryReloadedCore.plasticCupItem, 16), new Object[]{" P ", "P P", Character.valueOf('P'), "sheetPlastic"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.bagItem, 3), new Object[]{"SPS", "P P", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), Item.field_77683_K}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.plasticBootsItem, 1), new Object[]{"P P", "P P", Character.valueOf('P'), "sheetPlastic"}));
    }

    protected void registerMiscItems() {
        if (_registeredMiscItems) {
            return;
        }
        _registeredMiscItems = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.fertilizerItem, 16), new Object[]{"WBW", "STS", "WBW", Character.valueOf('W'), Item.field_77685_T, Character.valueOf('B'), new ItemStack(Item.field_77756_aW, 1, 15), Character.valueOf('S'), Item.field_77683_K, Character.valueOf('T'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.spyglassItem), new Object[]{"GLG", "PLP", " S ", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "glass", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stickWood"}));
        if (MFRConfig.enablePortaSpawner.getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.portaSpawnerItem), new Object[]{"GLG", "DND", "GLG", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "glass", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('N'), Item.field_82792_bS}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.detCordBlock, 12), new Object[]{"PPP", "PTP", "PPP", Character.valueOf('P'), "itemRubber", Character.valueOf('T'), Block.field_72091_am}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.fishingRodItem, 1), new Object[]{"DD ", "DFD", "TDD", Character.valueOf('D'), "wireExplosive", Character.valueOf('F'), Item.field_77749_aR, Character.valueOf('T'), Block.field_72035_aQ}));
    }

    protected void registerSafariNets() {
        if (_registeredSafariNets) {
            return;
        }
        _registeredSafariNets = true;
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.safariNetItem, 1), (Object[])new Object[]{" E ", "EGE", " E ", Character.valueOf('E'), Item.field_77730_bn, Character.valueOf('G'), Item.field_77732_bp});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.safariNetSingleItem, 1), new Object[]{"SLS", " B ", "S S", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('L'), Item.field_77770_aF, Character.valueOf('B'), "slimeball"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.safariNetJailerItem, 1), (Object[])new Object[]{" I ", "ISI", " I ", Character.valueOf('S'), MineFactoryReloadedCore.safariNetSingleItem, Character.valueOf('I'), Block.field_72002_bp});
        if (MFRConfig.enableNetLauncher.getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.safariNetLauncherItem, 1), new Object[]{"PGP", "LGL", "IRI", Character.valueOf('P'), "sheetPlastic", Character.valueOf('L'), Item.field_77751_aT, Character.valueOf('G'), Item.field_77677_M, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC}));
        }
    }

    protected void registerVanillaImprovements() {
        if (_registeredVanillaImprovements) {
            return;
        }
        _registeredVanillaImprovements = true;
        FurnaceRecipes.func_77602_a().addSmelting(MineFactoryReloadedCore.rawRubberItem.field_77779_bT, 0, new ItemStack(MineFactoryReloadedCore.rubberBarItem), 0.1f);
        FurnaceRecipes.func_77602_a().addSmelting(MineFactoryReloadedCore.rubberWoodBlock.field_71990_ca, 0, new ItemStack(Item.field_77705_m, 1, 1), 0.1f);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Block.field_71988_x, 3, 3), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.rubberWoodBlock)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)Block.field_71963_Z, 1, 0), (Object[])new Object[]{new ItemStack((Block)Block.field_71956_V, 1, 0), new ItemStack(Item.field_77771_aG, 1, 0)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Block.field_71956_V), new Object[]{"R", "P", Character.valueOf('R'), "itemRawRubber", Character.valueOf('P'), Block.field_71963_Z}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.blankRecordItem, 1), new Object[]{"RRR", "RPR", "RRR", Character.valueOf('R'), "dustPlastic", Character.valueOf('P'), Item.field_77759_aK}));
        if (MFRConfig.vanillaOverrideIce.getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Block.field_72036_aT, 1, 1), new Object[]{new ItemStack(Block.field_72036_aT, 1, 0), "dustPlastic"}));
        }
        if (MFRConfig.enableMossyCobbleRecipe.getBoolean(true)) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Block.field_72087_ao), (Object[])new Object[]{Block.field_71978_w, Item.field_77786_ax, Item.field_77685_T});
        }
        if (MFRConfig.enableSmoothSlabRecipe.getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Block.field_72085_aj, 1, 8), new Object[]{"VV", Character.valueOf('V'), new ItemStack((Block)Block.field_72079_ak, 1, 0)}));
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.vineScaffoldBlock, 8), (Object[])new Object[]{"VV", "VV", "VV", Character.valueOf('V'), Block.field_71998_bu});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.milkBottleItem), (Object[])new Object[]{Item.field_77771_aG, Item.field_77729_bt});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.chocolateMilkBucketItem), (Object[])new Object[]{Item.field_77771_aG, Item.field_77788_aw, new ItemStack(Item.field_77756_aW, 1, 3)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72069_aq, 4), new Object[]{"R", "S", Character.valueOf('R'), "itemRawRubber", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72069_aq, 1), new Object[]{"C", "S", Character.valueOf('C'), "itemCharcoalSugar", Character.valueOf('S'), "stickWood"}));
        for (ItemStack itemStack : OreDictionary.getOres((String)"torchStone")) {
            if (itemStack == null) continue;
            itemStack = itemStack.func_77946_l();
            itemStack.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"R", "S", Character.valueOf('R'), "itemRawRubber", Character.valueOf('S'), "stoneRod"}));
            itemStack = itemStack.func_77946_l();
            itemStack.field_77994_a = 1;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"C", "S", Character.valueOf('C'), "itemCharcoalSugar", Character.valueOf('S'), "stoneRod"}));
        }
    }

    protected void registerRails() {
        if (_registeredRails) {
            return;
        }
        _registeredRails = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.railPickupCargoBlock, 2), new Object[]{" C ", "SDS", "SSS", Character.valueOf('C'), Block.field_72077_au, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Block.field_71953_U}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.railDropoffCargoBlock, 2), new Object[]{"SSS", "SDS", " C ", Character.valueOf('C'), Block.field_72077_au, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Block.field_71953_U}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.railPickupPassengerBlock, 3), new Object[]{" L ", "SDS", "SSS", Character.valueOf('L'), Block.field_71948_O, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Block.field_71953_U}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.railDropoffPassengerBlock, 3), new Object[]{"SSS", "SDS", " L ", Character.valueOf('L'), Block.field_71948_O, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Block.field_71953_U}));
    }

    protected void registerGuns() {
        if (_registeredGuns) {
            return;
        }
        _registeredGuns = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.needlegunItem), new Object[]{"PGP", "PLP", "SIS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('S'), Item.field_77725_bx, Character.valueOf('L'), MineFactoryReloadedCore.safariNetLauncherItem, Character.valueOf('G'), MineFactoryReloadedCore.spyglassItem}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.rocketLauncherItem), new Object[]{"PCP", "PRP", "ILI", Character.valueOf('P'), "sheetPlastic", Character.valueOf('I'), Item.field_77773_az, Character.valueOf('L'), MineFactoryReloadedCore.needlegunItem, Character.valueOf('R'), new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 1), Character.valueOf('C'), new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.needlegunAmmoEmptyItem, 4), new Object[]{"P P", "PIP", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('I'), Item.field_77703_o}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.rocketItem, 2, 0), new Object[]{"PCP", "PTP", "IMI", Character.valueOf('C'), new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 0), Character.valueOf('M'), MineFactoryReloadedCore.needlegunAmmoEmptyItem, Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Block.field_72091_am, Character.valueOf('I'), Item.field_92104_bU}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.rocketItem, 2, 1), new Object[]{"PPP", "PTP", "IMI", Character.valueOf('M'), MineFactoryReloadedCore.needlegunAmmoEmptyItem, Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Block.field_72091_am, Character.valueOf('I'), Item.field_92104_bU}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.needlegunAmmoStandardItem), new Object[]{"AAA", "AAA", "GMG", Character.valueOf('A'), Item.field_77704_l, Character.valueOf('M'), MineFactoryReloadedCore.needlegunAmmoEmptyItem, Character.valueOf('G'), Item.field_77677_M}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.needlegunAmmoAnvilItem), new Object[]{"SMS", "SAS", "STS", Character.valueOf('A'), new ItemStack(Block.field_82510_ck, 1, 0), Character.valueOf('M'), MineFactoryReloadedCore.needlegunAmmoEmptyItem, Character.valueOf('S'), Item.field_77683_K, Character.valueOf('T'), Block.field_72091_am}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.needlegunAmmoFireItem), (Object[])new Object[]{MineFactoryReloadedCore.needlegunAmmoStandardItem, Item.field_77709_i});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.needlegunAmmoLavaItem), (Object[])new Object[]{MineFactoryReloadedCore.needlegunAmmoStandardItem, MineFactoryReloadedCore.plasticCupItem, Item.field_77775_ay});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.needlegunAmmoSludgeItem), (Object[])new Object[]{MineFactoryReloadedCore.needlegunAmmoStandardItem, MineFactoryReloadedCore.plasticCupItem, MineFactoryReloadedCore.sludgeBucketItem});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.needlegunAmmoSewageItem), (Object[])new Object[]{MineFactoryReloadedCore.needlegunAmmoStandardItem, MineFactoryReloadedCore.plasticCupItem, MineFactoryReloadedCore.sewageBucketItem});
    }

    protected void registerRedNet() {
        if (_registeredRedNet) {
            return;
        }
        _registeredRedNet = true;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock, 8), new Object[]{"PPP", "RRR", "PPP", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('P'), "sheetPlastic"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock, 1, 2), new Object[]{"nuggetGold", "nuggetGold", "nuggetGold", Item.field_77767_aC, Item.field_77767_aC, new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock, 6, 2), new Object[]{"ingotGold", "ingotGold", Block.field_94341_cq, new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock), new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock), new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock), new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock), new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock), new ItemStack((Block)MineFactoryReloadedCore.rednetCableBlock)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, 11), new Object[]{"PRP", "RGR", "PIP", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "glass", Character.valueOf('I'), Item.field_77703_o}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MineFactoryReloadedCore.rednetLogicBlock), new Object[]{"RDR", "LGL", "PHP", Character.valueOf('H'), new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, 11), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('D'), Item.field_77702_n, Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 0), new Object[]{"RPR", "PGP", "RPR", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 1), new Object[]{"GPG", "PCP", "RGR", Character.valueOf('C'), new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 0), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 2), new Object[]{"DPD", "RCR", "GDG", Character.valueOf('C'), new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 1), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.rednetMeterItem, 1, 0), new Object[]{" G", "PR", "PP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetGold", Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MineFactoryReloadedCore.rednetMemoryCardItem, 1, 0), new Object[]{"GGG", "PRP", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetGold", Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MineFactoryReloadedCore.rednetPanelBlock, 1, 0), new Object[]{"PCP", "PBP", "KPK", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), MineFactoryReloadedCore.rednetCableBlock, Character.valueOf('B'), Block.field_72093_an, Character.valueOf('K'), new ItemStack(Item.field_77756_aW, 1, 0)}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MineFactoryReloadedCore.rednetMemoryCardItem, 1, 0), (Object[])new Object[]{new ItemStack(MineFactoryReloadedCore.rednetMemoryCardItem, 1, 0)});
    }

    private final void registerRedNetManual() {
        if (_registeredRedNetManual) {
            return;
        }
        _registeredRedNetManual = true;
        GameRegistry.addShapelessRecipe((ItemStack)ItemBlockRedNetLogic.manual, (Object[])new Object[]{MineFactoryReloadedCore.plasticSheetItem, Item.field_77767_aC, Item.field_77760_aL});
    }
}

