/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.net;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneEnergyNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class GridTickHandler
implements IScheduledTickHandler {
    private EnumSet<TickType> ticks = EnumSet.of(TickType.SERVER);
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGridsToRegenerate = new LinkedHashSet();
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGridsToAdd = new LinkedHashSet();
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGrids = new LinkedHashSet();
    private static LinkedHashSet<RedstoneEnergyNetwork> tickingGridsToRemove = new LinkedHashSet();
    private static LinkedHashSet<TileEntityRedNetEnergy> conduit = new LinkedHashSet();
    private static LinkedHashSet<TileEntityRedNetEnergy> conduitToAdd = new LinkedHashSet();
    static GridTickHandler instance = new GridTickHandler();

    public static void addGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        tickingGridsToAdd.add(redstoneEnergyNetwork);
        tickingGridsToRemove.remove(redstoneEnergyNetwork);
    }

    public static void removeGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        tickingGridsToRemove.add(redstoneEnergyNetwork);
        tickingGridsToAdd.remove(redstoneEnergyNetwork);
    }

    public static void regenerateGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        tickingGridsToRegenerate.add(redstoneEnergyNetwork);
    }

    public static boolean isGridTicking(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        return tickingGrids.contains(redstoneEnergyNetwork);
    }

    public static void addConduit(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        conduitToAdd.add(tileEntityRedNetEnergy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickStart(EnumSet<TickType> enumSet, Object ... objectArray) {
        if (!tickingGridsToRegenerate.isEmpty()) {
            LinkedHashSet<RedstoneEnergyNetwork> linkedHashSet = tickingGridsToRegenerate;
            synchronized (linkedHashSet) {
                for (RedstoneEnergyNetwork redstoneEnergyNetwork : tickingGridsToRegenerate) {
                    redstoneEnergyNetwork.markSweep();
                }
            }
        }
        if (!tickingGrids.isEmpty()) {
            for (RedstoneEnergyNetwork redstoneEnergyNetwork : tickingGrids) {
                redstoneEnergyNetwork.doGridPreUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickEnd(EnumSet<TickType> enumSet, Object ... objectArray) {
        Object object;
        if (!tickingGridsToRemove.isEmpty()) {
            object = tickingGridsToRemove;
            synchronized (object) {
                tickingGrids.removeAll(tickingGridsToRemove);
                tickingGridsToRemove.clear();
            }
        }
        if (!tickingGridsToAdd.isEmpty()) {
            object = tickingGridsToAdd;
            synchronized (object) {
                tickingGrids.addAll(tickingGridsToAdd);
                tickingGridsToAdd.clear();
            }
        }
        if (!tickingGrids.isEmpty()) {
            for (RedstoneEnergyNetwork object2 : tickingGrids) {
                object2.doGridUpdate();
            }
        }
        if (!conduitToAdd.isEmpty()) {
            object = conduitToAdd;
            synchronized (object) {
                conduit.addAll(conduitToAdd);
                conduitToAdd.clear();
            }
        }
        if (!conduit.isEmpty()) {
            for (TileEntityRedNetEnergy tileEntityRedNetEnergy : conduit) {
                tileEntityRedNetEnergy.firstTick();
            }
            conduit.clear();
        }
    }

    public EnumSet<TickType> ticks() {
        return this.ticks;
    }

    public String getLabel() {
        return "MFR EnergyNet";
    }

    public int nextTickSpacing() {
        return 1;
    }
}

