/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.pam;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.pam.HarvestablePams;
import powercrystals.minefactoryreloaded.modhelpers.pam.HarvestablePamsFlower;
import powercrystals.minefactoryreloaded.modhelpers.pam.PamFertilizable;
import powercrystals.minefactoryreloaded.modhelpers.pam.PamFertilizableFlower;
import powercrystals.minefactoryreloaded.modhelpers.pam.PamFertilizableSapling;
import powercrystals.minefactoryreloaded.modhelpers.pam.PamFruit;
import powercrystals.minefactoryreloaded.modhelpers.pam.PamFruitCinnamon;
import powercrystals.minefactoryreloaded.modhelpers.pam.PlantablePamCrop;
import powercrystals.minefactoryreloaded.modhelpers.pam.PlantablePamFlower;

@Mod(modid="MineFactoryReloaded|CompatPams", name="MFR Compat: Pam's Mods", version="1.6.4R2.7.8", dependencies="after:MineFactoryReloaded;after:pamharvestcraft")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Pam {
    public static Method pamTEGetCropId;
    public static Method pamTEGetGrowthStage;
    public static Method pamTESetCropId;
    public static Method pamTESetGrowthStage;
    public static Method pamTEFlowerGetCropId;
    public static Method pamTEFlowerGetGrowthStage;
    public static Method pamTEFlowerSetCropId;
    public static Method pamTEFlowerSetGrowthStage;
    public static Method pamBlockFertilize;
    public static Method pamBlockFlowerFertilize;
    public static Method pamBlockSaplingFertilize;
    public static boolean pamSeedFromCrop;
    public static int flowerId;
    static int[] flowerSeeds;
    static Item[] pamSeeds;
    static Item[] pamCropItems;

    @Mod.EventHandler
    public static void load(FMLInitializationEvent fMLInitializationEvent) {
        Class<?> clazz;
        Class<?> clazz2;
        String[] stringArray;
        Class[] classArray = new Class[]{};
        Class[] classArray2 = new Class[]{Integer.TYPE};
        Class[] classArray3 = new Class[]{World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        if (!Loader.isModLoaded((String)"pamharvestcraft")) {
            FMLLog.warning((String)"Pam's HC base missing - MFR Pam HC Compat not loading", (Object[])new Object[0]);
        } else {
            try {
                int n;
                stringArray = Class.forName("assets.pamharvestcraft.PamHarvestCraft");
                MFRRegistry.registerSludgeDrop(25, new ItemStack((Item)stringArray.getField("saltItem").get(null)));
                int n2 = ((Block)stringArray.getField((String)"pamCrop").get(null)).field_71990_ca;
                pamSeeds = (Item[])stringArray.getField("PamSeeds").get(null);
                pamCropItems = (Item[])stringArray.getField("PamCropItems").get(null);
                clazz2 = Class.forName("assets.pamharvestcraft.TileEntityPamCrop");
                pamTEGetCropId = clazz2.getDeclaredMethod("getCropID", classArray);
                pamTEGetGrowthStage = clazz2.getDeclaredMethod("getGrowthStage", classArray);
                pamTESetCropId = clazz2.getDeclaredMethod("setCropID", classArray2);
                pamTESetGrowthStage = clazz2.getDeclaredMethod("setGrowthStage", classArray2);
                clazz = Class.forName("assets.pamharvestcraft.BlockPamCrop");
                pamBlockFertilize = clazz.getDeclaredMethod("fertilize", classArray3);
                Class<?> clazz3 = Class.forName("assets.pamharvestcraft.HarvestConfigurationHandler");
                pamSeedFromCrop = (Boolean)clazz3.getField("seedsdropfromcrop").get(null);
                MFRRegistry.registerHarvestable(new HarvestablePams(n2));
                MFRRegistry.registerFertilizable(new PamFertilizable(n2));
                String[] stringArray2 = Class.forName("assets.pamharvestcraft.BlockPamSapling");
                pamBlockSaplingFertilize = stringArray2.getDeclaredMethod("generateTree", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Random.class, Integer.TYPE);
                Block[] blockArray = (Block[])stringArray.getField("PamOakSaplings").get(null);
                for (Object object : blockArray) {
                    n = object.field_71990_ca;
                    MFRRegistry.registerFertilizable(new PamFertilizableSapling(n));
                    MFRRegistry.registerPlantable(new PlantableStandard(n, n));
                }
                blockArray = (Block[])stringArray.getField("PamJungleSaplings").get(null);
                for (Object object : blockArray) {
                    n = object.field_71990_ca;
                    MFRRegistry.registerFertilizable(new PamFertilizableSapling(n));
                    MFRRegistry.registerPlantable(new PlantableStandard(n, n));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Pam.registerCrop("Blackberry", true);
            Pam.registerCrop("Blueberry", true);
            Pam.registerCrop("Grape", true);
            Pam.registerCrop("Kiwi", true);
            Pam.registerCrop("Raspberry", true);
            Pam.registerCrop("Spiceleaf", true);
            Pam.registerCrop("Strawberry", true);
            Pam.registerCrop("Sunflower", true);
            Pam.registerCrop("Seaweed", true);
            Pam.registerCrop("Artichoke", false);
            Pam.registerCrop("Asparagus", false);
            Pam.registerCrop("Bambooshoot", false);
            Pam.registerCrop("Barley", false);
            Pam.registerCrop("Bean", false);
            Pam.registerCrop("Beet", false);
            Pam.registerCrop("Bellpepper", false);
            Pam.registerCrop("Broccoli", false);
            Pam.registerCrop("Brusselsprout", false);
            Pam.registerCrop("Cabbage", false);
            Pam.registerCrop("Cantaloupe", false);
            Pam.registerCrop("Cauliflower", false);
            Pam.registerCrop("Celery", false);
            Pam.registerCrop("Chilipepper", false);
            Pam.registerCrop("Coffee", false);
            Pam.registerCrop("Corn", false);
            Pam.registerCrop("Cucumber", false);
            Pam.registerCrop("Eggplant", false);
            Pam.registerCrop("Garlic", false);
            Pam.registerCrop("Ginger", false);
            Pam.registerCrop("Leek", false);
            Pam.registerCrop("Lettuce", false);
            Pam.registerCrop("Mustard", false);
            Pam.registerCrop("Oats", false);
            Pam.registerCrop("Okra", false);
            Pam.registerCrop("Onion", false);
            Pam.registerCrop("Parsnip", false);
            Pam.registerCrop("Peanut", false);
            Pam.registerCrop("Peas", false);
            Pam.registerCrop("Pineapple", false);
            Pam.registerCrop("Rhubarb", false);
            Pam.registerCrop("Radish", false);
            Pam.registerCrop("Rutabaga", false);
            Pam.registerCrop("Rye", false);
            Pam.registerCrop("Scallion", false);
            Pam.registerCrop("Soybean", false);
            Pam.registerCrop("Sweetpotato", false);
            Pam.registerCrop("Tea", false);
            Pam.registerCrop("Tomato", false);
            Pam.registerCrop("Turnip", false);
            Pam.registerCrop("Wintersquash", false);
            Pam.registerCrop("Zucchini", false);
            Pam.registerCrop("Candleberry", true);
            Pam.registerCrop("Cotton", true);
            Pam.registerCrop("Rice", false);
            Pam.registerCrop("Cranberry", true);
            Pam.registerCrop("Whitemushroom", true);
            Pam.registerCrop("Cactusfruit", true);
            Pam.registerFruit("Apple");
            Pam.registerFruit("Avocado");
            Pam.registerFruit("Banana");
            Pam.registerFruit("Cherry");
            Pam.registerFruit("Coconut");
            Pam.registerFruit("Dragonfruit");
            Pam.registerFruit("Lemon");
            Pam.registerFruit("Lime");
            Pam.registerFruit("Mango");
            Pam.registerFruit("Nutmeg");
            Pam.registerFruit("Olive");
            Pam.registerFruit("Orange");
            Pam.registerFruit("Papaya");
            Pam.registerFruit("Peach");
            Pam.registerFruit("Pear");
            Pam.registerFruit("Peppercorn");
            Pam.registerFruit("Plum");
            Pam.registerFruit("Pomegranate");
            Pam.registerFruit("Starfruit");
            Pam.registerFruit("Vanillabean");
            Pam.registerFruit("Walnut");
            Pam.registerCinnamon();
        }
        if (!Loader.isModLoaded((String)"pamweeeflowers")) {
            FMLLog.warning((String)"Pam's Weee! Flowers missing - MFR Pam Weee! Flowers Compat not loading", (Object[])new Object[0]);
        } else {
            stringArray = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "LightGrey", "DarkGrey", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
            try {
                Class<?> clazz4 = Class.forName("assets.pamweeeflowers.TileEntityPamFlowerCrop");
                pamTEFlowerGetCropId = clazz4.getDeclaredMethod("getCropID", classArray);
                pamTEFlowerGetGrowthStage = clazz4.getDeclaredMethod("getGrowthStage", classArray);
                pamTEFlowerSetCropId = clazz4.getDeclaredMethod("setCropID", classArray2);
                pamTEFlowerSetGrowthStage = clazz4.getDeclaredMethod("setGrowthStage", classArray2);
                clazz2 = Class.forName("assets.pamweeeflowers.BlockPamFlowerCrop");
                pamBlockFlowerFertilize = clazz2.getDeclaredMethod("fertilize", classArray3);
                clazz = Class.forName("assets.pamweeeflowers.PamWeeeFlowers");
                int n = ((Block)clazz.getField((String)"pamflowerCrop").get(null)).field_71990_ca;
                flowerId = ((Block)clazz.getField((String)"pamFlower").get(null)).field_71990_ca;
                MFRRegistry.registerHarvestable(new HarvestablePamsFlower(n));
                MFRRegistry.registerFertilizable(new PamFertilizableFlower(n));
                for (String string : stringArray) {
                    Item item = (Item)clazz.getField(string.toLowerCase() + "flowerseedItem").get(null);
                    int n3 = item.field_77779_bT;
                    int n4 = item.getClass().getField("cropID").getInt(item);
                    Pam.flowerSeeds[n4] = n3;
                    MFRRegistry.registerPlantable(new PlantablePamFlower(n, n3, n4));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FMLLog.warning((String)"Unable to load Pam support for Weee! Flowers even though Weee! FLowers was present", (Object[])new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void registerCrop(String string, boolean bl) {
        try {
            String string2 = string.toLowerCase();
            Class<?> clazz = Class.forName("assets.pamharvestcraft.PamHarvestCraft");
            Item item = (Item)clazz.getField(String.format("%sseedItem", string2)).get(null);
            int n = item.field_77779_bT;
            int n2 = ((Block)clazz.getField((String)"pamCrop").get(null)).field_71990_ca;
            int n3 = item.getClass().getField("cropID").getInt(item);
            MFRRegistry.registerPlantable(new PlantablePamCrop(n2, n, n3));
            if (bl) {
                int n4 = ((Block)clazz.getField((String)String.format((String)"pam%sWild", (Object[])new Object[]{string2})).get(null)).field_71990_ca;
                MFRRegistry.registerHarvestable(new HarvestableStandard(n4, HarvestType.Normal));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FMLLog.warning((String)"Unable to load Pam support for %s", (Object[])new Object[]{string});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void registerFruit(String string) {
        try {
            Block block = (Block)Class.forName("assets.pamharvestcraft.PamHarvestCraft").getField("pam" + string).get(null);
            MFRRegistry.registerFruit(new PamFruit(block.field_71990_ca));
        }
        catch (ClassNotFoundException classNotFoundException) {
            FMLLog.warning((String)"Unable to load Pam support for %s trees", (Object[])new Object[]{string});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void registerCinnamon() {
        try {
            Block block = (Block)Class.forName("assets.pamharvestcraft.PamHarvestCraft").getField("pamCinnamon").get(null);
            Item item = (Item)Class.forName("assets.pamharvestcraft.PamHarvestCraft").getField("cinnamonItem").get(null);
            MFRRegistry.registerFruit(new PamFruitCinnamon(block.field_71990_ca, item.field_77779_bT));
            MFRRegistry.registerFruitLogBlockId(block.field_71990_ca);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        flowerSeeds = new int[16];
    }
}

