/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import cofh.api.block.IBlockInfo;
import cofh.api.block.IDismantleable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNetworkContainer;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.item.ItemRedNetMeter;
import powercrystals.minefactoryreloaded.render.block.RedNetCableRenderer;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class BlockRedNetCable
extends BlockContainer
implements IRedNetNetworkContainer,
IBlockInfo,
IDismantleable {
    private static float _wireSize = 0.25f;
    private static float _cageSize = 0.375f;
    private static float _gripWidth = 0.5f;
    private static float _plateWidth = 0.875f;
    private static float _plateDepth = 0.125f;
    private static float _bandWidth = 0.3125f;
    private static float _bandOffset = 0.125f;
    private static float _bandDepth = 0.0625f;
    private static float _wireStart = 0.5f - _wireSize / 2.0f;
    private static float _wireEnd = 0.5f + _wireSize / 2.0f;
    private static float _cageStart = 0.5f - _cageSize / 2.0f;
    private static float _cageEnd = 0.5f + _cageSize / 2.0f;
    private static float _gripStart = 0.5f - _gripWidth / 2.0f;
    private static float _gripEnd = 0.5f + _gripWidth / 2.0f;
    private static float _plateStart = 0.5f - _plateWidth / 2.0f;
    private static float _plateEnd = 0.5f + _plateWidth / 2.0f;
    private static float _bandWidthStart = 0.5f - _bandWidth / 2.0f;
    private static float _bandWidthEnd = 0.5f + _bandWidth / 2.0f;
    private static float _bandDepthStart = _bandOffset;
    private static float _bandDepthEnd = _bandOffset + _bandDepth;
    private static int[] _subSideMappings = new int[]{6, 6, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5};
    public static Cuboid6[] subSelection = new Cuboid6[32];

    public BlockRedNetCable(int n) {
        super(n, Machine.MATERIAL);
        this.func_71864_b("mfr.cable.redstone");
        this.func_71848_c(0.8f);
        this.func_71849_a(MFRCreativeTab.tab);
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY) {
            return false;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
            MovingObjectPosition movingObjectPosition = this.func_71878_a(world, n, n2, n3, RayTracer.getStartVec((EntityPlayer)entityPlayer), RayTracer.getEndVec((EntityPlayer)entityPlayer));
            if (movingObjectPosition == null) {
                return false;
            }
            int n5 = ((ExtendedMOP)movingObjectPosition).subHit;
            n4 = _subSideMappings[n5];
            ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
            if (!tileEntityRedNetCable.onPartHit(entityPlayer, n4, n5)) {
                if (n5 >= 14 && n5 <= 20) {
                    if (MFRUtil.isHoldingUsableTool(entityPlayer, n, n2, n3)) {
                        if (!world.field_72995_K) {
                            int n6;
                            if (!entityPlayer.func_70093_af()) {
                                n6 = tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4)) + 1;
                                if (n6 > 15) {
                                    n6 = 0;
                                }
                            } else {
                                n6 = tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4)) - 1;
                                if (n6 < 0) {
                                    n6 = 15;
                                }
                            }
                            tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), n6);
                            world.func_72845_h(n, n2, n3);
                            return true;
                        }
                    } else if (itemStack != null && itemStack.field_77993_c == MineFactoryReloadedCore.rednetMeterItem.field_77779_bT) {
                        if (!world.field_72995_K) {
                            entityPlayer.func_70006_a(new ChatMessageComponent().func_111079_a("Side is " + ItemRedNetMeter._colorNames[tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4))]));
                        }
                    } else if (itemStack != null && itemStack.field_77993_c == Item.field_77756_aW.field_77779_bT && !world.field_72995_K) {
                        tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), 15 - itemStack.func_77960_j());
                        world.func_72845_h(n, n2, n3);
                        return true;
                    }
                } else if (n5 >= 0 && n5 <= 14) {
                    if (MFRUtil.isHoldingUsableTool(entityPlayer, n, n2, n3)) {
                        byte by = tileEntityRedNetCable.getMode(n4);
                        by = (byte)(by + 1);
                        if (!world.field_72995_K) {
                            if (n4 == 6) {
                                if (by > 1) {
                                    by = 0;
                                }
                                tileEntityRedNetCable.setMode(n4, by);
                                world.func_72845_h(n, n2, n3);
                                switch (by) {
                                    case 0: {
                                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.tile.standard"));
                                        break;
                                    }
                                    case 1: {
                                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.tile.cableonly"));
                                        break;
                                    }
                                }
                            } else {
                                if (by > 3) {
                                    by = 0;
                                }
                                tileEntityRedNetCable.setMode(n4, by);
                                world.func_72845_h(n, n2, n3);
                                switch (by) {
                                    case 0: {
                                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.connection.standard"));
                                        break;
                                    }
                                    case 1: {
                                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.connection.forced"));
                                        break;
                                    }
                                    case 2: {
                                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.connection.forcedstrong"));
                                        break;
                                    }
                                    case 3: {
                                        entityPlayer.func_70006_a(new ChatMessageComponent().func_111072_b("chat.info.mfr.rednet.connection.cableonly"));
                                        break;
                                    }
                                }
                            }
                        }
                    } else if (itemStack != null && itemStack.field_77993_c == MineFactoryReloadedCore.rednetMeterItem.field_77779_bT) {
                        if (!world.field_72995_K) {
                            entityPlayer.func_70006_a(new ChatMessageComponent().func_111079_a("Side is " + ItemRedNetMeter._colorNames[tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4))]));
                        }
                    } else if (itemStack != null && itemStack.field_77993_c == Item.field_77756_aW.field_77779_bT && !world.field_72995_K) {
                        tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), 15 - itemStack.func_77960_j());
                        world.func_72845_h(n, n2, n3);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void func_71871_a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
            ((TileEntityRedNetCable)tileEntity).addTraceableCuboids(linkedList, false);
            for (IndexedCuboid6 indexedCuboid6 : linkedList) {
                AxisAlignedBB axisAlignedBB2 = indexedCuboid6.toAABB();
                if (!axisAlignedBB.func_72326_a(axisAlignedBB2)) continue;
                list.add(axisAlignedBB2);
            }
        } else {
            super.func_71871_a(world, n, n2, n3, axisAlignedBB, list, entity);
        }
    }

    public MovingObjectPosition func_71878_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            ((TileEntityRedNetCable)tileEntity).addTraceableCuboids(linkedList, true);
        }
        return RayTracer.instance().rayTraceCuboids(new Vector3(vec3), new Vector3(vec32), linkedList, new BlockCoord(n, n2, n3), (Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onBlockHighlight(DrawBlockHighlightEvent drawBlockHighlightEvent) {
        if (drawBlockHighlightEvent.target.field_72313_a == EnumMovingObjectType.TILE && drawBlockHighlightEvent.player.field_70170_p.func_72798_a(drawBlockHighlightEvent.target.field_72311_b, drawBlockHighlightEvent.target.field_72312_c, drawBlockHighlightEvent.target.field_72309_d) == this.field_71990_ca) {
            RayTracer.retraceBlock((World)drawBlockHighlightEvent.player.field_70170_p, (EntityPlayer)drawBlockHighlightEvent.player, (int)drawBlockHighlightEvent.target.field_72311_b, (int)drawBlockHighlightEvent.target.field_72312_c, (int)drawBlockHighlightEvent.target.field_72309_d);
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71863_a(World world, int n, int n2, int n3, int n4) {
        super.func_71863_a(world, n, n2, n3, n4);
        if (n4 == this.field_71990_ca || world.field_72995_K) {
            return;
        }
        RedstoneNetwork.log("Cable block at %d, %d, %d got update from ID %d", n, n2, n3, n4);
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            ((TileEntityRedNetCable)tileEntity).onNeighboorChanged();
        }
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            if (((TileEntityRedNetCable)tileEntity).getNetwork() != null) {
                ((TileEntityRedNetCable)tileEntity).getNetwork().setInvalid();
            }
            world.func_72928_a(tileEntity);
            tileEntity.func_70313_j();
            world.func_72932_q(n, n2, n3);
        }
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition blockPosition = new BlockPosition(n, n2, n3);
            blockPosition.orientation = forgeDirection;
            blockPosition.moveForwards(1);
            world.func_72821_m(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
            world.func_72898_h(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
        }
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        ItemStack itemStack = new ItemStack(this.func_71885_a(this.field_71990_ca, world.field_73012_v, 0), 1, this.func_71899_b(world.func_72805_g(n, n2, n3)));
        world.func_94571_i(n, n2, n3);
        if (!bl) {
            this.func_71929_a(world, n, n2, n3, itemStack);
        }
        return itemStack;
    }

    @Override
    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        MovingObjectPosition movingObjectPosition = this.func_71878_a(world, n, n2, n3, RayTracer.getStartVec((EntityPlayer)entityPlayer), RayTracer.getEndVec((EntityPlayer)entityPlayer));
        if (movingObjectPosition == null) {
            return false;
        }
        int n4 = ((ExtendedMOP)movingObjectPosition).subHit;
        return n4 < 14 | n4 > 20;
    }

    public int func_71865_a(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = 0;
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
            RedNetConnectionType redNetConnectionType = tileEntityRedNetCable.getConnectionState(ForgeDirection.getOrientation((int)n4).getOpposite());
            if (tileEntityRedNetCable.getNetwork() == null || !redNetConnectionType.isConnected | !redNetConnectionType.isSingleSubnet) {
                return 0;
            }
            int n6 = ((TileEntityRedNetCable)tileEntity).getSideColor(ForgeDirection.getOrientation((int)n4).getOpposite());
            n5 = Math.min(Math.max(((TileEntityRedNetCable)tileEntity).getNetwork().getPowerLevelOutput(n6), 0), 15);
            RedstoneNetwork.log("Asked for weak power at " + n + "," + n2 + "," + n3 + ";" + ForgeDirection.getOrientation((int)n4).getOpposite() + " - got " + n5 + " from network " + ((TileEntityRedNetCable)tileEntity).getNetwork().getId() + ":" + n6, new Object[0]);
        }
        return n5;
    }

    public int func_71855_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = 0;
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
            RedNetConnectionType redNetConnectionType = tileEntityRedNetCable.getConnectionState(ForgeDirection.getOrientation((int)n4).getOpposite());
            if (tileEntityRedNetCable.getNetwork() == null || !redNetConnectionType.isConnected | !redNetConnectionType.isSingleSubnet) {
                return 0;
            }
            BlockPosition blockPosition = new BlockPosition(n, n2, n3, ForgeDirection.getOrientation((int)n4).getOpposite());
            blockPosition.moveForwards(1);
            int n6 = tileEntityRedNetCable.getSideColor(blockPosition.orientation);
            if (tileEntityRedNetCable.getNetwork().isWeakNode(blockPosition)) {
                n5 = 0;
                RedstoneNetwork.log("Asked for strong power at " + n + "," + n2 + "," + n3 + ";" + ForgeDirection.getOrientation((int)n4).getOpposite() + " - weak node, power 0", new Object[0]);
            } else {
                n5 = Math.min(Math.max(tileEntityRedNetCable.getNetwork().getPowerLevelOutput(n6), 0), 15);
                RedstoneNetwork.log("Asked for strong power at " + n + "," + n2 + "," + n3 + ";" + ForgeDirection.getOrientation((int)n4).getOpposite() + " - got " + n5 + " from network " + ((TileEntityRedNetCable)tileEntity).getNetwork().getId() + ":" + n6, new Object[0]);
            }
        }
        return n5;
    }

    public boolean isBlockSolidOnSide(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            return ((TileEntityRedNetCable)tileEntity).isSolidOnSide(forgeDirection.ordinal());
        }
        return false;
    }

    public boolean func_71853_i() {
        return true;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int n) {
        switch (n) {
            default: {
                return new TileEntityRedNetCable();
            }
            case 2: 
        }
        return new TileEntityRedNetEnergy();
    }

    public int func_71857_b() {
        return MineFactoryReloadedCore.renderIdRedNet;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a());
        RedNetCableRenderer.updateUVT(this.field_94336_cN);
    }

    @Override
    public void updateNetwork(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable && ((TileEntityRedNetCable)tileEntity).getNetwork() != null) {
            ((TileEntityRedNetCable)tileEntity).updateNodes();
        }
    }

    @Override
    public void updateNetwork(World world, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable && ((TileEntityRedNetCable)tileEntity).getNetwork() != null) {
            ((TileEntityRedNetCable)tileEntity).updateNodes();
        }
    }

    @Override
    public void getBlockInfo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer, List<String> list, boolean bl) {
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            ((TileEntityRedNetCable)tileEntity).getTileInfo(list, forgeDirection, entityPlayer, bl);
        }
    }

    public int func_71899_b(int n) {
        return n;
    }

    static {
        int n = 0;
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireStart, (double)_wireStart, (double)_wireEnd, (double)_wireEnd, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, 0.0, (double)_gripStart, (double)_gripEnd, (double)_plateDepth, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, (double)(1.0f - _plateDepth), (double)_gripStart, (double)_gripEnd, 1.0, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, (double)_gripStart, 0.0, (double)_gripEnd, (double)_gripEnd, (double)_plateDepth);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, (double)_gripStart, (double)(1.0f - _plateDepth), (double)_gripEnd, (double)_gripEnd, 1.0);
        BlockRedNetCable.subSelection[n++] = new Cuboid6(0.0, (double)_gripStart, (double)_gripStart, (double)_plateDepth, (double)_gripEnd, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)(1.0f - _plateDepth), (double)_gripStart, (double)_gripStart, 1.0, (double)_gripEnd, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, 0.0, (double)_plateStart, (double)_plateEnd, (double)_plateDepth, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, (double)(1.0f - _plateDepth), (double)_plateStart, (double)_plateEnd, 1.0, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, (double)_plateStart, 0.0, (double)_plateEnd, (double)_plateEnd, (double)_plateDepth);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, (double)_plateStart, (double)(1.0f - _plateDepth), (double)_plateEnd, (double)_plateEnd, 1.0);
        BlockRedNetCable.subSelection[n++] = new Cuboid6(0.0, (double)_plateStart, (double)_plateStart, (double)_plateDepth, (double)_plateEnd, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)(1.0f - _plateDepth), (double)_plateStart, (double)_plateStart, 1.0, (double)_plateEnd, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)_bandDepthStart, (double)_bandWidthStart, (double)_bandWidthEnd, (double)_bandDepthEnd, (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)(1.0f - _bandDepthEnd), (double)_bandWidthStart, (double)_bandWidthEnd, (double)(1.0f - _bandDepthStart), (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)_bandWidthStart, (double)_bandDepthStart, (double)_bandWidthEnd, (double)_bandWidthEnd, (double)_bandDepthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)_bandWidthStart, (double)(1.0f - _bandDepthEnd), (double)_bandWidthEnd, (double)_bandWidthEnd, (double)(1.0f - _bandDepthStart));
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandDepthStart, (double)_bandWidthStart, (double)_bandWidthStart, (double)_bandDepthEnd, (double)_bandWidthEnd, (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)(1.0f - _bandDepthEnd), (double)_bandWidthStart, (double)_bandWidthStart, (double)(1.0f - _bandDepthStart), (double)_bandWidthEnd, (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_plateDepth, (double)_wireStart, (double)_wireEnd, (double)_wireStart, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireEnd, (double)_wireStart, (double)_wireEnd, (double)(1.0f - _plateDepth), (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireStart, (double)_plateDepth, (double)_wireEnd, (double)_wireEnd, (double)_wireStart);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireStart, (double)_wireEnd, (double)_wireEnd, (double)_wireEnd, (double)(1.0f - _plateDepth));
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateDepth, (double)_wireStart, (double)_wireStart, (double)_wireStart, (double)_wireEnd, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireEnd, (double)_wireStart, (double)_wireStart, (double)(1.0f - _plateDepth), (double)_wireEnd, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_bandDepthEnd, (double)_cageStart, (double)_cageEnd, (double)_cageStart, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageEnd, (double)_cageStart, (double)_cageEnd, (double)(1.0f - _bandDepthEnd), (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_bandDepthEnd, (double)_cageEnd, (double)_cageEnd, (double)_cageStart);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd, (double)_cageEnd, (double)(1.0f - _bandDepthEnd));
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandDepthEnd, (double)_cageStart, (double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageEnd, (double)_cageStart, (double)_cageStart, (double)(1.0f - _bandDepthEnd), (double)_cageEnd, (double)_cageEnd);
    }
}

