/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cofh.api.block.IDismantleable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.BlockNBTManager;
import powercrystals.minefactoryreloaded.core.IEntityCollidable;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;

public class BlockFactoryMachine
extends BlockContainer
implements IConnectableRedNet,
IDismantleable {
    private int _mfrMachineBlockIndex;

    public BlockFactoryMachine(int n, int n2) {
        super(n, Machine.MATERIAL);
        this.func_71848_c(0.5f);
        this.func_71884_a(field_71977_i);
        this.func_71849_a(MFRCreativeTab.tab);
        this.func_71864_b("mfr.machine." + n2);
        this._mfrMachineBlockIndex = n2;
    }

    public int getBlockIndex() {
        return this._mfrMachineBlockIndex;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        Machine.LoadTextures(this._mfrMachineBlockIndex, iconRegister);
    }

    public Icon func_71895_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = iBlockAccess.func_72805_g(n, n2, n3);
        boolean bl = false;
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            n4 = ((TileEntityFactory)tileEntity).getRotatedSide(n4);
            bl = ((TileEntityFactory)tileEntity).isActive();
        }
        return Machine.getMachineFromIndex(this._mfrMachineBlockIndex, n5).getIcon(n4, bl);
    }

    public Icon func_71858_a(int n, int n2) {
        if (n > 1 && (n += 2) > 5) {
            n -= 4;
        }
        return Machine.getMachineFromIndex(this._mfrMachineBlockIndex, n2).getIcon(n, false);
    }

    public int getLightOpacity(World world, int n, int n2, int n3) {
        if (world.func_72796_p(n, n2, n3) instanceof TileEntityLaserDrill) {
            return 0;
        }
        return super.getLightOpacity(world, n, n2, n3);
    }

    public AxisAlignedBB func_71872_e(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof IEntityCollidable) {
            float f = 0.125f;
            return AxisAlignedBB.func_72330_a((double)((float)n + f), (double)((float)n2 + f), (double)((float)n3 + f), (double)((float)(n + 1) - f), (double)((float)(n2 + 1) - f), (double)((float)(n3 + 1) - f));
        }
        return super.func_71872_e(world, n, n2, n3);
    }

    public void func_71869_a(World world, int n, int n2, int n3, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof IEntityCollidable) {
            ((IEntityCollidable)tileEntity).onEntityCollided(entity);
        }
        super.func_71869_a(world, n, n2, n3, entity);
    }

    public void onNeighborTileChange(World world, int n, int n2, int n3, int n4, int n5, int n6) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            ((TileEntityFactory)tileEntity).onNeighborTileChange(n4, n5, n6);
        }
    }

    private void dropContents(TileEntity tileEntity) {
        if (tileEntity instanceof IInventory) {
            World world = tileEntity.field_70331_k;
            IInventory iInventory = (IInventory)tileEntity;
            TileEntityFactoryInventory tileEntityFactoryInventory = null;
            if (tileEntity instanceof TileEntityFactoryInventory) {
                tileEntityFactoryInventory = (TileEntityFactoryInventory)tileEntity;
            }
            int n = iInventory.func_70302_i_();
            while (n-- > 0) {
                ItemStack itemStack;
                if (tileEntityFactoryInventory != null && !tileEntityFactoryInventory.shouldDropSlotWhenBroken(n) || (itemStack = iInventory.func_70301_a(n)) == null) continue;
                iInventory.func_70299_a(n, null);
                while (itemStack.field_77994_a > 0) {
                    float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float f3 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    int n2 = Math.min(world.field_73012_v.nextInt(21) + 10, itemStack.field_77994_a);
                    EntityItem entityItem = new EntityItem(world, (double)((float)tileEntity.field_70329_l + f), (double)((float)tileEntity.field_70330_m + f2), (double)((float)tileEntity.field_70327_n + f3), itemStack.func_77979_a(n2));
                    float f4 = 0.05f;
                    entityItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f4;
                    entityItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f4 + 0.2f;
                    entityItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f4;
                    world.func_72838_d((Entity)entityItem);
                }
            }
        }
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity != null) {
            this.dropContents(tileEntity);
            if (tileEntity instanceof TileEntityFactoryInventory) {
                ((TileEntityFactoryInventory)tileEntity).onBlockBroken();
            }
            world.func_72928_a(tileEntity);
            tileEntity.func_70313_j();
            world.func_72932_q(n, n2, n3);
        }
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int n, int n2, int n3, int n4, int n5) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack(this.func_71885_a(this.field_71990_ca, world.field_73012_v, n5), 1, this.func_71899_b(n4));
        itemStack.func_77982_d(BlockNBTManager.getForBlock(n, n2, n3));
        arrayList.add(itemStack);
        return arrayList;
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            ItemStack itemStack = new ItemStack(this.func_71885_a(this.field_71990_ca, world.field_73012_v, 0), 1, this.func_71899_b(world.func_72805_g(n, n2, n3)));
            this.dropContents(tileEntity);
            if (tileEntity instanceof TileEntityFactoryInventory) {
                ((TileEntityFactoryInventory)tileEntity).onDisassembled();
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            tileEntity.func_70310_b(nBTTagCompound);
            if (tileEntity instanceof IInventory && ((IInventory)tileEntity).func_94042_c()) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.func_74778_a("Name", ((IInventory)tileEntity).func_70303_b());
                nBTTagCompound.func_74782_a("display", (NBTBase)nBTTagCompound2);
            }
            itemStack.func_77982_d(nBTTagCompound);
            world.func_94571_i(n, n2, n3);
            if (!bl) {
                this.func_71929_a(world, n, n2, n3, itemStack);
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        return world.func_72796_p(n, n2, n3) instanceof TileEntityFactory;
    }

    public void func_71860_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (entityLivingBase == null) {
            return;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_74768_a("x", n);
            itemStack.func_77978_p().func_74768_a("y", n2);
            itemStack.func_77978_p().func_74768_a("z", n3);
            tileEntity.func_70307_a(itemStack.func_77978_p());
        }
        if (tileEntity instanceof TileEntityFactory) {
            if (((TileEntityFactory)tileEntity).canRotate()) {
                switch (MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
                    case 0: {
                        ((TileEntityFactory)tileEntity).rotateDirectlyTo(3);
                        break;
                    }
                    case 1: {
                        ((TileEntityFactory)tileEntity).rotateDirectlyTo(4);
                        break;
                    }
                    case 2: {
                        ((TileEntityFactory)tileEntity).rotateDirectlyTo(2);
                        break;
                    }
                    case 3: {
                        ((TileEntityFactory)tileEntity).rotateDirectlyTo(5);
                    }
                }
            }
            if (tileEntity instanceof TileEntityFactoryInventory && itemStack.func_82837_s()) {
                ((TileEntityFactoryInventory)tileEntity).setInvName(itemStack.func_82833_r());
            }
            if (entityLivingBase instanceof ICommandSender && entityLivingBase.field_70175_ag) {
                ((TileEntityFactory)tileEntity).setOwner(((ICommandSender)entityLivingBase).func_70005_c_());
            } else {
                ((TileEntityFactory)tileEntity).setOwner(null);
            }
        }
    }

    public int func_71899_b(int n) {
        return n;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int n) {
        return Machine.getMachineFromIndex(this._mfrMachineBlockIndex, n).getNewTileEntity();
    }

    public boolean rotateBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        IRotateableTile iRotateableTile;
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof IRotateableTile && (iRotateableTile = (IRotateableTile)tileEntity).canRotate()) {
            iRotateableTile.rotate();
            return true;
        }
        return false;
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_94328_b_(World world, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactoryInventory) {
            return ((TileEntityFactoryInventory)tileEntity).getComparatorOutput(n4);
        }
        return 0;
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY) {
            return false;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity == null) {
            return false;
        }
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        if (tileEntity instanceof ITankContainerBucketable) {
            boolean bl;
            boolean bl2 = bl = itemStack != null && itemStack.func_77973_b() instanceof IFluidContainerItem;
            if (((ITankContainerBucketable)tileEntity).allowBucketDrain() && (bl || FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) && MFRLiquidMover.manuallyDrainTank((ITankContainerBucketable)tileEntity, entityPlayer)) {
                return true;
            }
            if (((ITankContainerBucketable)tileEntity).allowBucketFill() && (bl || FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) && MFRLiquidMover.manuallyFillTank((ITankContainerBucketable)tileEntity, entityPlayer)) {
                return true;
            }
        }
        if (tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).getContainer(entityPlayer.field_71071_by) != null) {
            if (!world.field_72995_K) {
                entityPlayer.openGui((Object)MineFactoryReloadedCore.instance(), 0, world, n, n2, n3);
            }
            return true;
        }
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean isBlockNormalCube(World world, int n, int n2, int n3) {
        return false;
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            return ((TileEntityFactory)tileEntity).getRedNetOutput(ForgeDirection.getOrientation((int)n4));
        }
        return 0;
    }

    public int func_71855_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return this.func_71865_a(iBlockAccess, n, n2, n3, n4);
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return RedNetConnectionType.CableSingle;
    }

    @Override
    public int[] getOutputValues(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return null;
    }

    @Override
    public int getOutputValue(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        return 0;
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            ((TileEntityFactory)tileEntity).onRedNetChanged(forgeDirection, n4);
            this.func_71863_a(world, n, n2, n3, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
        }
    }
}

