/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TravelerSet
implements Iterable<TravelingItem> {
    private final BiMap<Integer, TravelingItem> items = HashBiMap.create();
    private final Set<TravelingItem> toLoad = new HashSet<TravelingItem>();
    private final Set<TravelingItem> toAdd = new HashSet<TravelingItem>();
    private final Set<TravelingItem> toRemove = new HashSet<TravelingItem>();
    private int delay = 0;
    private final PipeTransportItems transport;

    public TravelerSet(PipeTransportItems transport) {
        this.transport = transport;
    }

    private boolean add(TravelingItem item) {
        if (this.items.containsValue((Object)item)) {
            return false;
        }
        item.setContainer(this.transport.container);
        this.items.put((Object)item.id, (Object)item);
        return true;
    }

    private boolean addAll(Collection<? extends TravelingItem> collection) {
        boolean changed = false;
        for (TravelingItem travelingItem : collection) {
            changed |= this.add(travelingItem);
        }
        return changed;
    }

    public TravelingItem get(int id) {
        return (TravelingItem)this.items.get((Object)id);
    }

    void scheduleLoad(TravelingItem item) {
        this.delay = 10;
        this.toLoad.add(item);
    }

    private void loadScheduledItems() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.addAll(this.toLoad);
        this.toLoad.clear();
    }

    public void scheduleAdd(TravelingItem item) {
        this.toAdd.add(item);
    }

    private void addScheduledItems() {
        this.addAll(this.toAdd);
        this.toAdd.clear();
    }

    public boolean scheduleRemoval(TravelingItem item) {
        return this.toRemove.add(item);
    }

    public boolean unscheduleRemoval(TravelingItem item) {
        return this.toRemove.remove(item);
    }

    void removeScheduledItems() {
        this.items.values().removeAll(this.toRemove);
        this.toRemove.clear();
    }

    void purgeBadItems() {
        Iterator it = this.items.values().iterator();
        while (it.hasNext()) {
            TravelingItem item = (TravelingItem)it.next();
            if (item.isCorrupted()) {
                it.remove();
                continue;
            }
            if (item.getContainer() == this.transport.container) continue;
            it.remove();
        }
    }

    void flush() {
        this.loadScheduledItems();
        this.addScheduledItems();
        this.removeScheduledItems();
        this.purgeBadItems();
    }

    @Override
    public Iterator<TravelingItem> iterator() {
        return this.items.values().iterator();
    }

    public int size() {
        return this.items.values().size();
    }

    void clear() {
        this.toRemove.addAll(this.items.values());
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

