/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.worldgen;

import buildcraft.energy.worldgen.SimplexNoise;
import java.util.Random;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public abstract class GenLayerBiomeReplacer
extends GenLayer {
    public static final int OFFSET_RANGE = 500000;
    protected final double xOffset;
    protected final double zOffset;
    protected final double noiseScale;
    protected final double noiseThreshold;
    protected final int newBiomeId;

    public GenLayerBiomeReplacer(long worldSeed, long seed, GenLayer parent, double noiseScale, double noiseThreshold, int newBiomeId) {
        super(seed);
        this.field_75909_a = parent;
        this.noiseScale = noiseScale;
        this.noiseThreshold = noiseThreshold;
        this.newBiomeId = newBiomeId;
        Random rand = new Random(worldSeed);
        this.xOffset = rand.nextInt(500000) - 250000;
        this.zOffset = rand.nextInt(500000) - 250000;
    }

    protected abstract boolean canReplaceBiome(int var1);

    public int[] func_75904_a(int x, int z, int width, int length) {
        int[] inputBiomeIDs = this.field_75909_a.func_75904_a(x - 1, z - 1, width + 2, length + 2);
        int[] outputBiomeIDs = IntCache.func_76445_a((int)(width * length));
        for (int xIter = 0; xIter < width; ++xIter) {
            for (int zIter = 0; zIter < length; ++zIter) {
                this.func_75903_a(xIter + x, zIter + z);
                int currentBiomeId = inputBiomeIDs[xIter + 1 + (zIter + 1) * (width + 2)];
                outputBiomeIDs[xIter + zIter * width] = this.canReplaceBiome(currentBiomeId) && SimplexNoise.noise(((double)(xIter + x) + this.xOffset) * this.noiseScale, ((double)(zIter + z) + this.zOffset) * this.noiseScale) > this.noiseThreshold ? this.newBiomeId : currentBiomeId;
            }
        }
        return outputBiomeIDs;
    }
}

