/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public abstract class GuiEngine
extends GuiBuildCraft {
    private static final ResourceLocation ITEM_TEXTURE = TextureMap.field_110576_c;

    public GuiEngine(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new EngineLedger((TileEngine)this.tile));
    }

    protected class EngineLedger
    extends GuiBuildCraft.Ledger {
        TileEngine engine;
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public EngineLedger(TileEngine engine) {
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ITEM_TEXTURE);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.currentOutput") + ":", x + 22, y + 20, this.subheaderColour);
            GuiEngine.this.field_73886_k.func_78276_b(String.format("%.1f MJ/t", Float.valueOf(this.engine.currentOutput)), x + 22, y + 32, this.textColour);
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiEngine.this.field_73886_k.func_78276_b(String.format("%.1f MJ", Float.valueOf(this.engine.getEnergyStored())), x + 22, y + 56, this.textColour);
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.heat") + ":", x + 22, y + 68, this.subheaderColour);
            GuiEngine.this.field_73886_k.func_78276_b(String.format("%.2f \u00b0C", Float.valueOf(this.engine.getHeat())), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f MJ/t", Float.valueOf(this.engine.currentOutput));
        }
    }
}

