/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.BuildCraftCore;
import buildcraft.core.ByteBuffer;
import buildcraft.core.network.TileNetworkData;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.TreeMap;

public class ClassMapping {
    private static TreeMap<String, Reporter> report = new TreeMap();
    private LinkedList<Field> floatFields = new LinkedList();
    private LinkedList<Field> doubleFields = new LinkedList();
    private LinkedList<Field> stringFields = new LinkedList();
    private LinkedList<Field> shortFields = new LinkedList();
    private LinkedList<Field> intFields = new LinkedList();
    private LinkedList<Field> booleanFields = new LinkedList();
    private LinkedList<Field> enumFields = new LinkedList();
    private LinkedList<Field> unsignedByteFields = new LinkedList();
    private LinkedList<ClassMapping> objectFields = new LinkedList();
    private LinkedList<Field> doubleArrayFields = new LinkedList();
    private LinkedList<Field> shortArrayFields = new LinkedList();
    private LinkedList<Field> intArrayFields = new LinkedList();
    private LinkedList<Field> booleanArrayFields = new LinkedList();
    private LinkedList<Field> unsignedByteArrayFields = new LinkedList();
    private LinkedList<Field> stringArrayFields = new LinkedList();
    private LinkedList<ClassMapping> objectArrayFields = new LinkedList();
    private int sizeBytes;
    private int sizeFloat;
    private int sizeString;
    private Field field;
    private Class<? extends Object> clas;

    public static int report() {
        int bytes = 0;
        for (Reporter r : report.values()) {
            System.out.println(r);
            bytes += r.bytes;
        }
        report.clear();
        return bytes;
    }

    public ClassMapping(Class<? extends Object> c) {
        this.clas = c;
        Field[] fields = c.getFields();
        try {
            for (Field f : fields) {
                if (!this.isSynchronizedField(f)) continue;
                Type t = f.getGenericType();
                if (t instanceof Class && !((Class)t).isArray()) {
                    Class fieldClass = (Class)t;
                    if (fieldClass.equals(Short.TYPE)) {
                        this.sizeBytes += 2;
                        this.shortFields.add(f);
                    } else if (fieldClass.equals(Integer.TYPE)) {
                        TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
                        if (updateAnnotation.intKind() == 1) {
                            ++this.sizeBytes;
                            this.unsignedByteFields.add(f);
                        } else {
                            this.sizeBytes += 4;
                            this.intFields.add(f);
                        }
                    } else if (fieldClass.equals(Boolean.TYPE)) {
                        ++this.sizeBytes;
                        this.booleanFields.add(f);
                    } else if (Enum.class.isAssignableFrom(fieldClass)) {
                        ++this.sizeBytes;
                        this.enumFields.add(f);
                    } else if (fieldClass.equals(String.class)) {
                        ++this.sizeString;
                        this.stringFields.add(f);
                    } else if (fieldClass.equals(Float.TYPE)) {
                        ++this.sizeFloat;
                        this.floatFields.add(f);
                    } else if (fieldClass.equals(Double.TYPE)) {
                        ++this.sizeFloat;
                        this.doubleFields.add(f);
                    } else {
                        ClassMapping mapping = new ClassMapping(fieldClass);
                        mapping.field = f;
                        this.objectFields.add(mapping);
                        ++this.sizeBytes;
                        this.sizeBytes += mapping.sizeBytes;
                        this.sizeFloat += mapping.sizeFloat;
                        this.sizeString += mapping.sizeString;
                    }
                }
                if (!(t instanceof Class) || !((Class)t).isArray()) continue;
                TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
                if (updateAnnotation.staticSize() == -1) {
                    throw new RuntimeException("arrays must be provided with an explicit size");
                }
                Class fieldClass = (Class)t;
                Class<?> cptClass = fieldClass.getComponentType();
                if (cptClass.equals(Double.TYPE)) {
                    this.sizeFloat += updateAnnotation.staticSize();
                    this.doubleArrayFields.add(f);
                    continue;
                }
                if (cptClass.equals(Short.TYPE)) {
                    this.sizeBytes += updateAnnotation.staticSize() * 2;
                    this.shortArrayFields.add(f);
                    continue;
                }
                if (cptClass.equals(Integer.TYPE)) {
                    updateAnnotation = f.getAnnotation(TileNetworkData.class);
                    if (updateAnnotation.intKind() == 1) {
                        this.sizeBytes += updateAnnotation.staticSize();
                        this.unsignedByteArrayFields.add(f);
                        continue;
                    }
                    this.sizeBytes += updateAnnotation.staticSize() * 4;
                    this.intArrayFields.add(f);
                    continue;
                }
                if (cptClass.equals(String.class)) {
                    this.sizeString += updateAnnotation.staticSize();
                    this.stringArrayFields.add(f);
                    continue;
                }
                if (cptClass.equals(Boolean.TYPE)) {
                    this.sizeBytes += updateAnnotation.staticSize();
                    this.booleanArrayFields.add(f);
                    continue;
                }
                ClassMapping mapping = new ClassMapping(cptClass);
                mapping.field = f;
                this.objectArrayFields.add(mapping);
                this.sizeBytes += updateAnnotation.staticSize();
                this.sizeBytes += updateAnnotation.staticSize() * mapping.sizeBytes;
                this.sizeFloat += updateAnnotation.staticSize() * mapping.sizeFloat;
                this.sizeString += updateAnnotation.staticSize() * mapping.sizeString;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private boolean isSynchronizedField(Field f) {
        TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
        return updateAnnotation != null;
    }

    public void setData(Object obj, ByteBuffer byteBuffer, float[] floatValues, String[] stringValues, Indexes index) throws IllegalArgumentException, IllegalAccessException {
        TileNetworkData updateAnnotation;
        int i;
        Reporter r = null;
        if (BuildCraftCore.trackNetworkUsage) {
            if (!report.containsKey(this.clas.getName())) {
                report.put(this.clas.getName(), new Reporter());
            }
            r = report.get(this.clas.getName());
            r.clas = this.clas;
        } else {
            r = new Reporter();
        }
        ++r.occurences;
        for (Field f : this.shortFields) {
            byteBuffer.writeShort(f.getShort(obj));
            r.bytes += 2;
            ++r.dataInt;
        }
        for (Field f : this.intFields) {
            byteBuffer.writeInt(f.getInt(obj));
            r.bytes += 4;
            ++r.dataInt;
        }
        for (Field f : this.booleanFields) {
            byteBuffer.writeUnsignedByte(f.getBoolean(obj) ? 1 : 0);
            ++r.bytes;
            ++r.dataInt;
        }
        for (Field f : this.enumFields) {
            byteBuffer.writeUnsignedByte(((Enum)f.get(obj)).ordinal());
            ++r.bytes;
            ++r.dataInt;
        }
        for (Field f : this.unsignedByteFields) {
            byteBuffer.writeUnsignedByte(f.getInt(obj));
            ++r.bytes;
            ++r.dataInt;
        }
        for (Field f : this.floatFields) {
            floatValues[index.floatIndex] = f.getFloat(obj);
            ++index.floatIndex;
            r.bytes += 4;
            ++r.dataFloat;
        }
        for (Field f : this.doubleFields) {
            floatValues[index.floatIndex] = (float)f.getDouble(obj);
            ++index.floatIndex;
            r.bytes += 4;
            ++r.dataFloat;
        }
        for (Field f : this.stringFields) {
            stringValues[index.stringIndex] = (String)f.get(obj);
            r.bytes += stringValues[index.stringIndex].length();
            ++index.stringIndex;
            ++r.dataString;
        }
        for (ClassMapping c : this.objectFields) {
            Object cpt = c.field.get(obj);
            if (cpt == null) {
                byteBuffer.writeUnsignedByte(0);
                for (i = 0; i < c.sizeBytes; ++i) {
                    byteBuffer.writeUnsignedByte(0);
                    ++r.bytes;
                    ++r.dataInt;
                }
                index.floatIndex += c.sizeFloat;
                index.stringIndex += c.sizeString;
                continue;
            }
            byteBuffer.writeUnsignedByte(1);
            ++r.bytes;
            ++r.dataInt;
            c.setData(cpt, byteBuffer, floatValues, stringValues, index);
        }
        for (Field f : this.doubleArrayFields) {
            updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                floatValues[index.floatIndex] = (float)((double[])f.get(obj))[i];
                ++index.floatIndex;
                r.bytes += 4;
                ++r.dataFloat;
            }
        }
        for (Field f : this.shortArrayFields) {
            updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                byteBuffer.writeShort(((short[])f.get(obj))[i]);
                r.bytes += 2;
                ++r.dataInt;
            }
        }
        for (Field f : this.intArrayFields) {
            updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                byteBuffer.writeInt(((int[])f.get(obj))[i]);
                r.bytes += 4;
                ++r.dataInt;
            }
        }
        for (Field f : this.booleanArrayFields) {
            updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                byteBuffer.writeUnsignedByte(((boolean[])f.get(obj))[i] ? 1 : 0);
                ++r.bytes;
                ++r.dataInt;
            }
        }
        for (Field f : this.unsignedByteFields) {
            updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                byteBuffer.writeUnsignedByte(((int[])f.get(obj))[i]);
                ++r.bytes;
                ++r.dataInt;
            }
        }
        for (Field f : this.stringArrayFields) {
            updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                stringValues[index.stringIndex] = ((String[])f.get(obj))[i];
                r.bytes += stringValues[index.stringIndex].length();
                ++index.stringIndex;
                ++r.dataString;
            }
        }
        for (ClassMapping c : this.objectArrayFields) {
            updateAnnotation = c.field.getAnnotation(TileNetworkData.class);
            Object[] cpts = (Object[])c.field.get(obj);
            for (int i2 = 0; i2 < updateAnnotation.staticSize(); ++i2) {
                if (cpts[i2] == null) {
                    byteBuffer.writeUnsignedByte(0);
                    for (int j = 0; j < c.sizeBytes; ++j) {
                        byteBuffer.writeUnsignedByte(0);
                        ++r.bytes;
                        ++r.dataInt;
                    }
                    index.floatIndex += c.sizeFloat;
                    index.stringIndex += c.sizeString;
                    continue;
                }
                byteBuffer.writeUnsignedByte(1);
                ++r.bytes;
                ++r.dataInt;
                c.setData(cpts[i2], byteBuffer, floatValues, stringValues, index);
            }
        }
    }

    public void updateFromData(Object obj, ByteBuffer byteBuffer, float[] floatValues, String[] stringValues, Indexes index) throws IllegalArgumentException, IllegalAccessException {
        int i;
        int i2;
        Reporter r = null;
        if (BuildCraftCore.trackNetworkUsage) {
            if (!report.containsKey(this.clas.getName())) {
                report.put(this.clas.getName(), new Reporter());
            }
            r = report.get(this.clas.getName());
            r.clas = this.clas;
        } else {
            r = new Reporter();
        }
        ++r.occurences;
        for (Field f : this.shortFields) {
            f.setShort(obj, byteBuffer.readShort());
            r.bytes += 2;
            ++r.dataInt;
        }
        for (Field f : this.intFields) {
            f.setInt(obj, byteBuffer.readInt());
            r.bytes += 4;
            ++r.dataInt;
        }
        for (Field f : this.booleanFields) {
            f.setBoolean(obj, byteBuffer.readUnsignedByte() == 1);
            ++r.bytes;
            ++r.dataInt;
        }
        for (Field f : this.enumFields) {
            f.set(obj, ((Class)f.getGenericType()).getEnumConstants()[byteBuffer.readUnsignedByte()]);
            ++r.bytes;
            ++r.dataInt;
        }
        for (Field f : this.unsignedByteFields) {
            f.setInt(obj, byteBuffer.readUnsignedByte());
            ++r.bytes;
            ++r.dataInt;
        }
        for (Field f : this.floatFields) {
            f.setFloat(obj, floatValues[index.floatIndex]);
            ++index.floatIndex;
            r.bytes += 4;
            ++r.dataFloat;
        }
        for (Field f : this.doubleFields) {
            f.setDouble(obj, floatValues[index.floatIndex]);
            ++index.floatIndex;
            r.bytes += 4;
            ++r.dataFloat;
        }
        for (Field f : this.stringFields) {
            f.set(obj, stringValues[index.stringIndex]);
            r.bytes += stringValues[index.stringIndex].length();
            ++index.stringIndex;
            ++r.dataString;
        }
        for (ClassMapping c : this.objectFields) {
            boolean isNull = byteBuffer.readUnsignedByte() == 0;
            ++r.bytes;
            ++r.dataInt;
            if (isNull) {
                for (i2 = 0; i2 < c.sizeBytes; ++i2) {
                    byteBuffer.readUnsignedByte();
                }
                index.floatIndex += c.sizeFloat;
                index.stringIndex += c.sizeString;
                continue;
            }
            c.updateFromData(c.field.get(obj), byteBuffer, floatValues, stringValues, index);
        }
        for (Field f : this.doubleArrayFields) {
            TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i2 = 0; i2 < updateAnnotation.staticSize(); ++i2) {
                ((double[])f.get((Object)obj))[i2] = floatValues[index.floatIndex];
                ++index.floatIndex;
                r.bytes += 4;
                ++r.dataFloat;
            }
        }
        for (Field f : this.shortArrayFields) {
            TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i2 = 0; i2 < updateAnnotation.staticSize(); ++i2) {
                ((short[])f.get((Object)obj))[i2] = byteBuffer.readShort();
                r.bytes += 2;
                ++r.dataInt;
            }
        }
        for (Field f : this.intArrayFields) {
            TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i2 = 0; i2 < updateAnnotation.staticSize(); ++i2) {
                ((int[])f.get((Object)obj))[i2] = byteBuffer.readInt();
                r.bytes += 4;
                ++r.dataInt;
            }
        }
        for (Field f : this.booleanArrayFields) {
            TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i2 = 0; i2 < updateAnnotation.staticSize(); ++i2) {
                ((boolean[])f.get((Object)obj))[i2] = byteBuffer.readUnsignedByte() == 1;
                ++r.bytes;
                ++r.dataInt;
            }
        }
        for (Field f : this.unsignedByteArrayFields) {
            TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
            for (i2 = 0; i2 < updateAnnotation.staticSize(); ++i2) {
                ((int[])f.get((Object)obj))[i2] = byteBuffer.readUnsignedByte();
                ++r.bytes;
                ++r.dataInt;
            }
        }
        for (Field f : this.stringArrayFields) {
            TileNetworkData updateAnnotation = f.getAnnotation(TileNetworkData.class);
            String[] strs = (String[])f.get(obj);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                strs[i] = stringValues[index.stringIndex];
                r.bytes += stringValues[index.stringIndex].length();
                ++index.stringIndex;
                ++r.dataString;
            }
        }
        for (ClassMapping c : this.objectArrayFields) {
            TileNetworkData updateAnnotation = c.field.getAnnotation(TileNetworkData.class);
            Object[] cpts = (Object[])c.field.get(obj);
            for (i = 0; i < updateAnnotation.staticSize(); ++i) {
                boolean isNull = byteBuffer.readUnsignedByte() == 0;
                ++r.bytes;
                ++r.dataInt;
                if (isNull) {
                    for (int j = 0; j < c.sizeBytes; ++j) {
                        byteBuffer.readUnsignedByte();
                    }
                    index.floatIndex += c.sizeFloat;
                    index.stringIndex += c.sizeString;
                    continue;
                }
                c.updateFromData(cpts[i], byteBuffer, floatValues, stringValues, index);
            }
        }
    }

    public int[] getSize() {
        int[] result = new int[]{this.sizeBytes, this.sizeFloat, this.sizeString};
        return result;
    }

    public static class Indexes {
        int floatIndex = 0;
        int stringIndex = 0;

        public Indexes(int initFloat, int initString) {
            this.floatIndex = initFloat;
            this.stringIndex = initString;
        }
    }

    public static class Reporter {
        Class<? extends Object> clas;
        int occurences = 0;
        int dataInt = 0;
        int dataFloat = 0;
        int dataString = 0;
        int bytes = 0;

        public String toString() {
            String res = this.clas + ": " + this.occurences + " times (" + this.dataInt + ", " + this.dataFloat + ", " + this.dataString + " = " + this.bytes + ")";
            return res;
        }
    }
}

