/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import java.util.LinkedList;

public class ByteBuffer {
    LinkedList<Integer> bytes = new LinkedList();

    public void writeUnsignedByte(int s) {
        this.bytes.add(s - 127);
    }

    public void writeUnsignedShort(int s) {
        this.writeUnsignedByte(s & 0xFF);
        this.writeUnsignedByte(s >> 8 & 0xFF);
    }

    public void writeShort(short s) {
        this.writeUnsignedByte(s & 0xFF);
        this.writeUnsignedByte(s >> 8 & 0xFF);
    }

    public void writeInt(int i) {
        this.writeUnsignedByte(i & 0xFF);
        this.writeUnsignedByte(i >> 8 & 0xFF);
        this.writeUnsignedByte(i >> 16 & 0xFF);
        this.writeUnsignedByte(i >> 24 & 0xFF);
    }

    public short readUnsignedByte() {
        short res = 0;
        if (this.bytes.size() == 0) {
            return res;
        }
        res = (short)(res + (short)(this.bytes.removeFirst() + 127));
        return res;
    }

    public int readUnsignedShort() {
        int res = 0;
        if (this.bytes.size() == 0) {
            return res;
        }
        res += this.readUnsignedByte();
        return res += this.readUnsignedByte() << 8;
    }

    public short readShort() {
        short res = 0;
        if (this.bytes.size() == 0) {
            return res;
        }
        res = (short)(res + this.readUnsignedByte());
        res = (short)(res + (this.readUnsignedByte() << 8));
        return res;
    }

    public int readInt() {
        int res = 0;
        if (this.bytes.size() == 0) {
            return res;
        }
        res += this.readUnsignedByte();
        res += this.readUnsignedByte() << 8;
        res += this.readUnsignedByte() << 16;
        return res += this.readUnsignedByte() << 24;
    }

    public int[] readIntArray() {
        LinkedList<Integer> ints = new LinkedList<Integer>();
        while (this.bytes.size() > 0) {
            ints.add(this.readInt());
        }
        int[] res = new int[ints.size()];
        int index = 0;
        for (Integer val : ints) {
            res[index] = val;
            ++index;
        }
        return res;
    }

    public void writeIntArray(int[] arr) {
        for (int i : arr) {
            this.writeInt(i);
        }
    }
}

