/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.builders.ItemBptBase;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.core.Box;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptTemplate;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;

public class TileArchitect
extends TileBuildCraft
implements IInventory {
    @TileNetworkData
    public Box box = new Box();
    private ItemStack[] items = new ItemStack[2];
    private boolean isComputing = false;
    public int computingTime = 0;
    @TileNetworkData
    public String name = "";
    private int lastBptId = 0;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (CoreProxy.proxy.isSimulating(this.field_70331_k) && this.isComputing) {
            if (this.computingTime < 200) {
                ++this.computingTime;
            } else {
                this.createBpt();
            }
        }
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!this.box.isInitialized() && (a = Utils.getNearbyAreaProvider(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)) != null) {
            this.box.initialize(a);
            a.removeFromWorld();
        }
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k) && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
        this.sendNetworkUpdate();
    }

    public void createBpt() {
        ItemStack stack;
        BptBase result;
        if (!this.box.isInitialized() || this.items[1] != null) {
            return;
        }
        BptContext context = null;
        if (this.items[0].func_77973_b() instanceof ItemBptTemplate) {
            result = this.createBptTemplate();
            context = new BptContext(this.field_70331_k, null, this.box);
        } else {
            result = this.createBptBlueprint();
            context = new BptContext(this.field_70331_k, (BptBlueprint)result, this.box);
        }
        if (!this.name.equals("")) {
            result.setName(this.name);
        }
        result.anchorX = this.field_70329_l - this.box.xMin;
        result.anchorY = this.field_70330_m - this.box.yMin;
        result.anchorZ = this.field_70327_n - this.box.zMin;
        ForgeDirection o = ForgeDirection.values()[this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n)].getOpposite();
        if (o != ForgeDirection.EAST) {
            if (o == ForgeDirection.SOUTH) {
                result.rotateLeft(context);
                result.rotateLeft(context);
                result.rotateLeft(context);
            } else if (o == ForgeDirection.WEST) {
                result.rotateLeft(context);
                result.rotateLeft(context);
            } else if (o == ForgeDirection.NORTH) {
                result.rotateLeft(context);
            }
        }
        if (result.equals(BuildCraftBuilders.getBptRootIndex().getBluePrint(this.lastBptId))) {
            result = BuildCraftBuilders.getBptRootIndex().getBluePrint(this.lastBptId);
            stack = BuildCraftBuilders.getBptItemStack(this.items[0].field_77993_c, this.lastBptId, result.getName());
        } else {
            int bptId = BuildCraftBuilders.getBptRootIndex().storeBluePrint(result);
            stack = BuildCraftBuilders.getBptItemStack(this.items[0].field_77993_c, bptId, result.getName());
            this.lastBptId = bptId;
        }
        this.func_70299_a(1, stack);
        this.func_70299_a(0, null);
    }

    public BptBase createBptTemplate() {
        int mask1 = 1;
        int mask0 = 0;
        if (this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            mask1 = 0;
            mask0 = 1;
        }
        BptTemplate result = new BptTemplate(this.box.sizeX(), this.box.sizeY(), this.box.sizeZ());
        for (int x = this.box.xMin; x <= this.box.xMax; ++x) {
            for (int y = this.box.yMin; y <= this.box.yMax; ++y) {
                for (int z = this.box.zMin; z <= this.box.zMax; ++z) {
                    if (!this.field_70331_k.func_72799_c(x, y, z)) {
                        result.setBlockId(x - this.box.xMin, y - this.box.yMin, z - this.box.zMin, mask1);
                        continue;
                    }
                    result.setBlockId(x - this.box.xMin, y - this.box.yMin, z - this.box.zMin, mask0);
                }
            }
        }
        return result;
    }

    private BptBase createBptBlueprint() {
        BptBlueprint result = new BptBlueprint(this.box.sizeX(), this.box.sizeY(), this.box.sizeZ());
        BptContext context = new BptContext(this.field_70331_k, result, this.box);
        for (int x = this.box.xMin; x <= this.box.xMax; ++x) {
            for (int y = this.box.yMin; y <= this.box.yMax; ++y) {
                for (int z = this.box.zMin; z <= this.box.zMax; ++z) {
                    result.readFromWorld(context, this, x, y, z);
                }
            }
        }
        return result;
    }

    public void handleClientInput(char c) {
        if (c == '\b') {
            if (this.name.length() > 0) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        } else if ((Character.isLetterOrDigit(c) || c == ' ') && this.name.length() < 14) {
            this.name = this.name + c;
        }
        this.sendNetworkUpdate();
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result;
        if (this.items[i] == null) {
            result = null;
        } else if (this.items[i].field_77994_a > j) {
            result = this.items[i].func_77979_a(j);
        } else {
            ItemStack tmp = this.items[i];
            this.items[i] = null;
            result = tmp;
        }
        this.initializeComputing();
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        this.initializeComputing();
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.items[slot];
        this.items[slot] = null;
        return toReturn;
    }

    public String func_70303_b() {
        return "Template";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.lastBptId = nbttagcompound.func_74762_e("lastTemplateId");
        this.computingTime = nbttagcompound.func_74762_e("computingTime");
        this.isComputing = nbttagcompound.func_74767_n("isComputing");
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.items.length) continue;
            this.items[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.name = nbttagcompound.func_74779_i("name");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("lastTemplateId", this.lastBptId);
        nbttagcompound.func_74768_a("computingTime", this.computingTime);
        nbttagcompound.func_74757_a("isComputing", this.isComputing);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        nbttagcompound.func_74778_a("name", this.name);
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box.isInitialized()) {
            this.box.deleteLasers();
        }
    }

    private void initializeComputing() {
        if (!this.box.isInitialized()) {
            return;
        }
        if (!this.isComputing) {
            if (this.items[0] != null && this.items[0].func_77973_b() instanceof ItemBptBase && this.items[1] == null) {
                this.isComputing = true;
                this.computingTime = 0;
            } else {
                this.isComputing = false;
                this.computingTime = 0;
            }
        } else if (this.items[0] == null || !(this.items[0].func_77973_b() instanceof ItemBptBase)) {
            this.isComputing = false;
            this.computingTime = 0;
        }
    }

    public int getComputingProgressScaled(int i) {
        return this.computingTime * i / 200;
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) throws IOException {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

