/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.tick;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.sound.Musique;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PlayerTickHandler
implements ITickHandler {
    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        EntityPlayer player = MusePlayerUtils.toPlayer(tickData[0]);
        this.handle(player);
    }

    public void handle(EntityPlayer player) {
        boolean foundItem;
        List<ItemStack> modularItemsEquipped = MuseItemUtils.modularItemsEquipped(player);
        double totalWeight = MuseItemUtils.getPlayerWeight(player);
        double weightCapacity = 25000.0;
        for (ItemStack stack : modularItemsEquipped) {
            if (!stack.func_77978_p().func_74764_b("ench")) continue;
            stack.func_77978_p().func_82580_o("ench");
        }
        for (IPlayerTickModule module : ModuleManager.getPlayerTickModules()) {
            boolean foundItemWithModule = false;
            for (ItemStack itemStack : modularItemsEquipped) {
                if (!module.isValidForItem(itemStack) || !ModuleManager.itemHasActiveModule(itemStack, module.getDataName())) continue;
                module.onPlayerTickActive(player, itemStack);
                foundItemWithModule = true;
            }
            if (foundItemWithModule) continue;
            for (ItemStack itemStack : modularItemsEquipped) {
                module.onPlayerTickInactive(player, itemStack);
            }
        }
        boolean bl = foundItem = modularItemsEquipped.size() > 0;
        if (foundItem) {
            player.field_70143_R = (float)MovementManager.computeFallHeightFromVelocity(MuseMathUtils.clampDouble((double)player.field_70181_x, (double)-1000.0, (double)0.0));
            if (totalWeight > weightCapacity) {
                player.field_70159_w *= weightCapacity / totalWeight;
                player.field_70179_y *= weightCapacity / totalWeight;
            }
            MuseHeatUtils.coolPlayer(player, MusePlayerUtils.getPlayerCoolingBasedOnMaterial(player));
            double maxHeat = MuseHeatUtils.getMaxHeat(player);
            double currHeat = MuseHeatUtils.getPlayerHeat(player);
            if (currHeat > maxHeat) {
                player.func_70097_a(MuseHeatUtils.overheatDamage, (float)((int)Math.sqrt(currHeat - maxHeat) / 4));
                player.func_70015_d(1);
            } else {
                player.func_70066_B();
            }
            double velsq2 = MuseMathUtils.sumsq((double)player.field_70159_w, (double)player.field_70181_x, (double)player.field_70179_y) - 0.5;
            if (player.field_70160_al && velsq2 > 0.0) {
                Musique.playerSound((EntityPlayer)player, (String)"powersuits:Glider", (float)((float)(velsq2 / 3.0)), (float)1.0f, (boolean)true);
            } else {
                Musique.stopPlayerSound((EntityPlayer)player, (String)"powersuits:Glider");
            }
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        EntityPlayer player = MusePlayerUtils.toPlayer(tickData[0]);
        List<ItemStack> stacks = MuseItemUtils.getModularItemsInInventory((IInventory)player.field_71071_by);
    }

    public static World toWorld(Object data) {
        World world = null;
        try {
            world = (World)data;
        }
        catch (ClassCastException e) {
            MuseLogger.logError((String)"MMMPS: Player tick handler received invalid World object");
            e.printStackTrace();
        }
        return world;
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "MMMPS: Player Tick";
    }
}

