/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.network.packets.MusePacketPlasmaBolt;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class PlasmaCannonModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_PLASMA_CANNON = "Plasma Cannon";
    public static final String PLASMA_CANNON_ENERGY_PER_TICK = "Plasma Energy Per Tick";
    public static final String PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE = "Plasma Damage At Full Charge";
    public static final String PLASMA_CANNON_EXPLOSIVENESS = "Plasma Explosiveness";

    public PlasmaCannonModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(PLASMA_CANNON_ENERGY_PER_TICK, 10.0, "J");
        this.addBaseProperty(PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE, 2.0, "pt");
        this.addTradeoffProperty("Amperage", PLASMA_CANNON_ENERGY_PER_TICK, 150.0, "J");
        this.addTradeoffProperty("Amperage", PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE, 38.0, "pt");
        this.addTradeoffProperty("Voltage", PLASMA_CANNON_ENERGY_PER_TICK, 50.0, "J");
        this.addTradeoffProperty("Voltage", PLASMA_CANNON_EXPLOSIVENESS, 0.5, "Creeper");
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.fieldEmitter, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.hvcapacitor, 2));
    }

    @Override
    public String getCategory() {
        return "Weapon";
    }

    @Override
    public String getDataName() {
        return MODULE_PLASMA_CANNON;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.plasmaCannon.name");
    }

    @Override
    public String getDescription() {
        return "Use electrical arcs in a containment field to superheat air to a plasma and launch it at enemies.";
    }

    @Override
    public String getTextureFile() {
        return "gravityweapon";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
        if (ElectricItemUtils.getPlayerEnergy(player) > 500.0) {
            player.func_71008_a(item, 72000);
        }
    }

    @Override
    public void onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
        int chargeTicks = (int)MuseMathUtils.clampDouble((double)(itemStack.func_77988_m() - par4), (double)10.0, (double)50.0);
        if (!world.field_72995_K) {
            double energyConsumption = ModuleManager.computeModularProperty(itemStack, PLASMA_CANNON_ENERGY_PER_TICK) * (double)chargeTicks;
            MuseHeatUtils.heatPlayer(player, energyConsumption / 500.0);
            if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
                double explosiveness = ModuleManager.computeModularProperty(itemStack, PLASMA_CANNON_EXPLOSIVENESS);
                double damagingness = ModuleManager.computeModularProperty(itemStack, PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE);
                EntityPlasmaBolt plasmaBolt = new EntityPlasmaBolt(world, (EntityLivingBase)player, explosiveness, damagingness, chargeTicks);
                world.func_72838_d((Entity)plasmaBolt);
                MusePacketPlasmaBolt packet = new MusePacketPlasmaBolt((Player)player, plasmaBolt.field_70157_k, plasmaBolt.size);
                PacketDispatcher.sendPacketToAllPlayers((Packet)packet.getPacket131());
            }
        }
    }
}

