/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import cofh.api.tileentity.IReconfigurableFacing;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.tile.IWrenchable;
import java.util.List;
import mods.mffs.api.IMFFS_Wrench;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseBlockUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class OmniWrenchModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_OMNI_WRENCH = "Prototype OmniWrench";
    public static final int[] SIDE_OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};

    public OmniWrenchModule(List<IModularItem> validItems) {
        super(validItems);
        if (ModCompatability.isOmniToolsLoaded() && GameRegistry.findItemStack((String)"OmniTools", (String)"OmniWrench", (int)1) != null) {
            this.addInstallCost(GameRegistry.findItemStack((String)"OmniTools", (String)"OmniWrench", (int)1));
        } else {
            this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
            this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        }
    }

    @Override
    public String getTextureFile() {
        return "omniwrench";
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_OMNI_WRENCH;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.omniwrench.name");
    }

    @Override
    public String getDescription() {
        return "A wrench which can interact with almost every mod.";
    }

    @Override
    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack item) {
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int bId = world.func_72798_a(x, y, z);
        int bMeta = world.func_72805_g(x, y, z);
        if (MuseBlockUtils.canRotate(bId)) {
            if (player.func_70093_af()) {
                world.func_72921_c(x, y, z, MuseBlockUtils.rotateVanillaBlockAlt(world, bId, bMeta, x, y, z), 3);
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    String soundName = Block.field_71973_m[bId].field_72020_cn.func_82593_b();
                    FMLClientHandler.instance().getClient().field_71416_A.func_77366_a(soundName, 1.0f, 0.6f);
                }
            } else {
                world.func_72921_c(x, y, z, MuseBlockUtils.rotateVanillaBlock(world, bId, bMeta, x, y, z), 3);
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    String soundName = Block.field_71973_m[bId].field_72020_cn.func_82593_b();
                    FMLClientHandler.instance().getClient().field_71416_A.func_77366_a(soundName, 1.0f, 0.8f);
                }
            }
            return !world.field_72995_K;
        }
        if (Block.field_71973_m[bId] != null && Block.field_71973_m[bId].rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            return !world.field_72995_K;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof IWrenchable) {
            IWrenchable wrenchTile = (IWrenchable)tile;
            if (player.func_70093_af()) {
                side = SIDE_OPPOSITE[side];
            }
            if (tile instanceof IMFFS_Wrench && !((IMFFS_Wrench)tile).wrenchCanManipulate(player, side)) {
                return false;
            }
            if (side == wrenchTile.getFacing() && wrenchTile.wrenchCanRemove(player)) {
                ItemStack dropBlock = wrenchTile.getWrenchDrop(player);
                if (dropBlock != null) {
                    world.func_94575_c(x, y, z, 0);
                    if (!world.field_72995_K) {
                        float f = 0.7f;
                        double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        EntityItem entity = new EntityItem(world, (double)x + x2, (double)y + y2, (double)z + z2, dropBlock);
                        entity.field_70293_c = 10;
                        world.func_72838_d((Entity)entity);
                    }
                }
                return !world.field_72995_K;
            }
            if (!world.field_72995_K) {
                if (side == 0 || side == 1) {
                    if (wrenchTile instanceof IEnergySource && wrenchTile instanceof IEnergySink) {
                        wrenchTile.setFacing((short)side);
                    }
                } else {
                    wrenchTile.setFacing((short)side);
                }
            }
            return !world.field_72995_K;
        }
        if (tile instanceof IReconfigurableFacing) {
            if (!world.field_72995_K && !player.func_70093_af()) {
                return ((IReconfigurableFacing)tile).rotateBlock();
            }
            return false;
        }
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

