/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlinkDriveModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_BLINK_DRIVE = "Blink Drive";
    public static final String BLINK_DRIVE_ENERGY_CONSUMPTION = "Blink Drive Energy Consuption";
    public static final String BLINK_DRIVE_RANGE = "Blink Drive Range";

    public BlinkDriveModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(BLINK_DRIVE_ENERGY_CONSUMPTION, 1000.0, "J");
        this.addBaseProperty(BLINK_DRIVE_RANGE, 5.0, "m");
        this.addTradeoffProperty("Range", BLINK_DRIVE_ENERGY_CONSUMPTION, 3000.0);
        this.addTradeoffProperty("Range", BLINK_DRIVE_RANGE, 59.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.fieldEmitter, 2));
    }

    @Override
    public String getTextureFile() {
        return "alien";
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_BLINK_DRIVE;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)"module.blinkDrive.name");
    }

    @Override
    public String getDescription() {
        return "Get from point A to point C via point B, where point B is a fold in space & time.";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack itemStack) {
        double range = ModuleManager.computeModularProperty(itemStack, BLINK_DRIVE_RANGE);
        double energyConsumption = ModuleManager.computeModularProperty(itemStack, BLINK_DRIVE_ENERGY_CONSUMPTION);
        if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
            MusePlayerUtils.resetFloatKickTicks(player);
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            world.func_72956_a((Entity)player, "mob.endermen.portal", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            MovingObjectPosition hitMOP = MusePlayerUtils.doCustomRayTrace(player.field_70170_p, player, true, range);
            MusePlayerUtils.teleportEntity(player, hitMOP);
            world.func_72956_a((Entity)player, "mob.endermen.portal", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
    }

    @Override
    public void onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

