/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkItemEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.BlockTileEntity;
import ic2.core.item.IHandHeldInventory;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    private ByteArrayOutputStream largePacketBuffer;

    @Override
    @Deprecated
    public void requestInitialData(INetworkDataProvider dataProvider) {
    }

    @Override
    public void initiateClientItemEvent(ItemStack itemStack, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(1);
            os.writeInt(itemStack.field_77993_c);
            os.writeInt(itemStack.func_77960_j());
            os.writeInt(event);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initiateKeyUpdate(int keyState) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(2);
            os.writeInt(keyState);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initiateClientTileEntityEvent(TileEntity te, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(3);
            os.writeInt(te.field_70331_k.field_73011_w.field_76574_g);
            os.writeInt(te.field_70329_l);
            os.writeInt(te.field_70330_m);
            os.writeInt(te.field_70327_n);
            os.writeInt(event);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendLoginData() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            buffer.write(4);
            GZIPOutputStream gzip = new GZIPOutputStream(buffer);
            DataOutputStream os = new DataOutputStream(gzip);
            os.writeInt(1);
            os.writeByte(IC2.enableQuantumSpeedOnSprint ? 1 : 0);
            ByteArrayOutputStream buffer2 = new ByteArrayOutputStream();
            IC2.runtimeIdProperties.store(buffer2, "");
            os.writeInt(buffer2.size());
            buffer2.writeTo(os);
            os.close();
            gzip.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onPacketData(INetworkManager network, Packet250CustomPayload packet, Player iplayer) {
        block34: {
            if (packet.field_73629_c.length == 0) {
                return;
            }
            if (packet.field_73629_c[0] >= 10) {
                super.onPacketData(network, packet, iplayer);
            }
            ByteArrayInputStream isRaw = new ByteArrayInputStream(packet.field_73629_c);
            DataInputStream is = new DataInputStream(isRaw);
            try {
                block1 : switch (is.read()) {
                    case 0: {
                        int len;
                        int state = is.read();
                        if ((state & 1) != 0) {
                            this.largePacketBuffer = new ByteArrayOutputStream(16384);
                        }
                        byte[] buffer = new byte[4096];
                        while ((len = is.read(buffer)) != -1) {
                            this.largePacketBuffer.write(buffer, 0, len);
                        }
                        if ((state & 2) == 0) break;
                        ByteArrayInputStream inflateInput = new ByteArrayInputStream(this.largePacketBuffer.toByteArray());
                        InflaterInputStream inflate = new InflaterInputStream(inflateInput);
                        ByteArrayOutputStream inflateBuffer = new ByteArrayOutputStream(16384);
                        while ((len = inflate.read(buffer)) != -1) {
                            inflateBuffer.write(buffer, 0, len);
                        }
                        inflate.close();
                        byte[] data = inflateBuffer.toByteArray();
                        switch (state >> 2) {
                            case 0: {
                                this.processInitPacket(data);
                                break;
                            }
                            case 1: {
                                this.processChatPacket(data);
                                break;
                            }
                            case 2: {
                                this.processConsolePacket(data);
                            }
                        }
                        this.largePacketBuffer = null;
                        break;
                    }
                    case 1: {
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        int event = is.readInt();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        TileEntity te = world.func_72796_p(x, y, z);
                        if (!(te instanceof INetworkTileEntityEventListener)) break;
                        ((INetworkTileEntityEventListener)te).onNetworkEvent(event);
                        break;
                    }
                    case 2: {
                        int length = is.readByte();
                        char[] usernameRaw = new char[length];
                        for (int i = 0; i < length; ++i) {
                            usernameRaw[i] = is.readChar();
                        }
                        String username = new String(usernameRaw);
                        int itemId = is.readInt();
                        int itemDamage = is.readInt();
                        int event = is.readInt();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        for (Object obj : world.field_73010_i) {
                            EntityPlayer entityPlayer = (EntityPlayer)obj;
                            if (!entityPlayer.field_71092_bJ.equals(username)) continue;
                            Item item = Item.field_77698_e[itemId];
                            if (item instanceof INetworkItemEventListener) {
                                ((INetworkItemEventListener)item).onNetworkEvent(itemDamage, entityPlayer, event);
                                break block1;
                            }
                            break block34;
                        }
                        break;
                    }
                    case 3: {
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        short id = is.readShort();
                        byte meta = is.readByte();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        world.func_72832_d(x, y, z, (int)id, (int)meta, 3);
                        break;
                    }
                    case 4: {
                        EntityPlayer entityPlayer = IC2.platform.getPlayerInstance();
                        boolean isAdmin = is.readByte() != 0;
                        switch (is.readByte()) {
                            case 0: {
                                int dimensionId = is.readInt();
                                int x = is.readInt();
                                int y = is.readInt();
                                int z = is.readInt();
                                int windowId = is.readInt();
                                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                                if (world.field_73011_w.field_76574_g != dimensionId) {
                                    return;
                                }
                                TileEntity te = world.func_72796_p(x, y, z);
                                if (te instanceof IHasGui) {
                                    IC2.platform.launchGuiClient(entityPlayer, (IHasGui)te, isAdmin);
                                }
                                entityPlayer.field_71070_bA.field_75152_c = windowId;
                                break block1;
                            }
                            case 1: {
                                int currentItemPosition = is.readInt();
                                int windowId = is.readInt();
                                if (currentItemPosition != entityPlayer.field_71071_by.field_70461_c) {
                                    return;
                                }
                                ItemStack currentItem = entityPlayer.field_71071_by.func_70448_g();
                                if (currentItem != null && currentItem.func_77973_b() instanceof IHandHeldInventory) {
                                    IC2.platform.launchGuiClient(entityPlayer, ((IHandHeldInventory)currentItem.func_77973_b()).getInventory(entityPlayer, currentItem), isAdmin);
                                }
                                entityPlayer.field_71070_bA.field_75152_c = windowId;
                                break block1;
                            }
                        }
                        break;
                    }
                    case 5: {
                        int dimensionId = is.readInt();
                        double x = is.readDouble();
                        double y = is.readDouble();
                        double z = is.readDouble();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        world.func_72908_a(x, y, z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                        world.func_72869_a("hugeexplosion", x, y, z, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void announceBlockUpdate(World world, int x, int y, int z) {
        if (IC2.platform.isSimulating()) {
            super.announceBlockUpdate(world, x, y, z);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processInitPacket(byte[] data) throws IOException {
        buffer = new ByteArrayInputStream(data);
        is = new DataInputStream(buffer);
        dimensionId = is.readInt();
        world = Minecraft.func_71410_x().field_71441_e;
        if (world.field_73011_w.field_76574_g != dimensionId) {
            return;
        }
        block4: while (true) {
            try {
                x = is.readInt();
            }
            catch (EOFException e) {
                break;
            }
            y = is.readInt();
            z = is.readInt();
            fieldData = new byte[is.readInt()];
            is.readFully(fieldData);
            fieldDataBuffer = new ByteArrayInputStream(fieldData);
            fieldDataStream = new DataInputStream(fieldDataBuffer);
            fieldValues = new HashMap<String, Object>();
            while (true) {
                try {
                    fieldName = fieldDataStream.readUTF();
                }
                catch (EOFException e) {
                    break;
                }
                value = DataEncoder.decode(fieldDataStream);
                fieldValues.put(fieldName, value);
            }
            block = Block.field_71973_m[world.func_72798_a(x, y, z)];
            if (block == null) continue;
            if (block instanceof BlockTileEntity) {
                tileEntityId = (Integer)fieldValues.get("tileEntityId");
                te = ((BlockTileEntity)block).getTileEntity(tileEntityId);
                if (te != null) {
                    world.func_72837_a(x, y, z, te);
                }
            } else {
                te = world.func_72796_p(x, y, z);
            }
            if (te == null) continue;
            i$ = fieldValues.entrySet().iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block4;
                entry = i$.next();
                this.setField(te, (String)entry.getKey(), entry.getValue());
                if (!(te instanceof INetworkUpdateListener)) continue;
                ((INetworkUpdateListener)te).onNetworkUpdate((String)entry.getKey());
            }
            break;
        }
        is.close();
    }

    private void setField(Object object, String fieldName, Object value) {
        Class<?> fieldDeclaringClass = object.getClass();
        Field field = null;
        do {
            try {
                field = fieldDeclaringClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
            }
        } while (field == null && fieldDeclaringClass != null);
        if (field == null) {
            IC2.log.warning("Can't find field " + fieldName + " in " + object);
        } else {
            field.setAccessible(true);
            if (field.getType().isEnum()) {
                value = field.getType().getEnumConstants()[(Integer)value];
            }
            try {
                field.set(object, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processChatPacket(byte[] data) {
        String messages;
        try {
            messages = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        for (String line : messages.split("[\\r\\n]+")) {
            IC2.platform.messagePlayer(null, line, new Object[0]);
        }
    }

    private void processConsolePacket(byte[] data) {
        String messages;
        try {
            messages = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        PrintStream console = new PrintStream(new FileOutputStream(FileDescriptor.out));
        for (String line : messages.split("[\\r\\n]+")) {
            console.println(line);
        }
        console.flush();
    }
}

