/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.IBoxable;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2FluidContainer;
import ic2.core.item.armor.ItemArmorCFPack;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ItemSprayer
extends ItemIC2FluidContainer
implements IBoxable {
    public ItemSprayer(Configuration config, InternalName internalName) {
        super(config, internalName, 8000);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(player)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
            int mode = nbtData.func_74762_e("mode");
            mode = mode == 0 ? 1 : 0;
            nbtData.func_74768_a("mode", mode);
            String sMode = mode == 0 ? "ic2.tooltip.mode.normal" : "ic2.tooltip.mode.single";
            IC2.platform.messagePlayer(player, "ic2.tooltip.mode", sMode);
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        Target target;
        ItemStack pack;
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            return false;
        }
        if (!IC2.platform.isSimulating()) {
            return true;
        }
        int maxFoamBlocks = 0;
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.amount > 0) {
            maxFoamBlocks += fluid.amount / this.getFluidPerFoam();
        }
        if ((pack = player.field_71071_by.field_70460_b[2]) != null && pack.field_77993_c == Ic2Items.cfPack.field_77993_c) {
            fluid = ((ItemArmorCFPack)pack.func_77973_b()).getFluid(pack);
            if (fluid != null && fluid.amount > 0) {
                maxFoamBlocks += fluid.amount / this.getFluidPerFoam();
            } else {
                pack = null;
            }
        } else {
            pack = null;
        }
        if (maxFoamBlocks == 0) {
            return false;
        }
        maxFoamBlocks = Math.min(maxFoamBlocks, this.getMaxFoamBlocks(stack));
        ChunkPosition pos = new ChunkPosition(x, y, z);
        if (this.canPlaceFoam(world, pos, Target.Scaffold)) {
            target = Target.Scaffold;
        } else if (this.canPlaceFoam(world, pos, Target.Cable)) {
            target = Target.Cable;
        } else {
            switch (side) {
                case 0: {
                    --y;
                    break;
                }
                case 1: {
                    ++y;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            target = Target.Any;
        }
        int amount = this.sprayFoam(world, x, y, z, ItemSprayer.calculateDirectionsFromPlayer(player), target, maxFoamBlocks);
        if ((amount *= this.getFluidPerFoam()) > 0) {
            if (pack != null) {
                fluid = ((ItemArmorCFPack)pack.func_77973_b()).drain(pack, amount, true);
                amount -= fluid.amount;
            }
            if (amount > 0) {
                this.drain(stack, amount, true);
            }
            return true;
        }
        return false;
    }

    public static boolean[] calculateDirectionsFromPlayer(EntityPlayer player) {
        float yaw = player.field_70177_z % 360.0f;
        float pitch = player.field_70125_A;
        boolean[] r = new boolean[]{true, true, true, true, true, true};
        if (pitch >= -65.0f && pitch <= 65.0f) {
            if (yaw >= 300.0f && yaw <= 360.0f || yaw >= 0.0f && yaw <= 60.0f) {
                r[2] = false;
            }
            if (yaw >= 30.0f && yaw <= 150.0f) {
                r[5] = false;
            }
            if (yaw >= 120.0f && yaw <= 240.0f) {
                r[3] = false;
            }
            if (yaw >= 210.0f && yaw <= 330.0f) {
                r[4] = false;
            }
        }
        if (pitch <= -40.0f) {
            r[0] = false;
        }
        if (pitch >= 40.0f) {
            r[1] = false;
        }
        return r;
    }

    public int sprayFoam(World world, int x, int y, int z, boolean[] directions, Target target, int maxFoamBlocks) {
        ChunkPosition startPos = new ChunkPosition(x, y, z);
        if (!this.canPlaceFoam(world, startPos, target)) {
            return 0;
        }
        ArrayList<ChunkPosition> check = new ArrayList<ChunkPosition>();
        ArrayList<ChunkPosition> place = new ArrayList<ChunkPosition>();
        int foamBlocks = 0;
        check.add(new ChunkPosition(x, y, z));
        for (int i = 0; i < check.size() && foamBlocks < maxFoamBlocks; ++i) {
            ChunkPosition set = (ChunkPosition)check.get(i);
            if (!this.canPlaceFoam(world, set, target)) continue;
            this.considerAddingCoord(set, place);
            this.addAdjacentSpacesOnList(set.field_76930_a, set.field_76928_b, set.field_76929_c, check, directions, target != Target.Any);
            ++foamBlocks;
        }
        for (ChunkPosition pos : place) {
            int targetBlockId = world.func_72798_a(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c);
            if (targetBlockId == Ic2Items.scaffold.field_77993_c) {
                Block.field_71973_m[Ic2Items.scaffold.field_77993_c].func_71897_c(world, pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, world.func_72805_g(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c), 0);
                world.func_72832_d(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, Ic2Items.constructionFoam.field_77993_c, 0, 3);
                continue;
            }
            if (targetBlockId == Ic2Items.ironScaffold.field_77993_c) {
                world.func_72832_d(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, Ic2Items.constructionreinforcedFoam.field_77993_c, 0, 3);
                continue;
            }
            if (targetBlockId == Ic2Items.copperCableBlock.field_77993_c) {
                TileEntity te = world.func_72796_p(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c);
                if (!(te instanceof TileEntityCable)) continue;
                ((TileEntityCable)te).changeFoam((byte)1);
                continue;
            }
            world.func_72832_d(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, Ic2Items.constructionFoam.field_77993_c, 0, 3);
        }
        return foamBlocks;
    }

    public void addAdjacentSpacesOnList(int x, int y, int z, ArrayList<ChunkPosition> foam, boolean[] directions, boolean ignoreDirections) {
        int[] order = this.generateRngSpread(IC2.random);
        block8: for (int i = 0; i < order.length; ++i) {
            if (!ignoreDirections && !directions[order[i]]) continue;
            switch (order[i]) {
                case 0: {
                    this.considerAddingCoord(new ChunkPosition(x, y - 1, z), foam);
                    continue block8;
                }
                case 1: {
                    this.considerAddingCoord(new ChunkPosition(x, y + 1, z), foam);
                    continue block8;
                }
                case 2: {
                    this.considerAddingCoord(new ChunkPosition(x, y, z - 1), foam);
                    continue block8;
                }
                case 3: {
                    this.considerAddingCoord(new ChunkPosition(x, y, z + 1), foam);
                    continue block8;
                }
                case 4: {
                    this.considerAddingCoord(new ChunkPosition(x - 1, y, z), foam);
                    continue block8;
                }
                case 5: {
                    this.considerAddingCoord(new ChunkPosition(x + 1, y, z), foam);
                }
            }
        }
    }

    public void considerAddingCoord(ChunkPosition coord, ArrayList<ChunkPosition> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).field_76930_a != coord.field_76930_a || list.get((int)i).field_76928_b != coord.field_76928_b || list.get((int)i).field_76929_c != coord.field_76929_c) continue;
            return;
        }
        list.add(coord);
    }

    public int[] generateRngSpread(Random random) {
        int[] re = new int[]{0, 1, 2, 3, 4, 5};
        for (int i = 0; i < 16; ++i) {
            int first = random.nextInt(6);
            int second = random.nextInt(6);
            int save = re[first];
            re[first] = re[second];
            re[second] = save;
        }
        return re;
    }

    protected int getMaxFoamBlocks(ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        if (nbtData.func_74762_e("mode") == 0) {
            return 10;
        }
        return 1;
    }

    protected int getFluidPerFoam() {
        return 100;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return fluid.getID() == IC2.fluidCf.getID();
    }

    private boolean canPlaceFoam(World world, ChunkPosition pos, Target target) {
        int blockId = world.func_72798_a(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c);
        switch (target) {
            case Any: {
                return Block.field_71973_m[Ic2Items.constructionFoam.field_77993_c].func_71930_b(world, pos.field_76930_a, pos.field_76928_b, pos.field_76929_c);
            }
            case Scaffold: {
                return blockId == Ic2Items.scaffold.field_77993_c || blockId == Ic2Items.ironScaffold.field_77993_c;
            }
            case Cable: {
                if (blockId != Ic2Items.copperCableBlock.field_77993_c) {
                    return false;
                }
                TileEntity te = world.func_72796_p(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c);
                if (!(te instanceof TileEntityCable)) break;
                return !((TileEntityCable)te).isFoamed();
            }
            default: {
                assert (false);
                break;
            }
        }
        return false;
    }

    static enum Target {
        Any,
        Scaffold,
        Cable;

    }
}

