/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemNanoSaber
extends ItemElectricTool {
    public static int ticker = 0;
    @SideOnly(value=Side.CLIENT)
    private Icon[] textures;
    private int soundTicker = 0;
    private final Random shinyrand = new Random();

    public ItemNanoSaber(Configuration config, InternalName internalName) {
        super(config, internalName, EnumToolMaterial.IRON, 10);
        this.maxCharge = 40000;
        this.transferLimit = 128;
        this.tier = 3;
        this.mineableBlocks.add(Block.field_71955_W);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.textures = new Icon[3];
        this.textures[0] = iconRegister.func_94245_a("ic2:" + this.func_77658_a() + "." + InternalName.off.name());
        this.textures[1] = iconRegister.func_94245_a("ic2:" + this.func_77658_a() + "." + InternalName.active.name());
        this.textures[2] = iconRegister.func_94245_a("ic2:" + this.func_77658_a() + "." + InternalName.activeAlternate.name());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack itemStack, int pass) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            if (this.shinyrand.nextBoolean()) {
                return this.textures[1];
            }
            return this.textures[2];
        }
        return this.textures[0];
    }

    @Override
    public float getStrVsBlock(ItemStack itemStack, Block block, int meta) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            ++this.soundTicker;
            if (this.soundTicker % 4 == 0) {
                IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
            }
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase source) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (!nbtData.func_74767_n("active")) {
            return true;
        }
        if (IC2.platform.isSimulating() && (!(source instanceof EntityPlayer) || MinecraftServer.func_71276_C().func_71219_W() || !(target instanceof EntityPlayer))) {
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = target.func_71124_b(i + 1);
                if (armor == null) continue;
                int amount = 0;
                if (armor.func_77973_b() instanceof ItemArmorNanoSuit) {
                    amount = 4800;
                } else if (armor.func_77973_b() instanceof ItemArmorQuantumSuit) {
                    amount = 30000;
                }
                if (amount <= 0) continue;
                ElectricItem.manager.discharge(armor, amount, this.tier, true, false);
                if (!ElectricItem.manager.canUse(armor, 1)) {
                    target.func_70062_b(i + 1, null);
                }
                ItemNanoSaber.drainSaber(itemStack, 2, source);
            }
            ItemNanoSaber.drainSaber(itemStack, 5, source);
        }
        if (IC2.platform.isRendering()) {
            IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
        }
        return true;
    }

    public String getRandomSwingSound() {
        switch (IC2.random.nextInt(3)) {
            default: {
                return "nanosabreSwing";
            }
            case 1: {
                return "nanosabreSwingOne";
            }
            case 2: 
        }
        return "nanosabreSwingTwo";
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int i, int j, int k, EntityPlayer player) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            ItemNanoSaber.drainSaber(itemStack, 10, (EntityLivingBase)player);
        }
        return false;
    }

    public float getDamageVsEntity(Entity entity, ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            return 20.0f;
        }
        return 4.0f;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return block.field_71990_ca == Block.field_71955_W.field_71990_ca;
    }

    public static void drainSaber(ItemStack itemStack, int damage, EntityLivingBase entity) {
        if (!ElectricItem.manager.use(itemStack, damage * 8, entity)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
            nbtData.func_74757_a("active", false);
            ItemNanoSaber.updateAttributes(nbtData);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemStack;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            nbtData.func_74757_a("active", false);
            ItemNanoSaber.updateAttributes(nbtData);
        } else if (ElectricItem.manager.canUse(itemStack, 16)) {
            nbtData.func_74757_a("active", true);
            ItemNanoSaber.updateAttributes(nbtData);
            world.func_72956_a((Entity)entityplayer, "nanosabrePower", 1.0f, 1.0f);
        }
        return itemStack;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean par5) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (!nbtData.func_74767_n("active")) {
            return;
        }
        if (ticker % 16 == 0 && entity instanceof EntityPlayerMP) {
            if (slot < 9) {
                ItemNanoSaber.drainSaber(itemStack, 8, (EntityLivingBase)((EntityPlayer)entity));
            } else if (ticker % 64 == 0) {
                ItemNanoSaber.drainSaber(itemStack, 2, (EntityLivingBase)((EntityPlayer)entity));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    private static void updateAttributes(NBTTagCompound nbtData) {
        boolean active = nbtData.func_74767_n("active");
        int damage = active ? 20 : 4;
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
        entry.func_74772_a("UUIDMost", field_111210_e.getMostSignificantBits());
        entry.func_74772_a("UUIDLeast", field_111210_e.getLeastSignificantBits());
        entry.func_74778_a("Name", "Tool modifier");
        entry.func_74780_a("Amount", (double)damage);
        entry.func_74768_a("Operation", 0);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)entry);
        nbtData.func_74782_a("AttributeModifiers", (NBTBase)list);
    }
}

