/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.tool.ItemElectricTool;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemDrill
extends ItemElectricTool {
    protected int soundTicker = 0;

    public ItemDrill(Configuration config, InternalName internalName, int operationEnergyCost) {
        super(config, internalName, EnumToolMaterial.IRON, operationEnergyCost);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !torchStack.func_77977_a().toLowerCase().contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
            int oldMeta = torchStack.func_77960_j();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.getRefPick().func_77641_a(block) || Item.field_77695_f.func_77641_a(block) || super.canHarvestBlock(block, stack);
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            return 1.0f;
        }
        ++this.soundTicker;
        if (this.soundTicker % 4 == 0) {
            IC2.platform.playSoundSp(this.getRandomDrillSound(), 1.0f, 1.0f);
        }
        if (this.getRefPick().getStrVsBlock(stack, block, meta) > 1.0f || Item.field_77695_f.getStrVsBlock(stack, block, meta) > 1.0f) {
            return this.field_77864_a;
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    public String getRandomDrillSound() {
        switch (IC2.random.nextInt(4)) {
            default: {
                return "drill";
            }
            case 1: {
                return "drillOne";
            }
            case 2: {
                return "drillTwo";
            }
            case 3: 
        }
        return "drillThree";
    }

    private Item getRefPick() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return Item.field_77674_B;
            }
            case GOLD: {
                return Item.field_77681_I;
            }
            case IRON: {
                return Item.field_77696_g;
            }
            case STONE: {
                return Item.field_77720_x;
            }
            case WOOD: {
                return Item.field_77713_t;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }
}

