/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.init.InternalName;
import ic2.core.item.ItemTinCan;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorQuantumSuit
extends ItemArmorElectric {
    private static final Map<Integer, Integer> potionRemovalCost = new HashMap<Integer, Integer>();
    public static Map<EntityPlayer, Integer> speedTickerMap = new HashMap<EntityPlayer, Integer>();
    public static Map<EntityPlayer, Boolean> onGroundMap = new HashMap<EntityPlayer, Boolean>();
    public static Map<EntityPlayer, Boolean> enableQuantumSpeedOnSprintMap = new HashMap<EntityPlayer, Boolean>();
    private static final int extraFallDistanceProtection = 7;
    private float jumpCharge;
    public static AudioSource audioSource;
    private static boolean lastJetpackUsed;

    public ItemArmorQuantumSuit(Configuration config, InternalName internalName, int armorType) {
        super(config, internalName, InternalName.quantum, armorType, 10000000, 1000, 4);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        potionRemovalCost.put(Potion.field_76436_u.field_76415_H, 10000);
        potionRemovalCost.put(IC2Potion.radiation.field_76415_H, 10000);
        potionRemovalCost.put(Potion.field_82731_v.field_76415_H, 25000);
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.manager.getCharge(armor) / energyPerDamage : 0;
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(entity, armor, source, damage, slot);
    }

    @ForgeSubscribe
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.entity instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)event.entity).func_71124_b(1)) != null && armor.field_77993_c == this.field_77779_bT) {
            int fallDamage = Math.max((int)event.distance - 3 - 7, 0);
            int energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == 1) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 4500;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        switch (this.field_77881_a) {
            case 0: {
                IC2.platform.profilerStartSection("QuantumHelmet");
                int air = player.func_70086_ai();
                if (ElectricItem.manager.canUse(itemStack, 1000) && air < 100) {
                    player.func_70050_g(air + 200);
                    ElectricItem.manager.use(itemStack, 1000, null);
                    ret = true;
                } else if (air <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if (ElectricItem.manager.canUse(itemStack, 1000) && player.func_71024_bL().func_75121_c()) {
                    int slot = -1;
                    for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].field_77993_c != Ic2Items.filledTinCan.field_77993_c) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemTinCan can = (ItemTinCan)player.field_71071_by.field_70462_a[slot].func_77973_b();
                        player.func_71024_bL().func_75122_a(can.func_77847_f(), can.func_77846_g());
                        can.func_77849_c(player.field_71071_by.field_70462_a[slot], player.field_70170_p, player);
                        can.onEaten(player);
                        if (--player.field_71071_by.field_70462_a[slot].field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[slot] = null;
                        }
                        ElectricItem.manager.use(itemStack, 1000, null);
                        ret = true;
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                    int id = effect.func_76456_a();
                    Integer cost = potionRemovalCost.get(id);
                    if (cost == null || !ElectricItem.manager.canUse(itemStack, cost = Integer.valueOf(cost * (effect.func_76458_c() + 1)))) continue;
                    ElectricItem.manager.use(itemStack, cost, null);
                    IC2.platform.removePotion((EntityLivingBase)player, id);
                }
                boolean Nightvision = nbtData.func_74767_n("Nightvision");
                short hubmode = nbtData.func_74765_d("HudMode");
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = Nightvision = !Nightvision;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("Nightvision", Nightvision);
                        if (Nightvision) {
                            IC2.platform.messagePlayer(player, "Nightvision enabled.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "Nightvision disabled.", new Object[0]);
                        }
                    }
                }
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isHudModeKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    hubmode = hubmode == 2 ? (short)0 : (short)(hubmode + 1);
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74777_a("HudMode", hubmode);
                        switch (hubmode) {
                            case 0: {
                                IC2.platform.messagePlayer(player, "HUD disabled.", new Object[0]);
                                break;
                            }
                            case 1: {
                                IC2.platform.messagePlayer(player, "HUD (basic) enabled.", new Object[0]);
                                break;
                            }
                            case 2: {
                                IC2.platform.messagePlayer(player, "HUD (extended) enabled", new Object[0]);
                            }
                        }
                    }
                }
                if (IC2.platform.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (Nightvision && ElectricItem.manager.use(itemStack, 1, (EntityLivingBase)player)) {
                    int x = MathHelper.func_76128_c((double)player.field_70165_t);
                    int z = MathHelper.func_76128_c((double)player.field_70161_v);
                    int y = MathHelper.func_76128_c((double)player.field_70163_u);
                    int skylight = player.field_70170_p.func_72957_l(x, y, z);
                    if (skylight > 8) {
                        IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76439_r.field_76415_H);
                        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0, true));
                    } else {
                        IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76440_q.field_76415_H);
                        player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
                    }
                    ret = true;
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 1: {
                IC2.platform.profilerStartSection("QuantumBodyarmor");
                boolean jetpack = nbtData.func_74767_n("jetpack");
                boolean hoverMode = nbtData.func_74767_n("hoverMode");
                boolean jetpackUsed = false;
                if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = hoverMode = !hoverMode;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("hoverMode", hoverMode);
                        if (hoverMode) {
                            IC2.platform.messagePlayer(player, "Quantum Hover Mode enabled.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "Quantum Hover Mode disabled.", new Object[0]);
                        }
                    }
                }
                if (IC2.keyboard.isBoostKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = jetpack = !jetpack;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("jetpack", jetpack);
                        if (jetpack) {
                            IC2.platform.messagePlayer(player, "Quantum Jetpack enabled.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "Quantum Jetpack disabled.", new Object[0]);
                        }
                    }
                }
                if (jetpack && (IC2.keyboard.isJumpKeyDown(player) || hoverMode && player.field_70181_x < (double)-0.03f)) {
                    jetpackUsed = this.useJetpack(player, hoverMode);
                }
                if (IC2.platform.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
                    if (lastJetpackUsed != jetpackUsed) {
                        if (jetpackUsed) {
                            if (audioSource == null) {
                                audioSource = IC2.audioManager.createSource(player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                            }
                            if (audioSource != null) {
                                audioSource.play();
                            }
                        } else if (audioSource != null) {
                            audioSource.remove();
                            audioSource = null;
                        }
                        lastJetpackUsed = jetpackUsed;
                    }
                    if (audioSource != null) {
                        audioSource.updatePosition();
                    }
                }
                ret = jetpackUsed;
                player.func_70066_B();
                IC2.platform.profilerEndSection();
                break;
            }
            case 2: {
                IC2.platform.profilerStartSection("QuantumLeggings");
                boolean enableQuantumSpeedOnSprint = true;
                if (IC2.platform.isRendering()) {
                    enableQuantumSpeedOnSprint = IC2.enableQuantumSpeedOnSprint;
                } else if (enableQuantumSpeedOnSprintMap.containsKey(player)) {
                    enableQuantumSpeedOnSprint = enableQuantumSpeedOnSprintMap.get(player);
                }
                if (ElectricItem.manager.canUse(itemStack, 1000) && (player.field_70122_E || player.func_70090_H()) && IC2.keyboard.isForwardKeyDown(player) && (enableQuantumSpeedOnSprint && player.func_70051_ag() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player))) {
                    int speedTicker;
                    int n = speedTicker = speedTickerMap.containsKey(player) ? speedTickerMap.get(player) : 0;
                    if (++speedTicker >= 10) {
                        speedTicker = 0;
                        ElectricItem.manager.use(itemStack, 1000, null);
                        ret = true;
                    }
                    speedTickerMap.put(player, speedTicker);
                    float speed = 0.22f;
                    if (player.func_70090_H()) {
                        speed = 0.1f;
                        if (IC2.keyboard.isJumpKeyDown(player)) {
                            player.field_70181_x += (double)0.1f;
                        }
                    }
                    if (speed > 0.0f) {
                        player.func_70060_a(0.0f, 1.0f, speed);
                    }
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 3: {
                IC2.platform.profilerStartSection("QuantumBoots");
                if (IC2.platform.isSimulating()) {
                    boolean wasOnGround;
                    boolean bl = wasOnGround = onGroundMap.containsKey(player) ? onGroundMap.get(player) : true;
                    if (wasOnGround && !player.field_70122_E && IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        ElectricItem.manager.use(itemStack, 4000, null);
                        ret = true;
                    }
                    onGroundMap.put(player, player.field_70122_E);
                } else {
                    if (ElectricItem.manager.canUse(itemStack, 4000) && player.field_70122_E) {
                        this.jumpCharge = 1.0f;
                    }
                    if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                            if (this.jumpCharge == 1.0f) {
                                player.field_70159_w *= 3.5;
                                player.field_70179_y *= 3.5;
                            }
                            player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                            this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                        } else if (this.jumpCharge < 1.0f) {
                            this.jumpCharge = 0.0f;
                        }
                    }
                }
                IC2.platform.profilerEndSection();
            }
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        int worldHeight;
        double y;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (ElectricItem.manager.getCharge(jetpack) == 0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.05f;
        if ((float)ElectricItem.manager.getCharge(jetpack) / (float)this.getMaxCharge(jetpack) <= dropPercentage) {
            power *= (float)ElectricItem.manager.getCharge(jetpack) / ((float)this.getMaxCharge(jetpack) * dropPercentage);
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 3.5f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        if ((y = player.field_70163_u) > (double)((worldHeight = IC2.getWorldHeight(player.field_70170_p)) - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = -0.025f;
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.1f;
            }
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = 8;
        if (hoverMode) {
            consume = 10;
        }
        ElectricItem.manager.discharge(jetpack, consume, Integer.MAX_VALUE, true, false);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public static void removePlayerReferences(EntityPlayer player) {
        speedTickerMap.remove(player);
        onGroundMap.remove(player);
        enableQuantumSpeedOnSprintMap.remove(player);
    }

    static {
        lastJetpackUsed = false;
    }
}

