/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.ContainerBase;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankStandardMaschine;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.ContainerOreWashing;
import ic2.core.block.machine.gui.GuiOreWashing;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityOreWashing
extends TileEntityLiquidTankStandardMaschine {
    public final InvSlotConsumableLiquid fluidSlot;
    public final InvSlotOutput cellSlot;
    public static List<Map.Entry<ItemStack, ItemStack>> recipes = new Vector<Map.Entry<ItemStack, ItemStack>>();

    public TileEntityOreWashing() {
        super(16, 500, 3, 8);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 0, 1, Recipes.oreWashing);
        this.fluidSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fluid", 0, 1, FluidRegistry.WATER);
        this.cellSlot = new InvSlotOutput(this, "cell", 0, 1);
    }

    public static void init() {
        Recipes.oreWashing = new BasicMachineRecipeManager();
        TileEntityOreWashing.addRecipe(Ic2Items.crushedCopperOre, 1, 1000, Ic2Items.purifiedCrushedCopperOre, StackUtil.copyWithSize(Ic2Items.smallCopperDust, 2), Ic2Items.stoneDust);
        TileEntityOreWashing.addRecipe(Ic2Items.crushedTinOre, 1, 1000, Ic2Items.purifiedCrushedTinOre, StackUtil.copyWithSize(Ic2Items.smallTinDust, 2), Ic2Items.stoneDust);
        TileEntityOreWashing.addRecipe(Ic2Items.crushedIronOre, 1, 1000, Ic2Items.purifiedCrushedIronOre, StackUtil.copyWithSize(Ic2Items.smallIronDust, 2), Ic2Items.stoneDust);
        TileEntityOreWashing.addRecipe(Ic2Items.crushedGoldOre, 1, 1000, Ic2Items.purifiedCrushedGoldOre, StackUtil.copyWithSize(Ic2Items.smallGoldDust, 2), Ic2Items.stoneDust);
        TileEntityOreWashing.addRecipe(Ic2Items.crushedLeadOre, 1, 1000, Ic2Items.purifiedCrushedLeadOre, StackUtil.copyWithSize(Ic2Items.smallSulfurDust, 3), Ic2Items.stoneDust);
        TileEntityOreWashing.addRecipe(Ic2Items.crushedSilverOre, 1, 1000, Ic2Items.purifiedCrushedSilverOre, StackUtil.copyWithSize(Ic2Items.smallSilverDust, 2), Ic2Items.stoneDust);
        TileEntityOreWashing.addRecipe(Ic2Items.crushedUraniumOre, 1, 1000, Ic2Items.purifiedCrushedUraniumOre, StackUtil.copyWithSize(Ic2Items.smallLeadDust, 2), Ic2Items.stoneDust);
    }

    public static void addRecipe(ItemStack input, int amount, int FluidAmount, ItemStack ... output) {
        TileEntityOreWashing.addRecipe(new RecipeInputItemStack(input, amount), FluidAmount, output);
    }

    public static void addRecipe(String input, int amount, int FluidAmount, ItemStack ... output) {
        TileEntityOreWashing.addRecipe(new RecipeInputOreDict(input, amount), FluidAmount, output);
    }

    public static void addRecipe(IRecipeInput input, int FluidAmount, ItemStack ... output) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("amount", FluidAmount);
        Recipes.oreWashing.addRecipe(input, metadata, output);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.needsFluid()) {
            this.gainFluid();
        }
    }

    @Override
    public void operateOnce(RecipeOutput output, List<ItemStack> processResult) {
        super.operateOnce(output, processResult);
        this.fluidTank.drain(output.metadata.func_74762_e("amount"), true);
    }

    @Override
    public RecipeOutput getOutput() {
        RecipeOutput ret = super.getOutput();
        if (ret != null && ret.metadata.func_74762_e("amount") > this.fluidTank.getFluidAmount()) {
            return null;
        }
        return ret;
    }

    public boolean gainFluid() {
        boolean ret = false;
        MutableObject output = new MutableObject();
        if (this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.cellSlot.canAdd((ItemStack)output.getValue()))) {
            ret = this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.cellSlot.add((ItemStack)output.getValue());
            }
        }
        return ret;
    }

    @Override
    public String func_70303_b() {
        return "OreWashing";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiOreWashing(new ContainerOreWashing(entityPlayer, this));
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerOreWashing(entityPlayer, this);
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return FluidRegistry.WATER.getID() == fluid.getID();
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }
}

