/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class InvSlotProcessableCanner
extends InvSlotProcessableGeneric {
    public final TileEntityCanner base;

    public InvSlotProcessableCanner(TileEntityCanner base, String name, int oldStartIndex, int count) {
        super((TileEntityInventory)base, name, oldStartIndex, count, null);
        this.base = base;
    }

    @Override
    public boolean accepts(ItemStack itemStack) {
        switch (this.base.getMode()) {
            case BottleSolid: 
            case EnrichLiquid: {
                return super.accepts(itemStack);
            }
            case BottleLiquid: 
            case EmptyLiquid: {
                return false;
            }
        }
        assert (false);
        return false;
    }

    @Override
    public void consume() {
        FluidStack fluid;
        super.consume();
        ItemStack containerStack = this.base.canInputSlot.get();
        if (containerStack != null && containerStack.field_77994_a <= 0) {
            this.base.canInputSlot.put(null);
        }
        if ((fluid = this.base.inputTank.getFluid()) != null && fluid.amount <= 0) {
            this.base.inputTank.setFluid(null);
        }
    }

    @Override
    protected RecipeOutput getOutputFor(ItemStack input, boolean adjustInput, boolean forAccept) {
        return this.getOutput(this.base.canInputSlot.get(), input, adjustInput, forAccept);
    }

    @Override
    protected boolean allowEmptyInput() {
        return true;
    }

    protected RecipeOutput getOutput(ItemStack container, ItemStack fill, boolean adjustInput, boolean forAccept) {
        switch (this.base.getMode()) {
            case BottleSolid: {
                return Recipes.cannerBottle.getOutputFor(container, fill, adjustInput, forAccept);
            }
            case BottleLiquid: {
                return this.fillContainer(adjustInput);
            }
            case EmptyLiquid: {
                return this.drainContainer(adjustInput);
            }
            case EnrichLiquid: {
                return Recipes.cannerEnrich.getOutputFor(this.base.inputTank.getFluid(), fill, adjustInput, forAccept);
            }
        }
        assert (false);
        return null;
    }

    private RecipeOutput fillContainer(boolean adjustInput) {
        RecipeOutput ret = null;
        MutableObject output = new MutableObject();
        if (this.base.canInputSlot.transferFromTank((IFluidTank)this.base.inputTank, (MutableObject<ItemStack>)output, !adjustInput)) {
            ret = output.getValue() != null ? new RecipeOutput(null, (ItemStack)output.getValue()) : new RecipeOutput(null, new ItemStack[0]);
        }
        return ret;
    }

    private RecipeOutput drainContainer(boolean adjustInput) {
        int maxAmount = this.base.outputTank.getCapacity() - this.base.outputTank.getFluidAmount();
        if (maxAmount <= 0) {
            return null;
        }
        RecipeOutput ret = null;
        MutableObject output = new MutableObject();
        FluidStack fluid = this.base.canInputSlot.drain(null, maxAmount, (MutableObject<ItemStack>)output, !adjustInput);
        if (fluid != null) {
            ret = output.getValue() != null ? InvSlotProcessableCanner.createOutput(fluid, (ItemStack)output.getValue()) : InvSlotProcessableCanner.createOutput(fluid, new ItemStack[0]);
        }
        return ret;
    }

    public static RecipeOutput createOutput(FluidStack fluid, ItemStack ... items) {
        NBTTagCompound metadata = new NBTTagCompound();
        NBTTagCompound output = new NBTTagCompound();
        fluid.writeToNBT(output);
        metadata.func_74782_a("output", (NBTBase)output);
        return new RecipeOutput(metadata, items);
    }
}

