/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public abstract class InvSlotConsumable
extends InvSlot {
    private static final Random random = new Random();

    public InvSlotConsumable(TileEntityInventory base, String name, int oldStartIndex, int count) {
        super(base, name, oldStartIndex, InvSlot.Access.I, count, InvSlot.InvSide.TOP);
    }

    public InvSlotConsumable(TileEntityInventory base, String name, int oldStartIndex, InvSlot.Access access, int count, InvSlot.InvSide preferredSide) {
        super(base, name, oldStartIndex, access, count, preferredSide);
    }

    @Override
    public abstract boolean accepts(ItemStack var1);

    @Override
    public boolean canOutput() {
        return super.canOutput() || this.access != InvSlot.Access.NONE && this.get() != null && !this.accepts(this.get());
    }

    public ItemStack consume(int amount) {
        return this.consume(amount, false, false);
    }

    public ItemStack consume(int amount, boolean simulate, boolean consumeContainers) {
        ItemStack ret = null;
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = this.get(i);
            if (itemStack == null || itemStack.field_77994_a < 1 || !this.accepts(itemStack) || ret != null && !StackUtil.isStackEqual(itemStack, ret) || itemStack.field_77994_a != 1 && !consumeContainers && itemStack.func_77973_b().func_77634_r()) continue;
            int currentAmount = Math.min(amount, itemStack.field_77994_a);
            amount -= currentAmount;
            if (!simulate) {
                if (itemStack.field_77994_a == currentAmount) {
                    if (!consumeContainers && itemStack.func_77973_b().func_77634_r()) {
                        this.put(i, itemStack.func_77973_b().getContainerItemStack(itemStack));
                    } else {
                        this.put(i, null);
                    }
                } else {
                    itemStack.field_77994_a -= currentAmount;
                }
            }
            if (ret == null) {
                ret = StackUtil.copyWithSize(itemStack, currentAmount);
            } else {
                ret.field_77994_a += currentAmount;
            }
            if (amount == 0) break;
        }
        return ret;
    }

    public ItemStack damage(int amount) {
        return this.damage(amount, null);
    }

    public ItemStack damage(int amount, EntityLivingBase src) {
        ItemStack ret = null;
        int damageApplied = 0;
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = this.get(i);
            if (itemStack == null || !this.accepts(itemStack) || !itemStack.func_77973_b().func_77645_m() || ret != null && (itemStack.field_77993_c != ret.field_77993_c || !ItemStack.func_77970_a((ItemStack)itemStack, ret))) continue;
            int currentAmount = Math.min(amount, itemStack.func_77958_k() - itemStack.func_77960_j());
            damageApplied += currentAmount;
            amount -= currentAmount;
            if (src != null) {
                itemStack.func_77972_a(currentAmount, src);
            } else {
                itemStack.func_96631_a(currentAmount, random);
            }
            if (itemStack.func_77960_j() >= itemStack.func_77958_k()) {
                --itemStack.field_77994_a;
                itemStack.func_77964_b(0);
            }
            if (itemStack.field_77994_a == 0) {
                this.put(i, null);
            } else {
                --i;
            }
            if (ret == null) {
                ret = itemStack.func_77946_l();
            }
            if (amount == 0) break;
        }
        ret.field_77994_a = damageApplied / ret.func_77958_k();
        ret.func_77964_b(damageApplied % ret.func_77958_k());
        return ret;
    }
}

