/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.block.BlockIC2Explosive;
import ic2.core.block.EntityIC2Explosive;
import ic2.core.block.EntityItnt;
import ic2.core.block.EntityNuke;
import ic2.core.block.machine.tileentity.TileEntityNuke;
import ic2.core.init.InternalName;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class BlockITNT
extends BlockIC2Explosive {
    public boolean isITNT;

    public BlockITNT(Configuration config, InternalName internalName) {
        super(config, internalName, internalName == InternalName.blockITNT);
        this.isITNT = internalName == InternalName.blockITNT;
        this.func_71848_c(0.0f);
        this.func_71884_a(Block.field_71965_g);
    }

    @Override
    public boolean func_71903_a(World par1World, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        if (player.func_71045_bC() != null && player.func_71045_bC().field_77993_c == Item.field_77709_i.field_77779_bT && this.isITNT) {
            par1World.func_72921_c(x, y, z, 1, 7);
            this.removeBlockByPlayer(par1World, player, x, y, z);
            return true;
        }
        return super.func_71903_a(par1World, x, y, z, player, side, xOffset, yOffset, zOffset);
    }

    @Override
    public EntityIC2Explosive getExplosionEntity(World world, int x, int y, int z, EntityLivingBase igniter) {
        EntityIC2Explosive ret;
        if (this.isITNT) {
            ret = new EntityItnt(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        } else {
            TileEntity te = world.func_72796_p(x, y, z);
            if (te instanceof TileEntityNuke) {
                float NukeExplosivePower = ((TileEntityNuke)te).getNukeExplosivePower();
                if (NukeExplosivePower < 0.0f) {
                    return null;
                }
                int RadiationRange = ((TileEntityNuke)te).getRadiationRange();
                ret = new EntityNuke(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, NukeExplosivePower, RadiationRange);
            } else {
                return null;
            }
        }
        ret.setIgniter(igniter);
        return ret;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        if (!this.isITNT && entityliving instanceof EntityPlayer) {
            IC2.log.log(Level.INFO, "Player " + ((EntityPlayer)entityliving).field_71092_bJ + " placed a nuke at " + world.field_73011_w.field_76574_g + ":(" + x + "," + y + "," + z + ")");
        }
    }

    @Override
    public void onIgnite(World world, EntityPlayer player, int x, int y, int z) {
        if (!this.isITNT) {
            IC2.log.log(Level.INFO, "Nuke at " + world.field_73011_w.field_76574_g + ":(" + x + "," + y + "," + z + ") was ignited " + (player == null ? "indirectly" : "by " + player.field_71092_bJ));
            TileEntity te = world.func_72796_p(x, y, z);
            if (te instanceof TileEntityNuke) {
                ((TileEntityNuke)te).onIgnite(player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return this.isITNT ? EnumRarity.common : EnumRarity.uncommon;
    }

    public void func_71879_a(int i, CreativeTabs tabs, List itemList) {
        if (this.isITNT || IC2.enableCraftingNuke) {
            super.func_71879_a(i, tabs, itemList);
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.internalName != InternalName.blockITNT;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.internalName != InternalName.blockITNT) {
            return new TileEntityNuke();
        }
        return null;
    }
}

