/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.IC2;
import ic2.core.block.BlockMetaData;
import ic2.core.block.EntityIC2Explosive;
import ic2.core.block.MaterialIC2TNT;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public abstract class BlockIC2Explosive
extends BlockMetaData {
    public boolean canExplodeByHand = false;

    public BlockIC2Explosive(Configuration config, InternalName internalName, boolean manual) {
        super(config, internalName, MaterialIC2TNT.instance, ItemBlockIC2.class);
        this.canExplodeByHand = manual;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        if (world.func_72864_z(x, y, z)) {
            this.removeBlockByPlayer(world, null, x, y, z);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int srcBlockId) {
        if (world.func_72864_z(x, y, z)) {
            this.removeBlockByPlayer(world, null, x, y, z);
        }
    }

    public int func_71925_a(Random random) {
        return 0;
    }

    public void func_71867_k(World world, int x, int y, int z, Explosion explosion) {
        EntityIC2Explosive entitytntprimed = this.getExplosionEntity(world, x, y, z, explosion == null ? null : explosion.func_94613_c());
        if (entitytntprimed == null) {
            return;
        }
        entitytntprimed.fuse = world.field_73012_v.nextInt(entitytntprimed.fuse / 4) + entitytntprimed.fuse / 8;
        world.func_72838_d((Entity)entitytntprimed);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        int l = world.func_72805_g(x, y, z);
        if (player != null && (l & 1) == 0 && !this.canExplodeByHand) {
            this.func_71929_a(world, x, y, z, new ItemStack(this.field_71990_ca, 1, 0));
        } else {
            EntityIC2Explosive entitytntprimed = this.getExplosionEntity(world, x, y, z, (EntityLivingBase)(player == null ? null : player));
            if (entitytntprimed == null) {
                return false;
            }
            this.onIgnite(world, player, x, y, z);
            world.func_72838_d((Entity)entitytntprimed);
            world.func_72956_a((Entity)entitytntprimed, "random.fuse", 1.0f, 1.0f);
        }
        world.func_94571_i(x, y, z);
        return false;
    }

    public abstract EntityIC2Explosive getExplosionEntity(World var1, int var2, int var3, int var4, EntityLivingBase var5);

    public void onIgnite(World world, EntityPlayer player, int x, int y, int z) {
    }
}

