/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.init.DefaultIds;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.Configuration;

public abstract class BlockBase
extends Block {
    protected final InternalName internalName;
    private static final int[][] facingAndSideToSpriteOffset = new int[][]{{3, 5, 1, 0, 4, 2}, {5, 3, 1, 0, 2, 4}, {0, 1, 3, 5, 4, 2}, {0, 1, 5, 3, 2, 4}, {0, 1, 2, 4, 3, 5}, {0, 1, 4, 2, 5, 3}};
    @SideOnly(value=Side.CLIENT)
    protected Icon[][] textures;

    public BlockBase(Configuration config, InternalName internalName, Material material) {
        this(config, internalName, material, ItemBlockIC2.class);
    }

    public BlockBase(Configuration config, InternalName internalName, Material material, Class<? extends ItemBlockIC2> itemClass) {
        super(IC2.getBlockIdFor(config, internalName, DefaultIds.get(internalName)), material);
        this.func_71864_b(internalName.name());
        this.func_71849_a(IC2.tabIC2);
        this.internalName = internalName;
        GameRegistry.registerBlock((Block)this, itemClass, (String)internalName.name());
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void func_94332_a(IconRegister var1);

    @SideOnly(value=Side.CLIENT)
    public abstract Icon func_71895_b(IBlockAccess var1, int var2, int var3, int var4, int var5);

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        int facing = this.getFacing(meta);
        int index = this.getTextureIndex(meta);
        int subIndex = this.getTextureSubIndex(facing, side);
        if (index >= this.textures.length) {
            return null;
        }
        try {
            return this.textures[index][subIndex];
        }
        catch (Exception e) {
            IC2.platform.displayError(e, "Side: " + side + "\n" + "Block: " + (Object)((Object)this) + "\n" + "Meta: " + meta + "\n" + "Facing: " + facing + "\n" + "Index: " + index + "\n" + "SubIndex: " + subIndex);
            return null;
        }
    }

    public String func_71917_a() {
        return super.func_71917_a().substring(5);
    }

    protected int getFacing(int meta) {
        return 3;
    }

    public int getFacing(IBlockAccess iBlockAccess, int x, int y, int z) {
        int meta = iBlockAccess.func_72805_g(x, y, z);
        return this.getFacing(meta);
    }

    protected String getTextureFolder(int index) {
        return null;
    }

    protected String getTextureName(int index) {
        Item item = Item.field_77698_e[this.field_71990_ca];
        if (!item.func_77614_k()) {
            if (index == 0) {
                return this.func_71917_a();
            }
            return null;
        }
        ItemStack itemStack = new ItemStack((Block)this, 1, index);
        String ret = item.func_77667_c(itemStack);
        if (ret == null) {
            return null;
        }
        return ret.replace("item", "block");
    }

    protected int getTextureIndex(int meta) {
        return meta;
    }

    public final int getTextureSubIndex(int facing, int side) {
        return facingAndSideToSpriteOffset[facing][side];
    }

    protected int getMetaCount() {
        int metaCount = 0;
        while (this.getTextureName(metaCount) != null) {
            ++metaCount;
        }
        return metaCount;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.common;
    }
}

