/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.AdvShapelessRecipe;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;

public class AdvRecipe
implements IRecipe {
    public ItemStack output;
    public Object[] input;
    public int inputWidth;
    public boolean hidden;

    public static void addAndRegister(ItemStack result, Object ... args) {
        CraftingManager.func_77594_a().func_77592_b().add(new AdvRecipe(result, args));
    }

    public AdvRecipe(ItemStack result, Object ... args) {
        if (result == null) {
            AdvRecipe.displayError("null result", null, null, false);
        }
        HashMap<Character, Object> charMapping = new HashMap<Character, Object>();
        ArrayList<String> inputArrangement = new ArrayList<String>();
        Character lastChar = null;
        for (Object input : args) {
            if (input instanceof String) {
                if (lastChar == null) {
                    if (!charMapping.isEmpty()) {
                        AdvRecipe.displayError("oredict name without preceding char", "Name: " + input, result, false);
                    }
                    inputArrangement.add((String)input);
                    continue;
                }
                charMapping.put(lastChar, input);
                lastChar = null;
                continue;
            }
            if (input instanceof Character) {
                if (lastChar != null) {
                    AdvRecipe.displayError("two consecutive char definitions", "Input: " + input + "\nprev. Input: " + lastChar, result, false);
                }
                lastChar = (Character)input;
                continue;
            }
            if (input instanceof ItemStack || input instanceof Block || input instanceof Item || input.getClass().isArray() || input instanceof Iterable) {
                if (lastChar == null) {
                    AdvRecipe.displayError("item without preceding char", "Input: " + input + "\nType: " + (input == null ? "null" : input.getClass().getName()), result, false);
                }
                if (input instanceof Block) {
                    input = new ItemStack((Block)input, 1, Short.MAX_VALUE);
                } else if (input instanceof Item) {
                    input = new ItemStack((Item)input, 1, Short.MAX_VALUE);
                }
                AdvRecipe.expand(input);
                charMapping.put(lastChar, input);
                lastChar = null;
                continue;
            }
            if (input instanceof Boolean) {
                this.hidden = (Boolean)input;
                continue;
            }
            AdvRecipe.displayError("unknown type", "Input: " + input + "\nType: " + (input == null ? "null" : input.getClass().getName()), result, false);
        }
        if (lastChar != null) {
            AdvRecipe.displayError("one or more unused mapping chars", "Letter: " + lastChar, result, false);
        }
        if (inputArrangement.size() == 0 || inputArrangement.size() > 3) {
            AdvRecipe.displayError("none or too many crafting rows", "Size: " + inputArrangement.size(), result, false);
        }
        if (charMapping.size() == 0) {
            AdvRecipe.displayError("no mapping chars", null, result, false);
        }
        this.inputWidth = ((String)inputArrangement.get(0)).length();
        this.input = new Object[this.inputWidth * inputArrangement.size()];
        int inputIndex = 0;
        for (String str : inputArrangement) {
            if (str.length() != this.inputWidth) {
                AdvRecipe.displayError("no fixed width", "Expected: " + this.inputWidth + "\nGot: " + str.length(), result, false);
            }
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == ' ') {
                    this.input[inputIndex++] = null;
                    continue;
                }
                if (!charMapping.containsKey(Character.valueOf(c))) {
                    AdvRecipe.displayError("missing char mapping", "Letter: " + c, result, false);
                }
                this.input[inputIndex++] = charMapping.get(Character.valueOf(c));
            }
        }
        this.output = result;
    }

    public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
        return this.func_77572_b(inventorycrafting) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
        int offerSize;
        int inputHeight = this.input.length / this.inputWidth;
        int n = offerSize = inventorycrafting.func_70302_i_() == 9 ? 3 : 2;
        if (offerSize < this.inputWidth || offerSize < inputHeight) {
            return null;
        }
        for (int xOffset = 0; xOffset <= offerSize - this.inputWidth; ++xOffset) {
            block1: for (int yOffset = 0; yOffset <= offerSize - inputHeight; ++yOffset) {
                int x;
                int y;
                int y2;
                int x2;
                int outputCharge = 0;
                for (x2 = 0; x2 < this.inputWidth; ++x2) {
                    for (y2 = 0; y2 < inputHeight; ++y2) {
                        ItemStack offer = inventorycrafting.func_70463_b(x2 + xOffset, y2 + yOffset);
                        Object request = this.input[x2 + y2 * this.inputWidth];
                        if (offer == null && request != null) continue block1;
                        if (offer == null) continue;
                        if (request == null) {
                            return null;
                        }
                        List<ItemStack> requestedItemStacks = AdvRecipe.expand(request);
                        boolean found = false;
                        for (ItemStack requestedItemStack : requestedItemStacks) {
                            if (offer.func_77973_b() instanceof IElectricItem) {
                                if (offer.field_77993_c != requestedItemStack.field_77993_c) continue;
                                outputCharge += ElectricItem.manager.getCharge(offer);
                                found = true;
                                break;
                            }
                            if (!offer.func_77969_a(requestedItemStack) && (requestedItemStack.func_77960_j() != Short.MAX_VALUE || offer.field_77993_c != requestedItemStack.field_77993_c)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return null;
                    }
                }
                for (x2 = 0; x2 < xOffset; ++x2) {
                    for (y2 = 0; y2 < offerSize; ++y2) {
                        if (inventorycrafting.func_70463_b(x2, y2) == null) continue;
                        return null;
                    }
                }
                for (y = 0; y < yOffset; ++y) {
                    for (x = 0; x < offerSize; ++x) {
                        if (inventorycrafting.func_70463_b(x, y) == null) continue;
                        return null;
                    }
                }
                for (x2 = xOffset + this.inputWidth; x2 < offerSize; ++x2) {
                    for (y2 = 0; y2 < offerSize; ++y2) {
                        if (inventorycrafting.func_70463_b(x2, y2) == null) continue;
                        return null;
                    }
                }
                for (y = yOffset + inputHeight; y < offerSize; ++y) {
                    for (x = 0; x < offerSize; ++x) {
                        if (inventorycrafting.func_70463_b(x, y) == null) continue;
                        return null;
                    }
                }
                ItemStack ret = this.output.func_77946_l();
                Item item = ret.func_77973_b();
                if (item instanceof IElectricItem) {
                    ElectricItem.manager.charge(ret, outputCharge, Integer.MAX_VALUE, true, false);
                } else if (item instanceof IFluidContainerItem) {
                    StackUtil.getOrCreateNbtData(ret);
                }
                return ret;
            }
        }
        return null;
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public static boolean recipeContains(Object[] inputs, ItemStack item) {
        for (Object input : inputs) {
            if (input == null) continue;
            List<ItemStack> realInputs = AdvRecipe.expand(input);
            for (ItemStack realInput : realInputs) {
                if (!item.func_77969_a(realInput)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canShow(Object[] input, ItemStack output, boolean hidden) {
        return !hidden || !IC2.enableSecretRecipeHiding;
    }

    public static boolean canShow(AdvRecipe recipe) {
        return AdvRecipe.canShow(recipe.input, recipe.output, recipe.hidden);
    }

    public static boolean canShow(AdvShapelessRecipe recipe) {
        return AdvRecipe.canShow(recipe.input, recipe.output, recipe.hidden);
    }

    public static List<ItemStack> expand(Object o) {
        ArrayList ret = new ArrayList();
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("liquid$")) {
                String name = s.substring(7);
                for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    Fluid fluid = data.fluid.getFluid();
                    if (fluid == null || !name.equals(fluid.getName())) continue;
                    ret.add(data.filledContainer);
                }
            } else {
                ret = OreDictionary.getOres((String)((String)o));
            }
        } else if (o instanceof ItemStack) {
            ret.add((ItemStack)o);
        } else if (o.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                ret.addAll(AdvRecipe.expand(Array.get(o, i)));
            }
        } else if (o instanceof Iterable) {
            for (Object o2 : (Iterable)o) {
                ret.addAll(AdvRecipe.expand(o2));
            }
        } else {
            AdvRecipe.displayError("unknown type", "Input: " + o + "\nType: " + (o == null ? "null" : o.getClass().getName()), null, false);
            return null;
        }
        return ret;
    }

    public static void displayError(String cause, String tech, ItemStack result, boolean shapeless) {
        String source = "unknown";
        for (StackTraceElement st : Thread.currentThread().getStackTrace()) {
            String pkg;
            String className = st.getClassName();
            int pkgSeparator = className.lastIndexOf(46);
            String string = pkg = pkgSeparator == -1 ? "" : className.substring(0, pkgSeparator);
            if (pkg.equals("ic2.core") || pkg.startsWith("ic2.api") || pkg.startsWith("java.")) continue;
            source = className + "." + st.getMethodName() + "(" + st.getFileName() + ":" + st.getLineNumber() + ")";
            break;
        }
        IC2.platform.displayError("An invalid crafting recipe was attempted to be added. This could\nhappen due to a bug in IndustrialCraft 2 or an addon.\n\n(Technical information: Adv" + (shapeless ? "Shapeless" : "") + "Recipe, " + cause + ")\n" + (result != null ? "Output: " + result + "\n" : "") + (tech != null ? tech + "\n" : "") + "Source: " + source);
    }
}

