/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntegration.core;

import buildcraft.api.gates.ITriggerParameter;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.bcIntegration.core.Trigger;
import ic2.bcIntegration.core.TriggerType;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.block.wiring.TileEntityElectricBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerCapacitor
extends Trigger {
    public TriggerCapacitor(TriggerType type, int legacyId) {
        super(type, legacyId);
    }

    @Override
    public String getDescription() {
        switch (this.type) {
            case CapacitorEmpty: {
                return "Capacitor Empty";
            }
            case CapacitorHasEnergy: {
                return "Capacitor Has Energy";
            }
            case CapacitorHasRoom: {
                return "Space For Energy";
            }
            case CapacitorFull: {
                return "Capacitor Full";
            }
            case ChargeEmpty: {
                return "Charging Empty Item";
            }
            case ChargePartial: {
                return "Charging Partially Charged Item";
            }
            case ChargeFull: {
                return "Charging Fully Charged Item";
            }
            case DischargeEmpty: {
                return "Discharging Empty Item";
            }
            case DischargePartial: {
                return "Discharging Partially Charged Item";
            }
            case DischargeFull: {
                return "Discharging Fully Charged Item";
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityStandardMachine) {
            TileEntityStandardMachine teb = (TileEntityStandardMachine)tile;
            boolean hasEnergy = teb.energy >= (double)teb.defaultEnergyConsume;
            boolean hasRoom = teb.energy <= (double)(teb.maxEnergy - teb.defaultEnergyConsume);
            boolean dischargeEnergy = this.canDischarge(teb.dischargeSlot.get());
            boolean dischargeRoom = this.canCharge(teb.dischargeSlot.get());
            switch (this.type) {
                case CapacitorEmpty: {
                    return !hasEnergy;
                }
                case CapacitorHasEnergy: {
                    return hasEnergy;
                }
                case CapacitorHasRoom: {
                    return hasRoom;
                }
                case CapacitorFull: {
                    return !hasRoom;
                }
                case DischargeEmpty: {
                    return !dischargeEnergy;
                }
                case DischargePartial: {
                    return dischargeEnergy && dischargeRoom;
                }
                case DischargeFull: {
                    return !dischargeRoom;
                }
            }
            return false;
        }
        if (tile instanceof TileEntityBaseGenerator) {
            TileEntityBaseGenerator teb = (TileEntityBaseGenerator)tile;
            boolean hasEnergy = teb.storage > 0.0;
            boolean hasRoom = teb.storage < (double)teb.maxStorage;
            boolean chargeEnergy = this.canDischarge(teb.chargeSlot.get());
            boolean chargeRoom = this.canCharge(teb.chargeSlot.get());
            switch (this.type) {
                case CapacitorEmpty: {
                    return !hasEnergy;
                }
                case CapacitorHasEnergy: {
                    return hasEnergy;
                }
                case CapacitorHasRoom: {
                    return hasRoom;
                }
                case CapacitorFull: {
                    return !hasRoom;
                }
                case ChargeEmpty: {
                    return !chargeEnergy;
                }
                case ChargePartial: {
                    return chargeEnergy && chargeRoom;
                }
                case ChargeFull: {
                    return !chargeRoom;
                }
            }
            return false;
        }
        if (tile instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock teb = (TileEntityElectricBlock)tile;
            boolean hasEnergy = teb.energy >= (double)teb.output;
            boolean hasRoom = teb.energy < (double)teb.maxStorage;
            boolean chargeEnergy = this.canDischarge(teb.chargeSlot.get());
            boolean chargeRoom = this.canCharge(teb.chargeSlot.get());
            boolean dischargeEnergy = this.canDischarge(teb.dischargeSlot.get());
            boolean dischargeRoom = this.canCharge(teb.dischargeSlot.get());
            switch (this.type) {
                case CapacitorEmpty: {
                    return !hasEnergy;
                }
                case CapacitorHasEnergy: {
                    return hasEnergy;
                }
                case CapacitorHasRoom: {
                    return hasRoom;
                }
                case CapacitorFull: {
                    return !hasRoom;
                }
                case ChargeEmpty: {
                    return !chargeEnergy;
                }
                case ChargePartial: {
                    return chargeEnergy && chargeRoom;
                }
                case ChargeFull: {
                    return !chargeRoom;
                }
                case DischargeEmpty: {
                    return !dischargeEnergy;
                }
                case DischargePartial: {
                    return dischargeEnergy && dischargeRoom;
                }
                case DischargeFull: {
                    return !dischargeRoom;
                }
            }
            return false;
        }
        return false;
    }

    private IElectricItem getElectricItem(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IElectricItem) {
            return (IElectricItem)item;
        }
        return null;
    }

    private boolean canDischarge(ItemStack itemStack) {
        IElectricItem electricItem = this.getElectricItem(itemStack);
        if (electricItem == null) {
            return false;
        }
        return ElectricItem.manager.getCharge(itemStack) > 0;
    }

    private boolean canCharge(ItemStack itemStack) {
        IElectricItem electricItem = this.getElectricItem(itemStack);
        if (electricItem == null) {
            return false;
        }
        return ElectricItem.manager.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) > 0;
    }
}

