/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreMapGenDungeon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class GCCoreDungeonRoom {
    public final GCCoreMapGenDungeon dungeonInstance;
    public World worldObj;
    public int posX;
    public int posY;
    public int posZ;
    public ForgeDirection entranceDir;

    public GCCoreDungeonRoom(GCCoreMapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        this.dungeonInstance = dungeon;
        this.worldObj = dungeon != null ? dungeon.worldObj : null;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.entranceDir = entranceDir;
    }

    public abstract void generate(short[] var1, byte[] var2, int var3, int var4);

    public abstract GCCoreDungeonBoundingBox getBoundingBox();

    protected abstract GCCoreDungeonRoom makeRoom(GCCoreMapGenDungeon var1, int var2, int var3, int var4, ForgeDirection var5);

    protected abstract void handleTileEntities(Random var1);

    public static GCCoreDungeonRoom makeRoom(GCCoreMapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.otherRooms.get(rand.nextInt(dungeon.otherRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    public static GCCoreDungeonRoom makeBossRoom(GCCoreMapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.bossRooms.get(rand.nextInt(dungeon.bossRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    public static GCCoreDungeonRoom makeTreasureRoom(GCCoreMapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.treasureRooms.get(rand.nextInt(dungeon.treasureRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    protected boolean placeBlock(short[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, int id, int meta) {
        if (GCCoreMapGenDungeon.useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return false;
            }
            int index = this.getIndex(x, y, z);
            blocks[index] = (short)id;
            metas[index] = (byte)meta;
        } else {
            this.worldObj.func_72832_d(x, y, z, id, meta, 0);
        }
        return true;
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }
}

