/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.core.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityUniversalElectrical;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreTileEntityEnergyStorageModule
extends GCCoreTileEntityUniversalElectrical
implements IPacketReceiver,
ISidedInventory {
    private ItemStack[] containingItems = new ItemStack[2];
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledEnergyLevel;
    public int lastScaledEnergyLevel;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.scaledEnergyLevel = (int)Math.floor(this.getEnergyStored() * 16.0f / this.getMaxEnergyStored());
        if (this.scaledEnergyLevel != this.lastScaledEnergyLevel) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if (!this.field_70331_k.field_72995_K) {
            this.recharge(this.containingItems[0]);
            this.discharge(this.containingItems[1]);
        }
        this.setEnergyStored(this.getEnergyStored() - 5.0E-5f);
        if (!this.field_70331_k.field_72995_K) {
            this.produce();
        }
        this.lastScaledEnergyLevel = this.scaledEnergyLevel;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return StatCollector.func_74838_a((String)"tile.machine.1.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof IItemElectric;
    }

    public int[] func_94128_d(int slotID) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            if (slotID == 0) {
                return ((IItemElectric)itemstack.func_77973_b()).getTransfer(itemstack) > 0.0f;
            }
            if (slotID == 1) {
                return ((IItemElectric)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
            }
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            if (slotID == 0) {
                return ((IItemElectric)itemstack.func_77973_b()).getTransfer(itemstack) <= 0.0f;
            }
            if (slotID == 1) {
                return ((IItemElectric)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f || this.getEnergyStored() >= this.getMaxEnergyStored();
            }
        }
        return false;
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        return this.getElectricalInputDirections().contains(direction) ? this.getMaxEnergyStored() - this.getEnergyStored() : 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return this.getElectricalOutputDirections().contains(direction) ? Math.min(1.3f, this.getEnergyStored()) : 0.0f;
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_70322_n() - 4 + 2)).getOpposite(), ForgeDirection.UNKNOWN);
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_70322_n() - 4 + 2)), ForgeDirection.UNKNOWN);
    }

    @Override
    public float getMaxEnergyStored() {
        return 2500.0f;
    }
}

