/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.UniversalNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAdvanced;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public abstract class GCCoreTileEntityConductor
extends GCCoreTileEntityAdvanced
implements IConductor {
    private IGridNetwork network;
    public TileEntity[] adjacentConnections = null;

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_70313_j();
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public IGridNetwork getNetwork() {
        if (this.network == null) {
            UniversalNetwork network = new UniversalNetwork();
            network.getTransmitters().add(this);
            this.setNetwork(network);
        }
        return this.network;
    }

    @Override
    public void setNetwork(IGridNetwork network) {
        this.network = network;
    }

    @Override
    public void refresh() {
        if (!this.field_70331_k.field_72995_K) {
            this.adjacentConnections = null;
            ForgeDirection[] arr$ = ForgeDirection.VALID_DIRECTIONS;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Vector3 thisVec = new Vector3(this);
                ForgeDirection side = arr$[i$];
                TileEntity tileEntity = thisVec.modifyPositionFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity == null || tileEntity.getClass() != this.getClass() || !(tileEntity instanceof INetworkProvider) || this.getNetwork().equals(((INetworkProvider)tileEntity).getNetwork())) continue;
                this.setNetwork(this.getNetwork().merge(((INetworkProvider)tileEntity).getNetwork()));
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = new TileEntity[6];
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                Vector3 thisVec = new Vector3(this);
                ForgeDirection side = ForgeDirection.getOrientation((int)i);
                TileEntity tileEntity = thisVec.modifyPositionFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tileEntity instanceof IConnector) || !((IConnector)tileEntity).canConnect(side.getOpposite(), NetworkType.POWER)) continue;
                this.adjacentConnections[i] = tileEntity;
            }
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return type == NetworkType.POWER;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.POWER;
    }
}

