/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;

public abstract class GCCoreTileEntityAdvanced
extends TileEntity
implements IPacketReceiver {
    protected long ticks = 0L;
    private LinkedHashSet<Field> fieldCacheClient;
    private LinkedHashSet<Field> fieldCacheServer;

    public void func_70316_g() {
        if (this.ticks == 0L) {
            this.initiate();
        }
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        if (this.isNetworkedTile() && this.ticks % (long)this.getPacketCooldown() == 0L) {
            if (this.fieldCacheClient == null || this.fieldCacheServer == null) {
                try {
                    this.initFieldCache();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.field_70331_k.field_72995_K && this.fieldCacheServer.size() > 0) {
                this.sendPackets();
            } else if (!this.field_70331_k.field_72995_K && this.fieldCacheClient.size() > 0) {
                this.sendPackets();
            }
        }
    }

    private void sendPackets() {
        try {
            Packet packet = null;
            LinkedHashSet<Field> fieldList = null;
            fieldList = this.field_70331_k.field_72995_K ? this.fieldCacheServer : this.fieldCacheClient;
            ArrayList<Object> objList = new ArrayList<Object>();
            for (Field f : fieldList) {
                objList.add(f.get(this));
            }
            this.addExtraNetworkedData(objList);
            packet = GCCorePacketManager.getPacket("GCCoreEntities", this, objList);
            GCCorePacketManager.sendPacketToClients(packet, this.field_70331_k, new Vector3(this), this.getPacketRange());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initFieldCache() throws IllegalArgumentException, IllegalAccessException {
        this.fieldCacheClient = new LinkedHashSet();
        this.fieldCacheServer = new LinkedHashSet();
        for (Field field : this.getClass().getFields()) {
            if (!field.isAnnotationPresent(GCCoreAnnotations.NetworkedField.class)) continue;
            GCCoreAnnotations.NetworkedField f = field.getAnnotation(GCCoreAnnotations.NetworkedField.class);
            if (f.targetSide() == Side.CLIENT) {
                this.fieldCacheClient.add(field);
                continue;
            }
            this.fieldCacheServer.add(field);
        }
    }

    public abstract double getPacketRange();

    public abstract int getPacketCooldown();

    public abstract boolean isNetworkedTile();

    public void addExtraNetworkedData(List<Object> networkedList) {
    }

    public void readExtraNetworkedData(ByteArrayDataInput dataStream) {
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        if (this.fieldCacheClient == null || this.fieldCacheServer == null) {
            try {
                this.initFieldCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.field_70331_k.field_72995_K && this.fieldCacheClient.size() == 0) {
            return;
        }
        if (!this.field_70331_k.field_72995_K && this.fieldCacheServer.size() == 0) {
            return;
        }
        LinkedHashSet<Field> fieldSet = null;
        fieldSet = this.field_70331_k.field_72995_K ? this.fieldCacheClient : this.fieldCacheServer;
        for (Field field : fieldSet) {
            try {
                field.set(this, GCCorePacketManager.getFieldValueFromStream(field, dataStream, this.field_70331_k));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.readExtraNetworkedData(dataStream);
    }

    public void initiate() {
    }

    public int func_70322_n() {
        if (this.field_70325_p == -1) {
            this.field_70325_p = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return this.field_70325_p;
    }

    public Block func_70311_o() {
        if (this.field_70324_q == null) {
            this.field_70324_q = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)];
        }
        return this.field_70324_q;
    }
}

