/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityRefinery;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockRefinery
extends GCCoreBlockAdvancedTile {
    private final Random refineryRand = new Random();
    private Icon iconMachineSide;
    private Icon iconFuelOutput;
    private Icon iconOilInput;
    private Icon iconFront;
    private Icon iconBack;
    private Icon iconTop;

    protected GCCoreBlockRefinery(int id, String assetName) {
        super(id, Material.field_76246_e);
        this.func_71848_c(1.0f);
        this.func_71884_a(Block.field_71977_i);
        this.func_111022_d(GalacticraftCore.ASSET_PREFIX + assetName);
        this.func_71864_b(assetName);
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    public int func_71857_b() {
        return GalacticraftCore.proxy.getBlockRenderID(this.field_71990_ca);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_blank");
        this.iconFuelOutput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_fuel_input");
        this.iconOilInput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_oil_input");
        this.iconFront = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "refinery_front");
        this.iconBack = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "refinery_side");
        this.iconTop = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_input");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        TileEntity te = par1World.func_72796_p(par2, par3, par4);
        if (te instanceof GCCoreTileEntityRefinery) {
            GCCoreTileEntityRefinery refinery = (GCCoreTileEntityRefinery)te;
            if (refinery.processTicks > 0) {
                par1World.func_72805_g(par2, par3, par4);
                float var7 = (float)par2 + 0.5f;
                float var8 = (float)par3 + 1.1f;
                float var9 = (float)par4 + 0.5f;
                float var10 = 0.0f;
                float var11 = 0.0f;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        par1World.func_72869_a("smoke", (double)(var7 + 0.0f) + (double)i * 0.2, (double)var8, (double)(var9 + 0.0f) + (double)j * 0.2, 0.0, 0.01, 0.0);
                        par1World.func_72869_a("flame", (double)(var7 + 0.0f) + (double)i * 0.1, (double)var8 - 0.2, (double)(var9 + 0.0f) + (double)j * 0.1, 0.0, 1.0E-4, 0.0);
                    }
                }
            }
        }
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, x, y, z);
        return true;
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new GCCoreTileEntityRefinery();
    }

    @Override
    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        GCCoreTileEntityRefinery var7 = (GCCoreTileEntityRefinery)par1World.func_72796_p(par2, par3, par4);
        if (var7 != null) {
            for (int var8 = 0; var8 < var7.func_70302_i_(); ++var8) {
                ItemStack var9 = var7.func_70301_a(var8);
                if (var9 == null) continue;
                float var10 = this.refineryRand.nextFloat() * 0.8f + 0.1f;
                float var11 = this.refineryRand.nextFloat() * 0.8f + 0.1f;
                float var12 = this.refineryRand.nextFloat() * 0.8f + 0.1f;
                while (var9.field_77994_a > 0) {
                    int var13 = this.refineryRand.nextInt(21) + 10;
                    if (var13 > var9.field_77994_a) {
                        var13 = var9.field_77994_a;
                    }
                    var9.field_77994_a -= var13;
                    EntityItem var14 = new EntityItem(par1World, (double)((float)par2 + var10), (double)((float)par3 + var11), (double)((float)par4 + var12), new ItemStack(var9.field_77993_c, var13, var9.func_77960_j()));
                    if (var9.func_77942_o()) {
                        var14.func_92059_d().func_77982_d((NBTTagCompound)var9.func_77978_p().func_74737_b());
                    }
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)this.refineryRand.nextGaussian() * 0.05f;
                    var14.field_70181_x = (float)this.refineryRand.nextGaussian() * 0.05f + 0.2f;
                    var14.field_70179_y = (float)this.refineryRand.nextGaussian() * 0.05f;
                    par1World.func_72838_d((Entity)var14);
                }
            }
        }
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == metadata + 2) {
            return this.iconFuelOutput;
        }
        if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
            return this.iconOilInput;
        }
        if (side == 1) {
            return this.iconTop;
        }
        if (side == 0) {
            return this.iconMachineSide;
        }
        if (metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
            return this.iconFront;
        }
        return this.iconBack;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
    }
}

